/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.javasound;

import de.jreality.audio.AudioBackend;
import de.jreality.audio.SoundEncoder;
import de.jreality.util.Input;
import java.io.IOException;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;

public class JavaSoundUtility {
    public static boolean chooseFirstMixer = true;
    public static boolean BIG_ENDIAN = false;
    public static int BITS_PER_SAMPLE = 16;
    private static Mixer CURRENT_MIXER;
    private static int sampleRate;

    private JavaSoundUtility() {
    }

    public static int getSampleRate() {
        return sampleRate;
    }

    public static void setSampleRate(int sampleRate) {
        JavaSoundUtility.sampleRate = sampleRate;
    }

    public static boolean supportsChannels(int n) {
        AudioFormat f = JavaSoundUtility.outputFormat(n);
        SourceDataLine sdl = JavaSoundUtility.createSourceDataLine(f);
        return sdl != null;
    }

    public static SourceDataLine createSourceDataLine(AudioFormat audioFormat) {
        int idx;
        if (CURRENT_MIXER != null) {
            CURRENT_MIXER.close();
            CURRENT_MIXER = null;
        }
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        LinkedList<Mixer> possibleMixers = new LinkedList<Mixer>();
        LinkedList<SourceDataLine> mixerLines = new LinkedList<SourceDataLine>();
        for (Mixer.Info info : mixerInfos) {
            Mixer mixer = AudioSystem.getMixer(info);
            try {
                mixer.open();
            }
            catch (LineUnavailableException e) {
                mixer.close();
                continue;
            }
            if (!mixer.isLineSupported(dataLineInfo)) {
                mixer.close();
                continue;
            }
            try {
                SourceDataLine ret = (SourceDataLine)mixer.getLine(dataLineInfo);
                possibleMixers.add(mixer);
                mixerLines.add(ret);
            }
            catch (LineUnavailableException e) {
                // empty catch block
            }
        }
        if (possibleMixers.isEmpty()) {
            System.out.println("JavaSoundUtility.createSourceDataLine(): NO MIXER");
            return null;
        }
        if (possibleMixers.size() == 1) {
            return (SourceDataLine)mixerLines.get(0);
        }
        Object[] possibleInfos = new Mixer.Info[possibleMixers.size()];
        for (int i = 0; i < possibleMixers.size(); ++i) {
            possibleInfos[i] = ((Mixer)possibleMixers.get(i)).getMixerInfo();
        }
        Mixer.Info selectedInfo = null;
        selectedInfo = chooseFirstMixer ? possibleInfos[0] : (Mixer.Info)JOptionPane.showInputDialog(null, "Select audio device", "JavaSound", 0, null, possibleInfos, null);
        for (idx = 0; idx < possibleInfos.length && possibleInfos[idx] != selectedInfo; ++idx) {
        }
        SourceDataLine selectedLine = (SourceDataLine)mixerLines.get(idx);
        possibleMixers.remove(idx);
        for (Mixer m : possibleMixers) {
            m.close();
        }
        return selectedLine;
    }

    public static AudioFormat outputFormat(int channels) {
        return new AudioFormat(JavaSoundUtility.getSampleRate(), BITS_PER_SAMPLE, channels, true, BIG_ENDIAN);
    }

    public static final void floatToByte(byte[] byteSound, float[] dbuf) {
        JavaSoundUtility.floatToByte(byteSound, dbuf, BIG_ENDIAN);
    }

    public static final void floatToByte(byte[] byteSound, float[] dbuf, boolean bigEndian) {
        int bufsz = dbuf.length;
        int ib = 0;
        if (bigEndian) {
            for (int i = 0; i < bufsz; ++i) {
                short y = (short)(32767.0 * (double)dbuf[i]);
                byteSound[ib] = (byte)(y >> 8);
                byteSound[++ib] = (byte)(y & 0xFF);
                ++ib;
            }
        } else {
            for (int i = 0; i < bufsz; ++i) {
                short y = (short)(32767.0 * (double)dbuf[i]);
                byteSound[ib] = (byte)(y & 0xFF);
                byteSound[++ib] = (byte)(y >> 8);
                ++ib;
            }
        }
    }

    public static float[] readAudioFile(Input input) throws UnsupportedAudioFileException, IOException {
        AudioInputStream ain = AudioSystem.getAudioInputStream(input.getInputStream());
        return JavaSoundUtility.readAudioFile(ain);
    }

    public static float[] readAudioFile(AudioInputStream ain) {
        AudioFormat af = ain.getFormat();
        if (af.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            System.out.println("converting from format " + af);
            AudioFormat baseFormat = af;
            float inSampleRate = baseFormat.getSampleRate();
            if (inSampleRate == -1.0f) {
                inSampleRate = 44100.0f;
            }
            af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inSampleRate, 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, inSampleRate, false);
            System.out.println("to format " + af);
            ain = AudioSystem.getAudioInputStream(af, ain);
        }
        int bytesPerSample = af.getSampleSizeInBits() / 8;
        int nSamples = (int)ain.getFrameLength();
        float[] samples = new float[nSamples];
        byte[] buf = new byte[1024 * af.getFrameSize()];
        int read = -1;
        int idx = 0;
        try {
            while ((read = ain.read(buf)) != -1) {
                int readFrames = read / af.getFrameSize();
                for (int i = 0; i < readFrames; ++i) {
                    float v = JavaSoundUtility.getFloat(buf, i * af.getFrameSize(), bytesPerSample, false);
                    samples[idx++] = v;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return samples;
    }

    public static float getFloat(byte[] b, int offset, int bytes, boolean bigEndian) {
        float sample = 0.0f;
        int ret = 0;
        int length = bytes;
        int i = 0;
        while (i < bytes) {
            ret |= (b[offset + i] & 0xFF) << (bigEndian ? length : i + 1) * 8 - 8;
            ++i;
            --length;
        }
        switch (bytes) {
            case 1: {
                if (ret > 127) {
                    ret = ~ret + 1;
                    ret &= 0x7F;
                    ret = ~ret + 1;
                }
                sample = (float)((double)ret / 127.0);
                break;
            }
            case 2: {
                if (ret > Short.MAX_VALUE) {
                    ret = ~ret + 1;
                    ret &= Short.MAX_VALUE;
                    ret = ~ret + 1;
                }
                sample = (float)((double)ret / 32767.0);
                break;
            }
            case 3: {
                if (ret > 0x7FFFFF) {
                    ret = ~ret + 1;
                    ret &= 0x7FFFFF;
                    ret = ~ret + 1;
                }
                sample = (float)((double)ret / 8388608.0);
                break;
            }
            case 4: {
                sample = (float)((double)ret / 2.147483647E9);
            }
        }
        return sample;
    }

    public static void launchAudioThread(final AudioBackend backend, final SoundEncoder enc, final int framesize, String label) {
        Runnable soundRenderer = new Runnable(){

            public void run() {
                while (!Thread.interrupted()) {
                    backend.processFrame(enc, framesize);
                }
            }
        };
        Thread soundThread = new Thread(soundRenderer);
        soundThread.setName(label);
        soundThread.setPriority(10);
        soundThread.setDaemon(true);
        soundThread.start();
    }

    static {
        sampleRate = 44100;
    }
}

