/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.javasound;

import de.jreality.audio.RingBuffer;
import de.jreality.audio.RingBufferSource;
import de.jreality.audio.javasound.JavaSoundUtility;
import de.jreality.scene.AudioSource;
import de.jreality.util.Input;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioInputStreamSource
extends RingBufferSource {
    AudioInputStream audioStream;
    AudioFormat format;
    boolean loop;
    private URL url;

    public AudioInputStreamSource(String name, URL url, boolean loop) throws UnsupportedAudioFileException, IOException {
        this(name, AudioSystem.getAudioInputStream(Input.getInput(url).getInputStream()));
        this.url = url;
        this.loop = loop;
    }

    public AudioInputStreamSource(String name, Input input, boolean loop) throws UnsupportedAudioFileException, IOException {
        this(name, AudioSystem.getAudioInputStream(input.getInputStream()));
        this.loop = loop;
    }

    public AudioInputStreamSource(String name, AudioInputStream ain) {
        super(name);
        this.check(ain);
        this.sampleRate = (int)this.format.getSampleRate();
        this.ringBuffer = new RingBuffer(this.sampleRate);
    }

    private void check(AudioInputStream ain) {
        this.audioStream = ain;
        this.format = ain.getFormat();
        if (this.format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            System.out.println("converting from format " + this.format);
            AudioFormat baseFormat = this.format;
            float inSampleRate = baseFormat.getSampleRate();
            if (inSampleRate == -1.0f) {
                inSampleRate = 44100.0f;
            }
            this.format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inSampleRate, 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, inSampleRate, false);
            System.out.println("to format " + this.format);
            this.audioStream = AudioSystem.getAudioInputStream(this.format, ain);
        }
    }

    protected void reset() {
        if (this.url == null) {
            throw new UnsupportedOperationException("reset not supported without URL");
        }
        try {
            this.check(AudioSystem.getAudioInputStream(Input.getInput(this.url).getInputStream()));
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeSamples(int nRequested) {
        int bytesPerSample = this.format.getSampleSizeInBits() / 8;
        int frameSize = this.format.getFrameSize();
        byte[] buf = new byte[frameSize * nRequested];
        try {
            int read = this.readAMAP(nRequested, frameSize, buf);
            float[] fbuf = new float[nRequested];
            for (int i = 0; i < read; ++i) {
                fbuf[i] = JavaSoundUtility.getFloat(buf, frameSize * i, bytesPerSample, false);
            }
            this.ringBuffer.write(fbuf, 0, read);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int readAMAP(int nRequested, int frameSize, byte[] buf) throws IOException {
        int read = this.audioStream.read(buf) / frameSize;
        while (read < nRequested) {
            int nowRead = this.audioStream.read(buf, read * frameSize, (nRequested - read) * frameSize) / frameSize;
            if (nowRead == -1) {
                if (this.loop) {
                    this.reset();
                    continue;
                }
                this.state = AudioSource.State.STOPPED;
                this.reset();
                this.hasChanged = true;
                continue;
            }
            read += nowRead;
        }
        return read;
    }
}

