/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.SoundEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class VbapSoundEncoder
implements SoundEncoder {
    int channels;
    List<float[]> speakerInverseMatrices = new ArrayList<float[]>();
    double[][] speakers;
    float[] speakerDistances;
    protected float[] buf;
    private int[] channelIDs;
    private float[] g = new float[2];

    public VbapSoundEncoder(int numSpeakers, double[][] speakers, int[] channelIDs) {
        this.channels = numSpeakers;
        this.setSpeakerIDs(channelIDs);
        this.setSpeakerPositions(speakers);
    }

    public synchronized void setSpeakerPositions(double[][] speakers) {
        int i;
        System.out.println("new speaker pos: " + Arrays.toString((Object[])speakers));
        this.speakerInverseMatrices.clear();
        this.speakers = speakers;
        for (int i2 = 0; i2 < this.channels; ++i2) {
            this.speakers[i2][0] = speakers[i2][0];
            this.speakers[i2][1] = speakers[i2][1];
        }
        this.speakerDistances = new float[this.channels];
        float maxDist = 0.0f;
        for (i = 0; i < this.channels; ++i) {
            double[] s1 = speakers[i];
            float n1 = (float)Math.sqrt(s1[0] * s1[0] + s1[1] * s1[1]);
            double[] s2 = speakers[(i + 1) % this.channels];
            float n2 = (float)Math.sqrt(s2[0] * s2[0] + s2[1] * s2[1]);
            float[] m = new float[]{(float)s1[0] / n1, (float)s2[0] / n2, (float)s1[1] / n1, (float)s2[1] / n2};
            double d = 1.0 / (double)(m[0] * m[3] - m[1] * m[2]);
            float[] mi = new float[]{(float)(d * (double)m[3]), (float)(-d * (double)m[1]), (float)(-d * (double)m[2]), (float)(d * (double)m[0])};
            this.speakerInverseMatrices.add(mi);
            this.speakerDistances[i] = n1;
            maxDist = Math.max(maxDist, n1);
        }
        i = 0;
        while (i < this.channels) {
            int n = i++;
            this.speakerDistances[n] = this.speakerDistances[n] / maxDist;
        }
    }

    public synchronized double[][] getSpeakerPositions() {
        return this.speakers;
    }

    public synchronized int[] getSpeakerIDs() {
        return this.channelIDs;
    }

    public synchronized void setSpeakerIDs(int[] channelIDs) {
        this.channelIDs = channelIDs;
    }

    public void startFrame(int framesize) {
        if (this.buf == null || this.buf.length != framesize * this.channels) {
            this.buf = new float[framesize * this.channels];
        } else {
            Arrays.fill(this.buf, 0.0f);
        }
    }

    public abstract void finishFrame();

    public void encodeSample(float v, int i, float r0, float x0, float y0, float z0) {
        float r = (float)Math.sqrt(x0 * x0 + z0 * z0);
        if (r > 1.0E-6f) {
            int j;
            float x = -z0 / r;
            float y = -x0 / r;
            for (j = 0; j < this.channels && !this.solve(this.g, this.speakerInverseMatrices.get(j), x, y); ++j) {
            }
            int jn = (j + 1) % this.channels;
            int n = i * this.channels + this.channelIDs[j];
            this.buf[n] = this.buf[n] + this.speakerDistances[j] * v * this.g[0];
            int n2 = i * this.channels + this.channelIDs[jn];
            this.buf[n2] = this.buf[n2] + this.speakerDistances[jn] * v * this.g[1];
        } else {
            this.encodeSample(v, i);
        }
    }

    public void encodeSample(float v, int idx) {
        for (int j = 0; j < this.channels; ++j) {
            int n = idx * this.channels + this.channelIDs[j];
            this.buf[n] = this.buf[n] + this.speakerDistances[j] * v;
        }
    }

    private boolean solve(float[] g, float[] m, float x, float y) {
        g[0] = m[0] * x + m[1] * y;
        g[1] = m[2] * x + m[3] * y;
        if (g[0] >= 0.0f && g[1] >= 0.0f) {
            float n = (float)Math.sqrt(g[0] * g[0] + g[1] * g[1]);
            g[0] = g[0] / n;
            g[1] = g[1] / n;
            return true;
        }
        return false;
    }
}

