/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.RingBuffer;
import de.jreality.audio.RingBufferSource;

public abstract class SynthSource
extends RingBufferSource {
    protected long index = 0L;
    private float[] buffer = null;

    public SynthSource(String name, int samplerate) {
        super(name);
        this.sampleRate = samplerate;
        this.ringBuffer = new RingBuffer(samplerate);
    }

    protected void writeSamples(int n) {
        if (this.buffer == null || this.buffer.length < n) {
            this.buffer = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = this.nextSample();
            ++this.index;
        }
        this.ringBuffer.write(this.buffer, 0, n);
    }

    protected abstract float nextSample();

    protected void reset() {
        this.index = 0L;
    }
}

