/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.Interpolation;
import de.jreality.audio.SampleProcessor;
import de.jreality.scene.data.SampleReader;
import de.jreality.shader.EffectiveAppearance;
import java.util.Arrays;

public class ShiftProcessor
extends SampleProcessor {
    private static final float WINDOW_SIZE = 0.025f;
    private float[] inBuf;
    private int bufSize;
    private int writeIndex = 0;
    private int readIndex = 0;
    private int index1;
    private int index2;
    private int windowSize;
    private float halfWindow;
    private float alpha = 0.0f;
    private float phase1;
    private Interpolation inter1 = new Interpolation.Cubic();
    private Interpolation inter2 = new Interpolation.Cubic();
    private boolean reset1;
    private boolean reset2;
    private float qEnv;

    public ShiftProcessor(SampleReader reader) {
        super(reader);
        int sr;
        this.bufSize = sr = reader.getSampleRate();
        this.inBuf = new float[this.bufSize];
        this.windowSize = (int)(0.025f * (float)sr);
        this.halfWindow = (float)this.windowSize / 2.0f;
        this.phase1 = 0.0f;
        this.readIndex = this.bufSize - this.windowSize;
        this.reset2 = true;
        this.reset1 = true;
        this.qEnv = (float)Math.PI / (float)this.windowSize;
    }

    public void setProperties(EffectiveAppearance app) {
        super.setProperties(app);
        float q = app.getAttribute("pitchShiftKey", 1.0f);
        this.setPitchShift(q);
    }

    public void setPitchShift(float q) {
        if ((double)q < 0.25 || q > 4.0f) {
            throw new IllegalArgumentException("pitch shift out of range: " + q);
        }
        this.alpha = q - 1.0f;
    }

    public void clear() {
        super.clear();
        this.inter1.reset();
        this.inter2.reset();
        Arrays.fill(this.inBuf, 0.0f);
    }

    public int read(float[] buffer, int initialIndex, int samples) {
        int nRead = this.readInput(samples);
        for (int i = 0; i < nRead; ++i) {
            float phase2 = this.phase1 < this.halfWindow ? this.phase1 + this.halfWindow : this.phase1 - this.halfWindow;
            int p1 = (int)this.phase1;
            int p2 = (int)phase2;
            int j1 = (this.readIndex + p1) % this.bufSize;
            int j2 = (this.readIndex + p2) % this.bufSize;
            if (this.reset1) {
                this.index1 = j1;
                this.reset1 = false;
            } else {
                while (this.index1 != j1) {
                    this.inter1.put(this.inBuf[this.index1++]);
                    if (this.index1 < this.bufSize) continue;
                    this.index1 -= this.bufSize;
                }
            }
            if (this.reset2) {
                this.index2 = j2;
                this.reset2 = false;
            } else {
                while (this.index2 != j2) {
                    this.inter2.put(this.inBuf[this.index2++]);
                    if (this.index2 < this.bufSize) continue;
                    this.index2 -= this.bufSize;
                }
            }
            buffer[initialIndex + i] = this.inter1.get(this.phase1 - (float)p1) * this.envelope(this.phase1) + this.inter2.get(phase2 - (float)p2) * this.envelope(phase2);
            float p = this.phase1 + this.alpha;
            if (this.phase1 < this.halfWindow && p >= this.halfWindow) {
                this.reset2 = true;
            } else if (this.phase1 >= this.halfWindow && p < this.halfWindow) {
                this.reset2 = true;
            }
            this.phase1 = p;
            if (this.phase1 >= (float)this.windowSize) {
                this.phase1 -= (float)this.windowSize;
                this.reset1 = true;
            } else if (this.phase1 < 0.0f) {
                this.phase1 += (float)this.windowSize;
                this.reset1 = true;
            }
            ++this.readIndex;
            if (this.readIndex < this.bufSize) continue;
            this.readIndex -= this.bufSize;
        }
        return nRead;
    }

    private float envelope(float t) {
        return (float)Math.sin(this.qEnv * t);
    }

    private int readInput(int samples) {
        int nRead;
        if (this.bufSize - this.writeIndex < samples) {
            nRead = this.reader.read(this.inBuf, this.writeIndex, this.bufSize - this.writeIndex);
            this.writeIndex += nRead;
            if (this.writeIndex >= this.bufSize) {
                this.writeIndex = this.reader.read(this.inBuf, 0, samples - nRead);
                nRead += this.writeIndex;
            }
        } else {
            nRead = this.reader.read(this.inBuf, this.writeIndex, samples);
            this.writeIndex += nRead;
            if (this.writeIndex >= this.bufSize) {
                this.writeIndex -= this.bufSize;
            }
        }
        return nRead;
    }
}

