/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.SampleProcessor;
import de.jreality.scene.data.SampleReader;
import de.jreality.shader.EffectiveAppearance;
import java.util.Arrays;

public class SchroederReverb
extends SampleProcessor {
    private static final float[] delays = new float[]{0.0297f, 0.0371f, 0.0411f, 0.0437f, 0.09683f, 0.03292f};
    private float[] coeffs = new float[6];
    private float[][] delayLines = new float[6][];
    private int[] lineIndices = new int[6];
    private float reverbTime = 1.5f;

    public SchroederReverb(SampleReader reader) {
        super(reader);
        int sampleRate = reader.getSampleRate();
        for (int i = 0; i < 6; ++i) {
            this.delayLines[i] = new float[(int)((double)((float)sampleRate * delays[i] * 2.0f) + 0.5)];
        }
        this.setReverbTime(this.reverbTime);
    }

    public void setProperties(EffectiveAppearance app) {
        super.setProperties(app);
        float reverbTime = app.getAttribute("reverbTime", 1.5f);
        if (reverbTime != this.getReverbTime()) {
            this.setReverbTime(reverbTime);
        }
    }

    public void setReverbTime(float reverbTime) {
        this.reverbTime = reverbTime;
        float q0 = (float)Math.log(0.001);
        float q = q0 / reverbTime;
        for (int i = 0; i < 4; ++i) {
            this.coeffs[i] = (float)Math.exp(q * delays[i]);
        }
        this.coeffs[4] = (float)Math.exp((double)(q0 * delays[4]) / 0.005);
        this.coeffs[5] = (float)Math.exp((double)(q0 * delays[5]) / 0.0017);
    }

    public float getReverbTime() {
        return this.reverbTime;
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(this.delayLines[i], 0.0f);
        }
    }

    public int read(float[] buf, int initialIndex, int samples) {
        int nRead = this.reader.read(buf, initialIndex, samples);
        int terminalIndex = initialIndex + nRead;
        for (int i = initialIndex; i < terminalIndex; ++i) {
            float acc = 0.0f;
            float v = buf[i];
            for (int j = 0; j < 4; ++j) {
                float w = this.currentFilterValue(j);
                acc += w;
                this.setFilterValue(j, this.coeffs[j] * w + v);
                this.advanceFilterIndex(j);
            }
            float y1 = this.currentFilterValue(4);
            float z = this.coeffs[4] * y1 + acc;
            this.setFilterValue(4, z);
            this.advanceFilterIndex(4);
            y1 -= this.coeffs[4] * z;
            float y2 = this.currentFilterValue(5);
            z = this.coeffs[5] * y2 + y1;
            this.setFilterValue(5, this.coeffs[5] * y2 + y1);
            this.advanceFilterIndex(5);
            buf[i] = y2 - this.coeffs[5] * z;
        }
        return nRead;
    }

    private void advanceFilterIndex(int j) {
        int i = this.lineIndices[j] + 1;
        this.lineIndices[j] = i < this.delayLines[j].length ? i : i - this.delayLines[j].length;
    }

    private float currentFilterValue(int j) {
        return this.delayLines[j][this.lineIndices[j]];
    }

    private float setFilterValue(int j, float v) {
        float f = v;
        this.delayLines[j][this.lineIndices[j]] = f;
        return f;
    }
}

