/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

public interface Interpolation {
    public void put(float var1);

    public float get(float var1);

    public void reset();

    public static final class Cubic
    implements Interpolation {
        public static final Factory FACTORY = new Factory(){

            public Interpolation newInterpolation() {
                return new Cubic();
            }
        };
        private float v0;
        private float v1;
        private float v2;
        private float v3;
        private float a0;
        private float a1;
        private float a2;
        private float a3;
        private boolean dirty;

        public float get(float t) {
            if (this.dirty) {
                this.a0 = this.v3 - this.v2 - this.v0 + this.v1;
                this.a1 = this.v0 - this.v1 - this.a0;
                this.a2 = this.v2 - this.v0;
                this.a3 = this.v1;
                this.dirty = false;
            }
            float t2 = t * t;
            return this.a0 * t * t2 + this.a1 * t2 + this.a2 * t + this.a3;
        }

        public void put(float v) {
            this.v0 = this.v1;
            this.v1 = this.v2;
            this.v2 = this.v3;
            this.v3 = v;
            this.dirty = true;
        }

        public void reset() {
            this.v3 = 0.0f;
            this.v2 = 0.0f;
            this.v1 = 0.0f;
            this.v0 = 0.0f;
            this.dirty = true;
        }
    }

    public static final class Cosine
    implements Interpolation {
        public static final Factory FACTORY = new Factory(){

            public Interpolation newInterpolation() {
                return new Cosine();
            }
        };
        private float v;
        private float dv;

        public float get(float t) {
            float s = (float)(1.0 - Math.cos((double)t * Math.PI)) / 2.0f;
            return this.v + s * this.dv;
        }

        public void put(float v) {
            this.v += this.dv;
            this.dv = v - this.v;
        }

        public void reset() {
            this.dv = 0.0f;
            this.v = 0.0f;
        }
    }

    public static final class Linear
    implements Interpolation {
        public static final Factory FACTORY = new Factory(){

            public Interpolation newInterpolation() {
                return new Linear();
            }
        };
        private float v;
        private float dv;

        public float get(float t) {
            return this.v + t * this.dv;
        }

        public void put(float v) {
            this.v += this.dv;
            this.dv = v - this.v;
        }

        public void reset() {
            this.dv = 0.0f;
            this.v = 0.0f;
        }
    }

    public static final class SampleHold
    implements Interpolation {
        public static final Factory FACTORY = new Factory(){

            public Interpolation newInterpolation() {
                return new SampleHold();
            }
        };
        private float v;

        public float get(float t) {
            return this.v;
        }

        public void put(float v) {
            this.v = v;
        }

        public void reset() {
            this.v = 0.0f;
        }
    }

    public static interface Factory {
        public Interpolation newInterpolation();
    }
}

