/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.AmbisonicsSoundEncoder;
import java.util.Arrays;

public abstract class Ambisonics2ndOrderSoundEncoder
extends AmbisonicsSoundEncoder {
    protected float[] br;
    protected float[] bs;
    protected float[] bt;
    protected float[] bu;
    protected float[] bv;

    public void startFrame(int framesize) {
        super.startFrame(framesize);
        if (this.br == null || this.br.length != framesize) {
            this.br = new float[framesize];
            this.bs = new float[framesize];
            this.bt = new float[framesize];
            this.bu = new float[framesize];
            this.bv = new float[framesize];
        } else {
            Arrays.fill(this.br, 0.0f);
            Arrays.fill(this.bs, 0.0f);
            Arrays.fill(this.bt, 0.0f);
            Arrays.fill(this.bu, 0.0f);
            Arrays.fill(this.bv, 0.0f);
        }
    }

    protected void encodeAmbiSample(float v, int idx, float x, float y, float z) {
        super.encodeAmbiSample(v, idx, x, y, z);
        int n = idx;
        this.br[n] = (float)((double)this.br[n] + (double)v * ((double)(1.5f * z * z) - 0.5));
        int n2 = idx;
        this.bs[n2] = this.bs[n2] + v * (2.0f * z * x);
        int n3 = idx;
        this.bt[n3] = this.bt[n3] + v * (2.0f * y * z);
        int n4 = idx;
        this.bu[n4] = this.bu[n4] + v * (x * x - y * y);
        int n5 = idx;
        this.bv[n5] = this.bv[n5] + v * (2.0f * x * y);
    }
}

