/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.plot;

import gda.analysis.DataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.IPlotData;

public class DataSetPlotData
implements IPlotData {
    private Map<String, DataSet> data = new HashMap<String, DataSet>(3);

    private DataSetPlotData() {
    }

    public DataSetPlotData(String string, DataSet dataSet) {
        this();
        this.data.put(string, dataSet);
    }

    @Override
    public IPlotData clone() {
        DataSetPlotData dataSetPlotData = new DataSetPlotData();
        for (String string : this.data.keySet()) {
            dataSetPlotData.data.put(string, this.data.get(string).clone());
        }
        return dataSetPlotData;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public List<Double> getData() {
        double[] dArray = this.getDataSet().getData();
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            arrayList.add(dArray[n]);
            ++n;
        }
        return arrayList;
    }

    public Map<String, DataSet> getDataMap() {
        return this.data;
    }

    @Override
    public DataSet getDataSet() {
        return this.data.values().iterator().next();
    }

    public Collection<DataSet> getDataSets() {
        return this.data.values();
    }

    @Override
    public boolean isDataSetValid() {
        for (String string : this.data.keySet()) {
            DataSet dataSet = this.data.get(string);
            if (dataSet.containsInfs()) {
                return false;
            }
            if (!dataSet.containsNans()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDataSetsValid() {
        return true;
    }

    @Override
    public boolean isMulti() {
        return this.data.size() > 1;
    }

    @Override
    public int size() {
        return this.data.values().iterator().next().getSize();
    }
}

