/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views.nexus;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetProvider;

public class ExpressionObject {
    private String expression;
    private String mementoKey;
    private DataSetProvider provider;
    private JEP jepParser;
    private AbstractDataset dataSet;

    public ExpressionObject(DataSetProvider dataSetProvider) {
        this(dataSetProvider, null, ExpressionObject.generateMementoKey());
    }

    public ExpressionObject(DataSetProvider dataSetProvider, String string, String string2) {
        this.provider = dataSetProvider;
        this.expression = string;
        this.mementoKey = string2;
    }

    public static boolean isExpressionKey(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.matches("Expression\\:(\\d)+");
    }

    private static String generateMementoKey() {
        return "Expression:" + new Date().getTime();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.dataSet = null;
        this.expression = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.expression == null ? 0 : this.expression.hashCode());
        n = 31 * n + (this.mementoKey == null ? 0 : this.mementoKey.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionObject expressionObject = (ExpressionObject)object;
        if (this.expression == null ? expressionObject.expression != null : !this.expression.equals(expressionObject.expression)) {
            return false;
        }
        return !(this.mementoKey == null ? expressionObject.mementoKey != null : !this.mementoKey.equals(expressionObject.mementoKey));
    }

    public String toString() {
        return this.expression != null ? this.expression : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(IProgressMonitor iProgressMonitor) {
        try {
            SymbolTable symbolTable = this.getSymbolTable();
            Iterator iterator = symbolTable.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object e = iterator.next();
                Object object = symbolTable.getValue(e);
                if (object != null) continue;
                if (iProgressMonitor.isCanceled()) {
                    return false;
                }
                if (!this.provider.isDataSetName(e.toString(), iProgressMonitor)) break;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getSize(IProgressMonitor iProgressMonitor) {
        if (this.dataSet == null) {
            try {
                this.getDataSet(iProgressMonitor);
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.dataSet != null ? this.dataSet.getSize() : 0;
    }

    public AbstractDataset getDataSet(IProgressMonitor iProgressMonitor) throws Exception {
        if (this.dataSet != null) {
            return this.dataSet;
        }
        if (this.expression == null || this.provider == null) {
            return new DoubleDataset();
        }
        List<IDataset> list = this.getVariables(iProgressMonitor);
        double[] dArray = new double[list.get(0).getSize()];
        int n = 0;
        while (n < dArray.length) {
            for (IDataset iDataset : list) {
                this.jepParser.addVariable(iDataset.getName(), iDataset.getDouble(new int[]{n}));
            }
            this.jepParser.parseExpression(this.expression);
            dArray[n] = this.jepParser.getValue();
            ++n;
        }
        this.dataSet = new DoubleDataset(dArray, new int[0]);
        this.dataSet.setName(this.getExpression());
        return this.dataSet;
    }

    private List<IDataset> getVariables(IProgressMonitor iProgressMonitor) throws Exception {
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>(7);
        SymbolTable symbolTable = this.getSymbolTable();
        for (Object e : symbolTable.keySet()) {
            IDataset iDataset;
            Iterator iterator = symbolTable.getValue(e);
            if (iterator != null) continue;
            if (iProgressMonitor.isCanceled()) {
                return null;
            }
            IDataset iDataset2 = iDataset = this.provider != null ? this.provider.getDataSet(e.toString(), iProgressMonitor) : null;
            if (iDataset == null) continue;
            arrayList.add(iDataset);
        }
        if (arrayList.isEmpty()) {
            throw new Exception("No variables recognized in expression.");
        }
        int n = ((IDataset)arrayList.get(0)).getSize();
        for (IDataset iDataset : arrayList) {
            if (iDataset.getSize() == n) continue;
            throw new Exception("Data sets in expression are not all the same size.");
        }
        return arrayList;
    }

    private SymbolTable getSymbolTable() throws ParseException {
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(true);
        this.jepParser.setImplicitMul(true);
        this.jepParser.parse(this.expression);
        return this.jepParser.getSymbolTable();
    }

    public DataSetProvider getProvider() {
        return this.provider;
    }

    public void setProvider(DataSetProvider dataSetProvider) {
        this.provider = dataSetProvider;
    }

    public String getMementoKey() {
        return this.mementoKey;
    }

    public void setMementoKey(String string) {
        this.mementoKey = string;
    }

    public void clear() {
        this.dataSet = null;
    }
}

