/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.util;

import gda.analysis.DataSet;
import gda.analysis.io.NexusLoader;
import gda.data.nexus.Activator;
import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;
import uk.ac.gda.util.io.SortingUtils;

public class NexusUtils {
    private static Logger logger = LoggerFactory.getLogger(NexusUtils.class);

    public static DataHolder loadTree(String string, IProgressMonitor iProgressMonitor) throws Exception {
        return NexusUtils.loadTree(string, null, iProgressMonitor);
    }

    public static NexusTreeNodeSelection getSel() throws Exception {
        String string = "<?xml version='1.0' encoding='UTF-8'?><nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXentry</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdata</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><wanted>2</wanted><dataType>1</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXinstrument</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdetector</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><wanted>2</wanted><dataType>1</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection>";
        return NexusTreeNodeSelection.createFromXML((InputSource)new InputSource(new StringReader(string)));
    }

    public static DataHolder loadTree(String string, NexusTreeNodeSelection nexusTreeNodeSelection, IProgressMonitor iProgressMonitor) throws Exception {
        Bundle bundle;
        Activator activator;
        if (nexusTreeNodeSelection == null) {
            nexusTreeNodeSelection = NexusTreeNodeSelection.GET_ALL;
        }
        if ((activator = Activator.getDefault()) != null && (bundle = activator.getBundle()) != null) {
            bundle.update();
        }
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return null;
        }
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return null;
        }
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return null;
        }
        long l = System.nanoTime();
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return null;
        }
        DataHolder dataHolder = new NexusLoader(string, NexusTreeNodeSelection.SKIP, nexusTreeNodeSelection, null).loadFile((IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        iProgressMonitor.worked(3);
        logger.info("Loading tree took {}s", (Object)((double)(System.nanoTime() - l) * 1.0E-9));
        return dataHolder;
    }

    public static Map<String, DataSet> getDataSets(String string, List<String> list, IProgressMonitor iProgressMonitor) throws Exception {
        NexusLoader nexusLoader = new NexusLoader(string, list);
        DataHolder dataHolder = nexusLoader.loadFile((IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        HashMap<String, DataSet> hashMap = new HashMap<String, DataSet>(list.size());
        for (String string2 : list) {
            hashMap.put(string2, dataHolder.getDataSet(string2));
        }
        return hashMap;
    }

    public static DataSet getDataSet(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        NexusLoader nexusLoader = new NexusLoader(string, Arrays.asList(string2));
        DataHolder dataHolder = nexusLoader.loadFile((IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        return dataHolder.getDataSet(string2);
    }

    public static List<String> getDataSetNames(String string, IProgressMonitor iProgressMonitor, List<Pattern> list) throws Exception {
        List list2 = NexusLoader.getDataSetNames((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        SortingUtils.removeIgnoredNames((Collection)list2, list);
        return list2;
    }

    public static Map<String, Integer> getDataSetSizes(String string, List<String> list, IProgressMonitor iProgressMonitor) throws Exception {
        Map map = NexusLoader.getDataSetNexusTrees((String)string, list, (boolean)false, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(list.size());
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put((String)entry.getKey(), NexusExtractor.calcTotalLength((int[])((INexusTree)entry.getValue()).getData().dimensions));
        }
        return hashMap;
    }
}

