/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.search.DataSearchResult;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.util.SearchUtils;

public class DataSearchQuery
implements ISearchQuery {
    private static Logger logger = LoggerFactory.getLogger(DataSearchQuery.class);
    private String label;
    private DataSearchResult result;
    private String searchString;
    private boolean caseSensitive;
    private boolean regularExpression;

    public DataSearchQuery(String string, boolean bl, boolean bl2) {
        this.label = "Search for files named '" + string + "'";
        this.searchString = string;
        this.caseSensitive = bl;
        this.regularExpression = bl2;
        this.result = new DataSearchResult(this.label, this);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject("Data");
        try {
            SearchUtils.searchNexus((IContainer)iProject, this.searchString, this.caseSensitive, this.regularExpression, this.result, iProgressMonitor);
        }
        catch (CoreException coreException) {
            logger.error("Search failed", (Throwable)coreException);
            throw new OperationCanceledException("cannot complete search " + this.searchString);
        }
        return Status.OK_STATUS;
    }
}

