/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetPlotView;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;
import uk.ac.gda.util.io.SortingUtils;
import uk.ac.gda.util.list.SortNatural;

public class DataSetComparisionDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(DataSetComparisionDialog.class);
    private final Collection<String> commonDataSets;
    private final Collection<String> allDataSets;
    private boolean isAllDataSets = false;
    private DataSetPlotView dataSetPlotView;
    private static DataSetComparisionDialog currentlyOpenChooser = null;

    public DataSetComparisionDialog(IWorkbenchPartSite iWorkbenchPartSite, final Object[] objectArray) throws Exception {
        super(iWorkbenchPartSite.getShell());
        this.setShellStyle(65584);
        this.commonDataSets = new HashSet<String>(31);
        this.allDataSets = new HashSet<String>(31);
        IProgressService iProgressService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        iProgressService.run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask("Extracting Data Sets from files...", 100);
                    DataSetComparisionDialog.this.createData(objectArray, iProgressMonitor);
                    iProgressMonitor.done();
                }
                catch (Exception exception) {
                    logger.error("Cannot open files", (Throwable)exception);
                }
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.dataSetPlotView = new DataSetPlotView(true, true, null);
        CLabel cLabel = new CLabel(composite2, 2113);
        cLabel.setBackground(composite2.getDisplay().getSystemColor(1));
        cLabel.setText("Please select one or more data. The first selection is used as the x-axis when\nmore than one selection is made.");
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        gridData.heightHint = 60;
        cLabel.setLayoutData((Object)gridData);
        this.dataSetPlotView.setData(this.getData(), null);
        this.dataSetPlotView.createPartControl(composite2);
        if (this.isAllDataSets) {
            gridData = new CLabel(composite2, 64);
            gridData.setText("The intersection of the data sets is empty so all data are shown.\nSome nexus files selected do not contain the data and will not be plotted.");
            gridData.setImage(SWTResourceManager.getImage(DataSetComparisionDialog.class, "/icons/error.png"));
        }
        gridData = new Button(composite2, 32);
        gridData.setToolTipText("If unchecked, only data common to all nexus files selected are shown");
        gridData.setText("Show all data");
        gridData.setSelection(this.isAllDataSets);
        gridData.addSelectionListener((SelectionListener)new SelectionAdapter((Button)gridData){
            private final /* synthetic */ Button val$btnShowAllData;
            {
                this.val$btnShowAllData = button;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataSetComparisionDialog.this.isAllDataSets = this.val$btnShowAllData.getSelection();
                DataSetComparisionDialog.this.dataSetPlotView.setData(DataSetComparisionDialog.this.getData(), null);
                DataSetComparisionDialog.this.dataSetPlotView.refresh();
            }
        });
        if (this.isAllDataSets) {
            gridData.setEnabled(false);
        }
        if (this.commonDataSets.size() == this.allDataSets.size()) {
            gridData.setVisible(false);
        }
        this.getShell().setText("Choose Data Sets to Compare");
        this.getShell().setMinimumSize(500, 200);
        return composite2;
    }

    private List<Object> getData() {
        Collection<String> collection = this.isAllDataSets ? this.allDataSets : this.commonDataSets;
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        arrayList.addAll(collection);
        Collections.sort(arrayList, new SortNatural(false));
        List<Object> list = this.getExpresions();
        if (list != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<Object> getExpresions() {
        DataSetPlotView dataSetPlotView = (DataSetPlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("uk.ac.gda.views.nexus.NexusPlotView");
        return dataSetPlotView != null ? dataSetPlotView.getExpressions(this.dataSetPlotView) : null;
    }

    private void createData(Object[] objectArray, IProgressMonitor iProgressMonitor) throws Exception {
        this.isAllDataSets = false;
        this.commonDataSets.clear();
        this.allDataSets.clear();
        boolean bl = true;
        int n = 0;
        while (n < objectArray.length) {
            Collection collection;
            String string = objectArray[n] instanceof File ? ((File)objectArray[n]).getAbsolutePath() : ((IFile)objectArray[n]).getLocation().toOSString();
            iProgressMonitor.worked(1);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            List<Pattern> list = DataSetPlotView.getIgnored();
            IMetaData iMetaData = LoaderFactory.getMetaData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
            Collection collection2 = collection = iMetaData != null ? iMetaData.getDataNames() : null;
            if (collection == null) {
                DataHolder dataHolder = LoaderFactory.getData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                collection = dataHolder != null ? dataHolder.getMap().keySet() : null;
            }
            SortingUtils.removeIgnoredNames((Collection)collection, list);
            if (bl) {
                this.commonDataSets.addAll(collection);
                bl = false;
            } else {
                this.commonDataSets.retainAll(collection);
            }
            this.allDataSets.addAll(collection);
            ++n;
        }
        if (this.commonDataSets.isEmpty()) {
            this.isAllDataSets = true;
        }
    }

    public int open() {
        int n = 1;
        try {
            currentlyOpenChooser = this;
            n = super.open();
        }
        finally {
            currentlyOpenChooser = null;
        }
        return n;
    }

    public static DataSetComparisionDialog getActiveDialog() {
        return currentlyOpenChooser;
    }

    public DataSetPlotView getDataSetPlotView() {
        return this.dataSetPlotView;
    }

    public List<Object> getSelections() {
        return this.dataSetPlotView.getSelections();
    }
}

