/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.math.Matrix;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.util.LinkedList;
import java.util.ListIterator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;

public class PlotActionTool
extends AbstractTool {
    protected static final InputSlot pointerSlot = InputSlot.getDevice((String)"PointerTransformation");
    protected Matrix pointerTrans = new Matrix();
    protected boolean geometryMatched;
    protected double[] pickedPointOC;
    protected LinkedList<PlotActionEventListener> listeners;

    public PlotActionTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(pointerSlot);
        this.listeners = new LinkedList();
    }

    public PlotActionTool(InputSlot inputSlot) {
        super(new InputSlot[]{inputSlot});
        this.addCurrentSlot(pointerSlot);
        this.listeners = new LinkedList();
    }

    public void activate(ToolContext toolContext) {
        this.perform(toolContext);
    }

    private void notifyListeners(PlotActionEvent plotActionEvent) {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            PlotActionEventListener plotActionEventListener = (PlotActionEventListener)listIterator.next();
            plotActionEventListener.plotActionPerformed(plotActionEvent);
        }
    }

    public void perform(ToolContext toolContext) {
        toolContext.getTransformationMatrix(pointerSlot).toDoubleArray(this.pointerTrans.getArray());
        boolean bl = this.geometryMatched = toolContext.getCurrentPick() != null;
        if (this.geometryMatched) {
            this.pickedPointOC = toolContext.getCurrentPick().getObjectCoordinates();
            if (toolContext.getCurrentPick().getPickType() == 4 || toolContext.getCurrentPick().getPickType() == 2) {
                String string = toolContext.getCurrentPick().getPickPath().getLastComponent().getName();
                if (string.indexOf(DataSet3DPlot1D.GRAPHNAMEPREFIX) != -1) {
                    PlotActionEvent plotActionEvent = new PlotActionEvent(this, this.pickedPointOC, 1);
                    this.notifyListeners(plotActionEvent);
                }
            } else {
                PlotActionEvent plotActionEvent = new PlotActionEvent(this, this.pickedPointOC, -1);
                this.notifyListeners(plotActionEvent);
            }
        }
    }

    public void addPlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.listeners.add(plotActionEventListener);
    }

    public void deactivate(ToolContext toolContext) {
    }
}

