/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.util.Rectangle3D;

public class CameraRotationTool
extends AbstractTool {
    static InputSlot activationSlot = InputSlot.getDevice((String)"RotateActivation");
    static InputSlot evolutionSlot = InputSlot.getDevice((String)"TrackballTransformation");
    static InputSlot camPath = InputSlot.getDevice((String)"WorldToCamera");
    transient SceneGraphComponent comp;
    transient Matrix center = new Matrix();
    transient EffectiveAppearance eap;
    boolean fixOrigin = false;
    private boolean rotateOnPick = false;
    private transient int metric;
    transient Matrix result = new Matrix();
    transient Matrix evolution = new Matrix();
    private boolean moveChildren;
    private boolean updateCenter;

    public CameraRotationTool() {
        super(new InputSlot[]{activationSlot});
        this.addCurrentSlot(evolutionSlot);
        this.addCurrentSlot(camPath);
    }

    public void activate(ToolContext toolContext) {
        this.comp = (this.moveChildren ? toolContext.getRootToLocal() : toolContext.getRootToToolComponent()).getLastComponent();
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        if (!this.fixOrigin) {
            PickResult pickResult = toolContext.getCurrentPick();
            this.center = this.rotateOnPick && pickResult != null ? this.getRotationPoint(toolContext) : this.getCenter(this.comp);
        }
        if (this.eap == null || !EffectiveAppearance.matches((EffectiveAppearance)this.eap, (SceneGraphPath)toolContext.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create((SceneGraphPath)toolContext.getRootToToolComponent());
        }
        this.metric = this.eap.getAttribute("metric", 0);
    }

    private Matrix getCenter(SceneGraphComponent sceneGraphComponent) {
        Matrix matrix = new Matrix();
        Rectangle3D rectangle3D = BoundingBoxUtility.calculateChildrenBoundingBox((SceneGraphComponent)sceneGraphComponent);
        MatrixBuilder.init(null, (int)this.metric).translate(rectangle3D.getCenter()).assignTo(matrix);
        return matrix;
    }

    private Matrix getRotationPoint(ToolContext toolContext) {
        PickResult pickResult = toolContext.getCurrentPick();
        double[] dArray = pickResult.getObjectCoordinates();
        double[] dArray2 = pickResult.getPickPath().getMatrix(null);
        SceneGraphPath sceneGraphPath = this.moveChildren ? toolContext.getRootToLocal() : toolContext.getRootToToolComponent();
        double[] dArray3 = sceneGraphPath.getInverseMatrix(null);
        double[] dArray4 = Rn.times(null, (double[])dArray3, (double[])dArray2);
        double[] dArray5 = Rn.matrixTimesVector(null, (double[])dArray4, (double[])dArray);
        Matrix matrix = new Matrix();
        MatrixBuilder.init(null, (int)this.metric).translate(dArray5).assignTo(matrix);
        return matrix;
    }

    public void perform(ToolContext toolContext) {
        Matrix matrix = new Matrix((this.moveChildren ? toolContext.getRootToLocal() : toolContext.getRootToToolComponent()).getInverseMatrix(null));
        if (Rn.isNan((double[])matrix.getArray())) {
            return;
        }
        try {
            matrix.assignFrom(P3.extractOrientationMatrix(null, (double[])matrix.getArray(), (double[])P3.originP3, (int)this.metric));
        }
        catch (Exception exception) {
            MatrixBuilder.euclidean().assignTo(matrix);
        }
        this.evolution.assignFrom(toolContext.getTransformationMatrix(evolutionSlot));
        this.evolution.conjugateBy(matrix);
        if (!this.fixOrigin && this.updateCenter) {
            PickResult pickResult = toolContext.getCurrentPick();
            this.center = this.rotateOnPick && pickResult != null ? this.getRotationPoint(toolContext) : this.getCenter(this.comp);
        }
        if (this.metric != 0) {
            P3.orthonormalizeMatrix((double[])this.evolution.getArray(), (double[])this.evolution.getArray(), (double)1.0E-7, (int)this.metric);
        }
        this.result.assignFrom(this.comp.getTransformation());
        if (!this.fixOrigin) {
            this.result.multiplyOnRight(this.center);
        }
        this.result.multiplyOnRight(this.evolution);
        if (!this.fixOrigin) {
            this.result.multiplyOnRight(this.center.getInverse());
        }
        if (Rn.isNan((double[])this.result.getArray())) {
            return;
        }
        this.comp.getTransformation().setMatrix(this.result.getArray());
        toolContext.getViewer().render();
    }

    public void deactivate(ToolContext toolContext) {
    }
}

