/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.math.Matrix;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.util.LinkedList;
import java.util.ListIterator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectListener;

public class AreaSelectTool
extends AbstractTool {
    private static final InputSlot pointerSlot = InputSlot.getDevice((String)"PointerTransformation");
    private Matrix pointerTrans = new Matrix();
    private boolean geometryMatched;
    private boolean initial = false;
    private double[] pickedPointOC;
    private int primID = -1;
    private LinkedList<AreaSelectListener> listeners;

    public AreaSelectTool() {
        super(new InputSlot[]{InputSlot.getDevice((String)"RotateActivation")});
        this.addCurrentSlot(pointerSlot);
        this.listeners = new LinkedList();
    }

    public void activate(ToolContext toolContext) {
        this.initial = true;
        this.perform(toolContext);
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            AreaSelectListener areaSelectListener = (AreaSelectListener)listIterator.next();
            AreaSelectEvent areaSelectEvent = new AreaSelectEvent(this, this.pickedPointOC, '\u0000', this.primID);
            areaSelectListener.areaSelectStart(areaSelectEvent);
        }
        this.initial = false;
    }

    public void addAreaSelectListener(AreaSelectListener areaSelectListener) {
        this.listeners.add(areaSelectListener);
    }

    public void perform(ToolContext toolContext) {
        Object object;
        Object object2;
        toolContext.getTransformationMatrix(pointerSlot).toDoubleArray(this.pointerTrans.getArray());
        boolean bl = this.geometryMatched = toolContext.getCurrentPick() != null;
        if (this.geometryMatched) {
            object2 = toolContext.getCurrentPick().getPickPath().getLastComponent().getName();
            this.primID = -1;
            if (((String)object2).contains("overlayPrim")) {
                object = ((String)object2).substring("overlayPrim".length());
                try {
                    this.primID = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.primID = -1;
                }
            }
            this.pickedPointOC = toolContext.getCurrentPick().getObjectCoordinates();
        }
        if (!this.initial) {
            object2 = this.listeners.listIterator();
            while (object2.hasNext()) {
                object = (AreaSelectListener)object2.next();
                AreaSelectEvent areaSelectEvent = new AreaSelectEvent(this, this.pickedPointOC, '\u0001', this.primID);
                object.areaSelectDragged(areaSelectEvent);
            }
        }
    }

    public void deactivate(ToolContext toolContext) {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            AreaSelectListener areaSelectListener = (AreaSelectListener)listIterator.next();
            AreaSelectEvent areaSelectEvent = new AreaSelectEvent(this, this.pickedPointOC, '\u0002', this.primID);
            areaSelectListener.areaSelectEnd(areaSelectEvent);
        }
    }
}

