/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import gda.analysis.DataSet;
import gda.analysis.Generic1DFitter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.APeak;
import gda.analysis.functions.CompositeFunction;
import gda.analysis.functions.FittedPeak;
import gda.analysis.functions.Gaussian;
import gda.analysis.functions.IdentifiedPeak;
import gda.analysis.functions.Lorentzian;
import gda.analysis.functions.PearsonVII;
import gda.analysis.functions.PseudoVoigt;
import gda.analysis.utils.GeneticAlg;
import gda.analysis.utils.IOptimizer;
import gda.analysis.utils.NelderMead;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakTableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.FitData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.FitMenuDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.PlotFittedPeaks;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.gda.richbeans.components.wrappers.FloatSpinnerWrapper;

public class Fitting1D
extends SidePlot
implements Overlay1DConsumer,
SelectionListener,
ICellEditorListener,
ISelectionChangedListener {
    private static final transient Logger logger = LoggerFactory.getLogger(Fitting1D.class);
    private FittedPeakList fittedPeakList = new FittedPeakList();
    private Combo peakType;
    public static final String[] peaknames = new String[]{"Gaussian", "Lorentzian", "Pearson VII", "PseudoVoigt"};
    public static final String[] algNames = new String[]{"Genetic Algorithm"};
    private Spinner numPeaks;
    private Button fitPeaks;
    private Button clearPeaks;
    private FittedPeakTableViewer fittedPeakTable;
    private Combo chooseDataCombo;
    private List<DoubleDataset> dataSetList;
    private DoubleDataset currentDataSet;
    private List<AxisValues> xAxisList;
    private AxisValues currentXAxis;
    private APeak peakToFit;
    private PlotFittedPeaks fittedPlot;
    private Overlay1DProvider oProvider;
    private List<Integer> primitiveIDs = new ArrayList<Integer>();
    private ArrayList<Integer> allPeakOverlays;
    private int[] startCoord = new int[2];
    int primID = -1;
    private DoubleDataset slicedData;
    private int MAXYVALUE = Integer.MIN_VALUE;
    private Button showAllPeaks;
    private Combo algType;
    private IOptimizer alg = new NelderMead(0.01);
    private FloatSpinnerWrapper accuracy;
    private Spinner smoothing;
    private SelectionAdapter peakTypeSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Fitting1D.this.selectPeakFuction(Fitting1D.this.peakType.getSelectionIndex());
        }
    };
    private SelectionAdapter dataSetSelected = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (Fitting1D.this.dataSetList != null) {
                Fitting1D.this.currentDataSet = (DoubleDataset)Fitting1D.this.dataSetList.get(Fitting1D.this.chooseDataCombo.getSelectionIndex());
                Fitting1D.this.currentXAxis = (AxisValues)Fitting1D.this.xAxisList.get(Fitting1D.this.chooseDataCombo.getSelectionIndex());
                Fitting1D.this.setSmooting();
            }
        }
    };
    private SelectionAdapter fitPeakListener = new SelectionAdapter(){
        private Color colour = Color.BLUE;

        public void widgetSelected(SelectionEvent selectionEvent) {
            Fitting1D.this.clearPeakTable();
            Fitting1D.this.alg = (IOptimizer)new GeneticAlg(Fitting1D.this.accuracy.getFloat());
            List list = Generic1DFitter.fitPeaks((AbstractDataset)Fitting1D.this.currentXAxis.toDataset(), (AbstractDataset)Fitting1D.this.currentDataSet, (APeak)Fitting1D.this.peakToFit, (IOptimizer)Fitting1D.this.alg, (int)Fitting1D.this.smoothing.getSelection(), (int)Fitting1D.this.numPeaks.getSelection());
            if (list.size() <= 0) {
                logger.warn("No peaks found");
            }
            for (FittedPeak fittedPeak : list) {
                Fitting1D.this.fittedPeakList.add(new FittedPeakData(fittedPeak, this.colour));
            }
            Fitting1D.this.updatePeaksTable(Fitting1D.this.fittedPeakList);
            Fitting1D.this.pushPeaksToPlotter(Fitting1D.this.fittedPeakList);
            Fitting1D.this.drawAllPeakOverlays();
        }
    };
    private SelectionAdapter showAllPeaksOverlay = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (Fitting1D.this.showAllPeaks.getSelection()) {
                Fitting1D.this.drawAllPeakOverlays();
            }
            if (!Fitting1D.this.showAllPeaks.getSelection()) {
                Fitting1D.this.removeAllPeakOverlays();
            }
        }
    };
    private SelectionAdapter clearPeaksListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            System.err.println("smoothing " + Fitting1D.this.smoothing.getSelection() + " Accuracy " + Fitting1D.this.accuracy.getFloat());
            Fitting1D.this.fittedPlot.clearPeakPlotter();
            Fitting1D.this.clearPeakTable();
            Fitting1D.this.removePrimitives();
        }
    };

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.oProvider = (Overlay1DProvider)overlayProvider;
    }

    @Override
    public void removePrimitives() {
        int n = this.primitiveIDs.size();
        if (n > 0) {
            this.oProvider.unregisterPrimitive(this.primitiveIDs);
        }
    }

    @Override
    public void unregisterProvider() {
        if (this.oProvider != null) {
            this.removePrimitives();
            this.oProvider = null;
        }
    }

    private void overlaysVisible(boolean bl) {
        if (this.oProvider != null) {
            for (Integer n : this.primitiveIDs) {
                this.oProvider.setPrimitiveVisible(n, bl);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fittedPeakTable.getSelection();
        if (iStructuredSelection != null && selectionEvent.widget instanceof MenuItem) {
            FittedPeakData fittedPeakData = (FittedPeakData)iStructuredSelection.getFirstElement();
            int n = this.fittedPeakList.indexOf(fittedPeakData);
            switch (this.fittedPeakTable.getContextMenu().indexOf((MenuItem)selectionEvent.widget)) {
                case 0: {
                    logger.warn("This function has not been enabled");
                    break;
                }
                case 2: {
                    this.fittedPeakList.remove(n);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Fitting1D.this.updatePeaksTable(Fitting1D.this.fittedPeakList);
                            Fitting1D.this.fittedPlot.clearPeakPlotter();
                            Fitting1D.this.removePrimitives();
                        }
                    });
                    this.pushPeaksToPlotter(this.fittedPeakList);
                    break;
                }
                case 1: {
                    logger.warn("This function has not been enabled");
                }
            }
        }
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void createPartControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.container, 768);
        scrolledComposite.setLayoutData((Object)new GridData(16384, 128, true, false));
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(16384, 128, true, false));
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Peak Type and number");
        this.chooseDataCombo = new Combo((Composite)group, 0);
        this.chooseDataCombo.addSelectionListener((SelectionListener)this.dataSetSelected);
        this.peakType = new Combo((Composite)group, 0);
        int n = 0;
        while (n < peaknames.length) {
            this.peakType.add(peaknames[n]);
            ++n;
        }
        this.peakType.addSelectionListener((SelectionListener)this.peakTypeSelection);
        this.selectPeakFuction(0);
        this.peakType.select(0);
        this.numPeaks = new Spinner((Composite)group, 0);
        this.numPeaks.setMinimum(0);
        this.numPeaks.setIncrement(1);
        this.numPeaks.setMaximum(200000);
        this.numPeaks.setSelection(20);
        this.fitPeaks = new Button((Composite)group, 0);
        this.fitPeaks.setText("Fit");
        this.fitPeaks.addSelectionListener((SelectionListener)this.fitPeakListener);
        this.clearPeaks = new Button((Composite)group, 0);
        this.clearPeaks.setText("Clear");
        this.clearPeaks.addSelectionListener((SelectionListener)this.clearPeaksListener);
        this.showAllPeaks = new Button((Composite)group, 32);
        this.showAllPeaks.setText("Show all peaks");
        this.showAllPeaks.setToolTipText("Show the position of all peaks as an overlay on the plot");
        this.showAllPeaks.addSelectionListener((SelectionListener)this.showAllPeaksOverlay);
        this.showAllPeaks.setSelection(true);
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData((Object)new GridData(16384, 128, true, false));
        group2.setLayout((Layout)new GridLayout(6, false));
        group2.setText("Algorithm Controls");
        Label label = new Label((Composite)group2, 0);
        label.setText("Fitting algorithm");
        this.algType = new Combo((Composite)group2, 0);
        int n2 = 0;
        while (n2 < algNames.length) {
            this.algType.add(algNames[n2]);
            ++n2;
        }
        this.algType.select(0);
        Label label2 = new Label((Composite)group2, 0);
        label2.setText("Accuracy");
        label2.setToolTipText("This sets the accuracy of the optomisation. The lower the number to more accurate the calculation");
        this.accuracy = new FloatSpinnerWrapper((Composite)group2, 0, 6, 5);
        this.accuracy.setMinimum(1.0E-5);
        this.accuracy.setFloat(0.01);
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("Smoothing");
        label3.setToolTipText("Defines the smoothing which will be applied to the peak searching algorithm");
        this.smoothing = new Spinner((Composite)group2, 0);
        this.smoothing.setDigits(0);
        this.smoothing.setSelection(5);
        this.smoothing.setMinimum(1);
        this.smoothing.setMaximum(10000);
        SashForm sashForm = new SashForm(this.container, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite((Composite)sashForm, 0);
        composite3.setLayout((Layout)new FillLayout());
        this.fittedPeakTable = new FittedPeakTableViewer(composite3, this, this, this);
        this.fittedPeakTable.setInput(this.fittedPeakList);
        this.fittedPlot = new PlotFittedPeaks(sashForm);
        sashForm.setWeights(new int[]{10, 20});
        scrolledComposite.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        composite2.setSize(point);
    }

    @Override
    public Action createSwitchAction(final int n, final IPlotUI iPlotUI) {
        Action action = new Action(){

            public void run() {
                iPlotUI.getSidePlotView().switchSidePlot(iPlotUI, n);
                ((DataSetPlotter)Fitting1D.this.mainPlotter).getComposite().setFocus();
            }
        };
        action.setText("1D Fitting tool");
        action.setToolTipText("Switch side plot to 1D fitting tool");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/chart_line_edit.png"));
        return action;
    }

    @Override
    public void dispose() {
        this.fittedPlot.dispose();
    }

    @Override
    public void processPlotUpdate() {
        if (this.dataSetList == null) {
            this.dataSetList = new ArrayList<DoubleDataset>();
        }
        this.dataSetList.clear();
        List<IDataset> list = this.mainPlotter.getCurrentDataSets();
        this.xAxisList = this.mainPlotter.getXAxisValues();
        for (IDataset iDataset : list) {
            if (this.MAXYVALUE < iDataset.max().intValue()) {
                this.MAXYVALUE = iDataset.max().intValue();
            }
            this.dataSetList.add((DoubleDataset)DatasetUtils.cast((AbstractDataset)DatasetUtils.convertToAbstractDataset((IDataset)iDataset), (int)6));
        }
        this.chooseDataCombo.removeAll();
        this.updateDataSetComboBox(this.dataSetList);
        if (this.dataSetList != null && !this.dataSetList.isEmpty()) {
            this.currentDataSet = this.dataSetList.get(0);
            this.currentXAxis = this.xAxisList.get(0);
            this.setSmooting();
        }
    }

    private void updateDataSetComboBox(List<DoubleDataset> list) {
        int n = 0;
        for (DoubleDataset doubleDataset : list) {
            if (doubleDataset.getName().length() == 0) {
                this.chooseDataCombo.add("Data Set " + n++);
                continue;
            }
            this.chooseDataCombo.add(doubleDataset.getName());
        }
        this.clearPeakTable();
        this.fittedPlot.clearPeakPlotter();
        this.chooseDataCombo.select(0);
        this.chooseDataCombo.update();
    }

    private void clearPeakTable() {
        if (this.fittedPeakList != null) {
            this.fittedPeakList.clear();
        }
        if (this.fittedPeakTable != null) {
            this.fittedPeakTable.refresh();
        }
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        if (this.oProvider == null) {
            this.registerProvider(this.oProvider);
        }
        if (this.currentDataSet != null) {
            Object[] objectArray;
            this.oProvider.begin(OverlayType.VECTOR2D);
            if (areaSelectEvent.getMode() == '\u0000') {
                this.overlaysVisible(false);
                this.primID = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                this.oProvider.setColour(this.primID, Color.GREEN);
                this.oProvider.setStyle(this.primID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setTransparency(this.primID, 0.8);
                this.oProvider.setOutlineTransparency(this.primID, 0.0);
                this.startCoord[0] = (int)areaSelectEvent.getX();
                this.startCoord[1] = this.MAXYVALUE * 2;
                this.primitiveIDs.add(this.primID);
            }
            if (areaSelectEvent.getMode() == '\u0001' && this.primID != -1) {
                objectArray = new double[]{areaSelectEvent.getX(), -this.MAXYVALUE * 2};
                this.oProvider.drawBox(this.primID, this.startCoord[0], this.startCoord[1], objectArray[0], objectArray[1]);
            }
            if (areaSelectEvent.getMode() == '\u0002' && this.primID != -1) {
                objectArray = new int[]{(int)areaSelectEvent.getX(), this.currentDataSet.min().intValue()};
                this.oProvider.drawBox(this.primID, this.startCoord[0], this.startCoord[1], objectArray[0], objectArray[1]);
                int n = (int)((double)this.currentXAxis.getValues().size() / this.currentXAxis.getMaxValue());
                this.startCoord[0] = this.startCoord[0] * n;
                objectArray[0] = objectArray[0] * n;
                this.slicedData = this.sliceDataSet(this.startCoord, (int[])objectArray);
                ((DataSetPlotter)this.mainPlotter).getComposite().getDisplay().asyncExec(new Runnable((int[])objectArray){
                    private final /* synthetic */ int[] val$finalPos;
                    {
                        this.val$finalPos = nArray;
                    }

                    @Override
                    public void run() {
                        FitMenuDialog fitMenuDialog = new FitMenuDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), peaknames, algNames);
                        fitMenuDialog.open();
                        Fitting1D.this.fitPeakFromOverlay(Fitting1D.this.createXData(Fitting1D.this.startCoord[0], this.val$finalPos[0]), Fitting1D.this.slicedData, fitMenuDialog.getFitData());
                    }
                });
                this.overlaysVisible(true);
            }
            this.oProvider.end(OverlayType.VECTOR2D);
        }
    }

    private DoubleDataset createXData(int n, int n2) {
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        List<Double> list = this.currentXAxis.subset(n, ++n2).getValues();
        double[] dArray = new double[list.size()];
        int n4 = 0;
        for (Double d : list) {
            dArray[n4++] = d;
        }
        return new DoubleDataset(dArray, null);
    }

    public void fitPeakFromOverlay(DoubleDataset doubleDataset, DoubleDataset doubleDataset2, FitData fitData) {
        this.selectPeakFuction(fitData.getPeakSelection());
        this.alg = new GeneticAlg(fitData.getAccuracy());
        List list = Generic1DFitter.fitPeaks((AbstractDataset)doubleDataset, (AbstractDataset)doubleDataset2, (APeak)this.peakToFit, (IOptimizer)this.alg, (int)fitData.getSmoothing(), (int)fitData.getNumberOfPeaks());
        if (list.size() <= 0) {
            logger.warn("No peaks were found when the region on the plot was selected");
        }
        for (FittedPeak fittedPeak : list) {
            fittedPeak.setXOffset(this.startCoord[0]);
            this.fittedPeakList.add(new FittedPeakData(fittedPeak, Color.GREEN));
        }
        this.updatePeaksTable(this.fittedPeakList);
    }

    private DoubleDataset sliceDataSet(int[] nArray, int[] nArray2) {
        int[] nArray3;
        if (nArray[0] > nArray2[0]) {
            nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        nArray3 = new int[]{nArray[0]};
        int[] nArray4 = new int[]{nArray2[0] + 1};
        return this.currentDataSet.getSlice(nArray3, nArray4, null);
    }

    private void selectPeakFuction(int n) {
        String string = peaknames[n];
        if (string.compareToIgnoreCase("Gaussian") == 0) {
            this.peakToFit = new Gaussian(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("Lorentzian") == 0) {
            this.peakToFit = new Lorentzian(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("Pearson VII") == 0) {
            this.peakToFit = new PearsonVII(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("PseudoVoigt") == 0) {
            this.peakToFit = new PseudoVoigt(1.0, 1.0, 1.0, 1.0);
        } else {
            logger.warn("Peak type not recognised. Defaulting to Gaussian");
            this.peakToFit = new Gaussian(1.0, 1.0, 1.0, 1.0);
            this.peakType.select(0);
        }
    }

    private void setSmooting() {
        this.smoothing.setSelection((int)((double)this.currentDataSet.getSize() * 0.01));
    }

    private void drawAllPeakOverlays() {
        if (this.fittedPeakList != null && this.fittedPeakList.size() > 0) {
            if (this.oProvider == null) {
                this.registerProvider(this.oProvider);
            }
            this.allPeakOverlays = new ArrayList();
            this.overlaysVisible(false);
            if (this.showAllPeaks.getSelection()) {
                for (FittedPeakData fittedPeakData : this.fittedPeakList) {
                    this.primID = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                    this.oProvider.begin(OverlayType.VECTOR2D);
                    double d = fittedPeakData.getFittedPeak().getPeakFitted().getPosition();
                    double d2 = fittedPeakData.getFittedPeak().getPeakFitted().getFWHM();
                    this.oProvider.drawBox(this.primID, d - d2 / 2.0, this.MAXYVALUE * 2, d + d2 / 2.0, 0.0);
                    this.oProvider.setColour(this.primID, Color.ORANGE);
                    this.oProvider.setStyle(this.primID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                    this.oProvider.setTransparency(this.primID, 0.8);
                    this.oProvider.setOutlineTransparency(this.primID, 0.0);
                    this.oProvider.end(OverlayType.VECTOR2D);
                    this.allPeakOverlays.add(this.primID);
                    this.primitiveIDs.add(this.primID);
                }
            }
        }
    }

    private void removeAllPeakOverlays() {
        if (this.allPeakOverlays != null && this.primitiveIDs != null && this.oProvider != null) {
            this.oProvider.begin(OverlayType.VECTOR2D);
            this.oProvider.unregisterPrimitive(this.allPeakOverlays);
            this.oProvider.end(OverlayType.VECTOR2D);
        }
    }

    private void pushPeaksToPlotter(FittedPeakList fittedPeakList) {
        ArrayList<APeak> arrayList = new ArrayList<APeak>();
        for (FittedPeakData fittedPeakData : fittedPeakList) {
            arrayList.add(fittedPeakData.getFittedPeak().getPeakFitted());
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.FITTEDPEAKS, arrayList);
        }
    }

    private void updatePeaksTable(FittedPeakList fittedPeakList) {
        Collections.sort(fittedPeakList, new Compare());
        this.fittedPeakTable.refresh();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        FittedPeakData fittedPeakData = (FittedPeakData)iStructuredSelection.getFirstElement();
        if (fittedPeakData != null) {
            this.processPeakInformation(fittedPeakData);
            this.drawFittedPeakOverlays(fittedPeakData);
            this.fittedPlot.removePrimitives();
            this.fittedPlot.drawCurrentOverlay(fittedPeakData);
            this.showAllPeaks.setSelection(false);
        }
    }

    private void drawFittedPeakOverlays(FittedPeakData fittedPeakData) {
        if (this.oProvider == null) {
            this.registerProvider(this.oProvider);
        }
        this.primID = this.oProvider.registerPrimitive(PrimitiveType.BOX);
        this.overlaysVisible(false);
        this.oProvider.begin(OverlayType.VECTOR2D);
        double d = fittedPeakData.getFittedPeak().getPeakFitted().getPosition();
        double d2 = fittedPeakData.getFittedPeak().getPeakFitted().getFWHM();
        this.oProvider.drawBox(this.primID, d - d2 / 2.0, this.MAXYVALUE * 2, d + d2 / 2.0, 0.0);
        this.oProvider.setColour(this.primID, Color.ORANGE);
        this.oProvider.setStyle(this.primID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.oProvider.setTransparency(this.primID, 0.8);
        this.oProvider.setOutlineTransparency(this.primID, 0.0);
        this.oProvider.end(OverlayType.VECTOR2D);
        this.primitiveIDs.add(this.primID);
    }

    private void processPeakInformation(FittedPeakData fittedPeakData) {
        APeak aPeak = fittedPeakData.getFittedPeak().getPeakFitted();
        IdentifiedPeak identifiedPeak = fittedPeakData.getFittedPeak().getPeakFound();
        int n = fittedPeakData.getFittedPeak().getxOffset();
        int[] nArray = new int[]{identifiedPeak.getIndexOfDataSetAtMinPos() + n};
        int[] nArray2 = new int[]{identifiedPeak.getIndexOfDataSetAtMaxPos() + n + 1};
        int[] nArray3 = new int[]{1};
        DoubleDataset doubleDataset = this.currentDataSet.getSlice(nArray, nArray2, nArray3);
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction((AFunction)aPeak);
        DataSet dataSet = AbstractDataset.toDataSet((IDataset)this.currentXAxis.subset(nArray[0], nArray2[0]).toDataset());
        DoubleDataset doubleDataset2 = AbstractDataset.toDoubleDataset((DataSet)compositeFunction.makeDataSet(dataSet));
        this.fittedPlot.plotDataSets(doubleDataset, doubleDataset2, new AxisValues(dataSet.getData()));
    }

    @Override
    public void showSidePlot() {
        this.processPlotUpdate();
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        return 0;
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
    }

    private static class Compare
    implements Comparator<FittedPeakData> {
        private Compare() {
        }

        @Override
        public int compare(FittedPeakData fittedPeakData, FittedPeakData fittedPeakData2) {
            if (fittedPeakData.getFittedPeak().getPeakFitted().getPosition() > fittedPeakData2.getFittedPeak().getPeakFitted().getPosition()) {
                return 1;
            }
            if (fittedPeakData.getFittedPeak().getPeakFitted().getPosition() < fittedPeakData2.getFittedPeak().getPeakFitted().getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

