/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import gda.analysis.Generic1DFitter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.APeak;
import gda.analysis.functions.CompositeFunction;
import gda.analysis.functions.FittedPeak;
import gda.analysis.functions.Gaussian;
import gda.analysis.functions.Lorentzian;
import gda.analysis.functions.PearsonVII;
import gda.analysis.functions.PseudoVoigt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.python.modules.math;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.Resolution;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.ROIProfileIDataset;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;

public class DiffractionViewerSpotFit
extends Composite
implements Overlay1DConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DiffractionViewerSpotFit.class);
    public DataSetPlotter lpPlotter;
    private DiffractionViewer diffView;
    private Overlay1DProvider provider = null;
    private AxisValues axis;
    ArrayList<Integer> peakLines = new ArrayList();
    private double[] returnPeaks;
    Plot1DGraphTable colourTable;
    Plot1DAppearance plotAppearace;
    int width;
    int step;
    int length;
    private double dataMaxval;
    private LabelWrapper maxD;
    private LabelWrapper minD;
    private LabelWrapper sigma;
    private LabelWrapper averageDSpacing;
    private APeak peak;
    private int maxNumPeaks;

    public DiffractionViewerSpotFit(Composite composite, int n, DiffractionViewer diffractionViewer) {
        super(composite, n);
        this.diffView = diffractionViewer;
        this.setLayout((Layout)new FillLayout(512));
        this.lpPlotter = new DataSetPlotter(PlottingMode.ONED, (Composite)this, false);
        this.lpPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.lpPlotter.setXAxisLabel("Distance along line");
        this.lpPlotter.registerOverlay(this);
        this.axis = new AxisValues();
        this.colourTable = this.lpPlotter.getColourTable();
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Summary");
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        composite2.setLayout((Layout)gridLayout);
        tabItem.setControl((Control)composite2);
        Label label = new Label(composite2, 0);
        label.setText("Average d spacing");
        this.averageDSpacing = new LabelWrapper(composite2, 0);
        this.averageDSpacing.setUnit("\u00c5");
        label = new Label(composite2, 0);
        label.setText("Standatd deviation");
        this.sigma = new LabelWrapper(composite2, 0);
        this.sigma.setUnit("\u00c5");
        label = new Label(composite2, 0);
        label.setText("Maximum d spacing");
        this.maxD = new LabelWrapper(composite2, 0);
        this.maxD.setUnit("\u00c5");
        label = new Label(composite2, 0);
        label.setText("Minimum d spacing");
        this.minD = new LabelWrapper(composite2, 0);
        this.minD.setUnit("\u00c5");
        composite2 = new TabItem(tabFolder, 0);
        composite2.setText("Raw Data");
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay1DProvider)overlayProvider;
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    public void dispose() {
        if (this.lpPlotter != null) {
            this.lpPlotter.cleanUp();
        }
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }

    public void updatePlot() {
        this.lpPlotter.updateAllAppearance();
        this.lpPlotter.refresh(false);
    }

    @Override
    public void removePrimitives() {
        if (this.provider == null) {
            return;
        }
        if (this.peakLines == null || this.peakLines.size() < 1) {
            return;
        }
        int n = this.peakLines.size() - 1;
        while (n >= 0) {
            this.provider.setPrimitiveVisible(this.peakLines.get(n), false);
            this.peakLines.remove(n);
            --n;
        }
    }

    public void processROI(IDataset iDataset, LinearROI linearROI) {
        if (linearROI.getLength() <= 1.0 || iDataset.getSize() < 1) {
            return;
        }
        AbstractDataset[] abstractDatasetArray = ROIProfileIDataset.line((IDataset)iDataset, (LinearROI)linearROI, (double)0.5);
        this.dataMaxval = abstractDatasetArray[0].max().doubleValue();
        this.plotDataSets((IDataset[])abstractDatasetArray);
        List<FittedPeak> list = this.fitPeaks(abstractDatasetArray[0]);
        this.drawPeakLines(this.peakPosition(list), this.dataMaxval);
        this.plotFittedCurves(list, abstractDatasetArray[0]);
        this.dSpacingBetweenPeaks(list, linearROI);
    }

    public void drawPeakLines(double[] dArray, double d) {
        if (this.provider == null || dArray.length == 0) {
            return;
        }
        this.clearOverlays();
        this.provider.begin(OverlayType.VECTOR2D);
        this.returnPeaks = new double[4];
        int n = 0;
        while (n < dArray.length) {
            this.returnPeaks[0] = dArray[n] * 0.5;
            this.returnPeaks[1] = 0.0;
            this.returnPeaks[2] = dArray[n] * 0.5;
            this.returnPeaks[3] = d;
            int n2 = this.provider.registerPrimitive(PrimitiveType.LINE);
            this.provider.setColour(n2, Color.BLUE);
            this.provider.drawLine(n2, this.returnPeaks[0], this.returnPeaks[1], this.returnPeaks[2], this.returnPeaks[3]);
            this.peakLines.add(n2);
            ++n;
        }
        this.provider.end(OverlayType.VECTOR2D);
    }

    private void clearOverlays() {
        this.provider.begin(OverlayType.VECTOR2D);
        for (Integer n : this.peakLines) {
            this.provider.unregisterPrimitive(n);
        }
        this.provider.end(OverlayType.VECTOR2D);
    }

    private void plotDataSets(IDataset[] iDatasetArray) {
        DoubleDataset doubleDataset = DoubleDataset.arange((double)iDatasetArray[0].getSize());
        doubleDataset.imultiply((Object)0.5);
        this.axis.setValues((IDataset)doubleDataset);
        this.colourTable.clearLegend();
        this.plotAppearace = new Plot1DAppearance(PlotColorUtility.getDefaultColour(0), Plot1DStyles.SOLID, "Line 1");
        this.colourTable.addEntryOnLegend(this.plotAppearace);
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        arrayList.add(iDatasetArray[0]);
        arrayList2.add(this.axis);
        Color color = PlotColorUtility.getDefaultColour(1);
        this.plotAppearace = new Plot1DAppearance(color, Plot1DStyles.SOLID, "Line 2");
        this.colourTable.addEntryOnLegend(this.plotAppearace);
        try {
            this.lpPlotter.replaceAllPlots(arrayList, arrayList2);
            this.updatePlot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<FittedPeak> fitPeaks(AbstractDataset abstractDataset) {
        if (abstractDataset == null || abstractDataset.getSize() < 1) {
            return null;
        }
        System.err.println("Peak name " + this.peak + " max num peaks " + this.maxNumPeaks);
        this.length = abstractDataset.getSize();
        return Generic1DFitter.fitPeaks((AbstractDataset)abstractDataset, (APeak)this.peak, (int)this.maxNumPeaks);
    }

    private double[] peakPosition(List<FittedPeak> list) {
        double[] dArray = new double[list.size()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = list.get(n).getPeakFitted().getPosition();
            ++n;
        }
        return dArray;
    }

    private void plotFittedCurves(List<FittedPeak> list, AbstractDataset abstractDataset) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CompositeFunction compositeFunction = new CompositeFunction();
        if (!list.isEmpty()) {
            for (FittedPeak fittedPeak : list) {
                compositeFunction.addFunction((AFunction)fittedPeak.getPeakFitted());
            }
            arrayList.add(abstractDataset);
            arrayList.add(compositeFunction.makeDataset(new IDataset[]{DoubleDataset.arange((double)abstractDataset.getSize())}));
            try {
                this.lpPlotter.replaceAllPlots(arrayList);
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            this.updatePlot();
        }
    }

    private void dSpacingBetweenPeaks(List<FittedPeak> list, LinearROI linearROI) {
        double d;
        if (list == null || list.size() < 1) {
            logger.warn("No peaks found");
            return;
        }
        int[] nArray = new int[list.size() * 2];
        double[] dArray = new double[list.size() - 1];
        int n = 0;
        while (n < list.size()) {
            int[] nArray2 = linearROI.getIntPoint(list.get(n).getPeakFitted().getPosition() * 0.5 / linearROI.getLength());
            nArray[n * 2] = nArray2[0];
            nArray[n * 2 + 1] = nArray2[1];
            ++n;
        }
        try {
            dArray = Resolution.peakDistances((int[])nArray, (DetectorProperties)this.diffView.detConfig, (DiffractionCrystalEnvironment)this.diffView.diffEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn("pixel values were found to be identical");
        }
        catch (Exception exception) {
            logger.error("Could not calculate d spacing between these peaks");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            d = dArray2[n3];
            d2 += d;
            if (d > d5) {
                d5 = d;
            }
            if (d < d4) {
                d4 = d;
            }
            logger.debug("D spacing " + d);
            ++n3;
        }
        d2 /= (double)dArray.length;
        dArray2 = dArray;
        n2 = dArray.length;
        n3 = 0;
        while (n3 < n2) {
            d = dArray2[n3];
            d3 += (d - d2) * (d - d2);
            ++n3;
        }
        d = math.sqrt((double)(d3 / (double)(dArray.length - 1)));
        final double d6 = d2;
        final double d7 = d4;
        final double d8 = d5;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerSpotFit.this.averageDSpacing.setValue((Object)d6);
                DiffractionViewerSpotFit.this.sigma.setValue((Object)d);
                DiffractionViewerSpotFit.this.minD.setValue((Object)d7);
                DiffractionViewerSpotFit.this.maxD.setValue((Object)d8);
            }
        });
    }

    public void pushPreferences(String string, int n) {
        this.maxNumPeaks = n;
        this.peak = string.compareToIgnoreCase("Gaussian") == 0 ? new Gaussian(1.0, 1.0, 1.0, 1.0) : (string.compareToIgnoreCase("Lorentzian") == 0 ? new Lorentzian(1.0, 1.0, 1.0, 1.0) : (string.compareToIgnoreCase("Pearson VII") == 0 ? new PearsonVII(1.0, 1.0, 1.0, 1.0) : (string.compareToIgnoreCase("PseudoVoigt") == 0 ? new PseudoVoigt(1.0, 1.0, 1.0, 1.0) : new Gaussian(1.0, 1.0, 1.0, 1.0))));
    }
}

