/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ResolutionRingTableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewer;
import uk.ac.diamond.scisoft.analysis.roi.ResolutionRing;
import uk.ac.diamond.scisoft.analysis.roi.ResolutionRingList;
import uk.ac.gda.richbeans.components.wrappers.FloatSpinnerWrapper;

public class DiffractionViewerResolutionRings
extends Composite
implements SelectionListener,
ICellEditorListener {
    private ResolutionRingList resolutionRingList = new ResolutionRingList();
    private ResolutionRingTableViewer tViewer;
    private DiffractionViewer diffView;
    private FloatSpinnerWrapper resring;
    private Button addRing;
    private Button removeRings;
    private Button addSpacedRings;
    private final Button addIce;
    private FloatSpinnerWrapper numberEvenSpacedRings;
    private Button beamCentre;
    private Button mask;
    private Button standard;
    private static final double[] iceResolution = new double[]{3.897, 3.669, 3.441, 2.671, 2.249, 2.072, 1.948, 1.918, 1.883, 1.721};
    private SelectionListener toggleRingListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.addRing.isEnabled()) {
                DiffractionViewerResolutionRings.this.addRing.setEnabled(false);
                DiffractionViewerResolutionRings.this.removeRings.setEnabled(false);
                DiffractionViewerResolutionRings.this.diffView.ringsVisible(false);
                DiffractionViewerResolutionRings.this.addIce.setEnabled(false);
                DiffractionViewerResolutionRings.this.addSpacedRings.setEnabled(false);
                DiffractionViewerResolutionRings.this.beamCentre.setEnabled(false);
                DiffractionViewerResolutionRings.this.beamCentre.setSelection(false);
                DiffractionViewerResolutionRings.this.diffView.drawBeamCentre(false);
                DiffractionViewerResolutionRings.this.mask.setEnabled(false);
                DiffractionViewerResolutionRings.this.mask.setSelection(false);
                DiffractionViewerResolutionRings.this.standard.setEnabled(false);
                DiffractionViewerResolutionRings.this.standard.setSelection(false);
                DiffractionViewerResolutionRings.this.diffView.hideMask();
            } else {
                DiffractionViewerResolutionRings.this.addRing.setEnabled(true);
                DiffractionViewerResolutionRings.this.removeRings.setEnabled(true);
                DiffractionViewerResolutionRings.this.diffView.ringsVisible(true);
                DiffractionViewerResolutionRings.this.addIce.setEnabled(true);
                DiffractionViewerResolutionRings.this.addSpacedRings.setEnabled(true);
                DiffractionViewerResolutionRings.this.beamCentre.setEnabled(true);
                DiffractionViewerResolutionRings.this.mask.setEnabled(true);
                DiffractionViewerResolutionRings.this.standard.setEnabled(true);
            }
        }
    };
    private SelectionListener clearRings = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            DiffractionViewerResolutionRings.this.diffView.clearRings();
            DiffractionViewerResolutionRings.this.resolutionRingList.clear();
            DiffractionViewerResolutionRings.this.tViewer.refresh();
            DiffractionViewerResolutionRings.this.addSpacedRings.setSelection(false);
            DiffractionViewerResolutionRings.this.addIce.setSelection(false);
            DiffractionViewerResolutionRings.this.beamCentre.setSelection(false);
            DiffractionViewerResolutionRings.this.diffView.removeBeamCentre();
            DiffractionViewerResolutionRings.this.mask.setSelection(false);
            DiffractionViewerResolutionRings.this.standard.setSelection(false);
            DiffractionViewerResolutionRings.this.diffView.removeMask();
        }
    };
    private SelectionListener addRingListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.resring.getFloat() <= 0.0) {
                return;
            }
            DiffractionViewerResolutionRings.this.resolutionRingList.add((Object)new ResolutionRing(DiffractionViewerResolutionRings.this.resring.getFloat()));
            DiffractionViewerResolutionRings.this.tViewer.refresh();
            DiffractionViewerResolutionRings.this.diffView.updateRings(DiffractionViewerResolutionRings.this.resolutionRingList);
        }
    };
    private SelectionListener addMask = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.mask.getSelection()) {
                DiffractionViewerResolutionRings.this.diffView.drawMask();
                ((DataSetPlotter)((DiffractionViewerResolutionRings)DiffractionViewerResolutionRings.this).diffView.mainPlotter).getComposite().setFocus();
            }
            if (!DiffractionViewerResolutionRings.this.mask.getSelection()) {
                DiffractionViewerResolutionRings.this.diffView.hideMask();
            }
        }
    };
    private SelectionListener addIceListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.addIce.getSelection()) {
                double[] dArray = iceResolution;
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray[n2];
                    DiffractionViewerResolutionRings.this.resolutionRingList.add((Object)new ResolutionRing(d, true, Color.BLUE, true, false));
                    ++n2;
                }
                DiffractionViewerResolutionRings.this.tViewer.refresh();
                DiffractionViewerResolutionRings.this.diffView.updateRings(DiffractionViewerResolutionRings.this.resolutionRingList);
            }
            if (!DiffractionViewerResolutionRings.this.addIce.getSelection()) {
                ResolutionRingList resolutionRingList = new ResolutionRingList();
                if (DiffractionViewerResolutionRings.this.resolutionRingList != null && DiffractionViewerResolutionRings.this.resolutionRingList.size() > 1) {
                    int n = 0;
                    while (n < DiffractionViewerResolutionRings.this.resolutionRingList.size()) {
                        ResolutionRing resolutionRing = (ResolutionRing)DiffractionViewerResolutionRings.this.resolutionRingList.get(n);
                        if (!resolutionRing.isIce()) {
                            resolutionRingList.add((Object)resolutionRing);
                        }
                        ++n;
                    }
                    DiffractionViewerResolutionRings.this.resolutionRingList.clear();
                    DiffractionViewerResolutionRings.this.resolutionRingList.addAll((Collection)resolutionRingList);
                    DiffractionViewerResolutionRings.this.tViewer.refresh();
                    DiffractionViewerResolutionRings.this.diffView.updateRings(DiffractionViewerResolutionRings.this.resolutionRingList);
                }
            }
        }
    };
    private SelectionListener addEvenlySpacedRings = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Vector3d vector3d;
            if (DiffractionViewerResolutionRings.this.addSpacedRings.getSelection()) {
                double d = ((DiffractionViewerResolutionRings)DiffractionViewerResolutionRings.this).diffView.diffEnv.getWavelength();
                vector3d = ((DiffractionViewerResolutionRings)DiffractionViewerResolutionRings.this).diffView.detConfig.getLongestVector();
                double d2 = vector3d.length() / DiffractionViewerResolutionRings.this.numberEvenSpacedRings.getFloat();
                Vector3d vector3d2 = new Vector3d();
                Vector3d vector3d3 = ((DiffractionViewerResolutionRings)DiffractionViewerResolutionRings.this).diffView.detConfig.getBeamPosition();
                int n = 0;
                while ((double)n < DiffractionViewerResolutionRings.this.numberEvenSpacedRings.getFloat() - 1.0) {
                    vector3d.normalize();
                    vector3d.scale(d2 + d2 * (double)n);
                    vector3d2.add((Tuple3d)vector3d3, (Tuple3d)vector3d);
                    double d3 = vector3d3.angle(vector3d2);
                    double d4 = d / Math.sin(d3);
                    DiffractionViewerResolutionRings.this.resolutionRingList.add((Object)new ResolutionRing(d4, true, Color.YELLOW, false, true));
                    ++n;
                }
                DiffractionViewerResolutionRings.this.tViewer.refresh();
                DiffractionViewerResolutionRings.this.diffView.updateRings(DiffractionViewerResolutionRings.this.resolutionRingList);
            }
            if (!DiffractionViewerResolutionRings.this.addSpacedRings.getSelection()) {
                ResolutionRingList resolutionRingList = new ResolutionRingList();
                if (DiffractionViewerResolutionRings.this.resolutionRingList != null && DiffractionViewerResolutionRings.this.resolutionRingList.size() > 1) {
                    int n = 0;
                    while (n < DiffractionViewerResolutionRings.this.resolutionRingList.size()) {
                        vector3d = (ResolutionRing)DiffractionViewerResolutionRings.this.resolutionRingList.get(n);
                        if (!vector3d.isEvenSpaced()) {
                            resolutionRingList.add((Object)vector3d);
                        }
                        ++n;
                    }
                    DiffractionViewerResolutionRings.this.resolutionRingList.clear();
                    DiffractionViewerResolutionRings.this.resolutionRingList.addAll((Collection)resolutionRingList);
                    DiffractionViewerResolutionRings.this.tViewer.refresh();
                    DiffractionViewerResolutionRings.this.diffView.updateRings(DiffractionViewerResolutionRings.this.resolutionRingList);
                }
            }
        }
    };
    private SelectionListener displayBeamCentre = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.beamCentre.getSelection()) {
                DiffractionViewerResolutionRings.this.beamCentre.setSelection(true);
                DiffractionViewerResolutionRings.this.diffView.drawBeamCentre(true);
            } else {
                DiffractionViewerResolutionRings.this.beamCentre.setSelection(false);
                DiffractionViewerResolutionRings.this.diffView.removeBeamCentre();
            }
        }
    };
    private SelectionListener standardSampleListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DiffractionViewerResolutionRings.this.standard.getSelection()) {
                DiffractionViewerResolutionRings.this.drawStandardSampleRings();
            }
            if (!DiffractionViewerResolutionRings.this.standard.getSelection()) {
                DiffractionViewerResolutionRings.this.removeStandardSampleRings();
            }
        }
    };

    DiffractionViewerResolutionRings(Composite composite, int n, DiffractionViewer diffractionViewer) {
        super(composite, n);
        this.setLayout((Layout)new FillLayout(512));
        this.diffView = diffractionViewer;
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Resolution Rings");
        GridData gridData = new GridData();
        Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)gridData);
        button.setText("Toggle Rings");
        button.setToolTipText("Adds Resolution rings to display");
        button.addSelectionListener(this.toggleRingListener);
        new CLabel((Composite)group, 0).setText("Resolution:");
        this.resring = new FloatSpinnerWrapper((Composite)group, 2048, 3, 1);
        this.resring.setMinimum(0);
        this.resring.setMaximum(15);
        GridData gridData2 = new GridData();
        this.addRing = new Button((Composite)group, 8);
        this.addRing.setLayoutData((Object)gridData2);
        this.addRing.setText("Add Ring");
        this.addRing.setEnabled(false);
        this.addRing.addSelectionListener(this.addRingListener);
        this.removeRings = new Button((Composite)group, 8);
        this.removeRings.setLayoutData((Object)gridData2);
        this.removeRings.setText("Clear");
        this.removeRings.setEnabled(false);
        this.removeRings.addSelectionListener(this.clearRings);
        new Label((Composite)group, 0);
        this.addIce = new Button((Composite)group, 2);
        this.addIce.setEnabled(false);
        this.addIce.setLayoutData((Object)gridData2);
        this.addIce.setText("Ice rings");
        this.addIce.addSelectionListener(this.addIceListener);
        this.numberEvenSpacedRings = new FloatSpinnerWrapper((Composite)group, 0);
        this.numberEvenSpacedRings.setFormat(2, 0);
        this.numberEvenSpacedRings.setMinimum(2);
        this.numberEvenSpacedRings.setFloat(6.0);
        this.numberEvenSpacedRings.setMaximum(10);
        this.addSpacedRings = new Button((Composite)group, 2);
        this.addSpacedRings.setEnabled(false);
        this.addSpacedRings.setLayoutData((Object)gridData2);
        this.addSpacedRings.setText("Standard Rings");
        this.addSpacedRings.addSelectionListener(this.addEvenlySpacedRings);
        this.beamCentre = new Button((Composite)group, 2);
        this.beamCentre.setEnabled(false);
        this.beamCentre.setText("Beam Centre");
        this.beamCentre.setLayoutData((Object)gridData2);
        this.beamCentre.addSelectionListener(this.displayBeamCentre);
        this.mask = new Button((Composite)group, 2);
        this.mask.setEnabled(false);
        this.mask.setText("Mask");
        this.mask.setLayoutData((Object)gridData2);
        this.mask.addSelectionListener(this.addMask);
        this.standard = new Button((Composite)group, 2);
        this.standard.setEnabled(false);
        this.standard.setText("Calibrant");
        this.standard.setLayoutData((Object)gridData2);
        this.standard.addSelectionListener(this.standardSampleListener);
        gridData = new Composite((Composite)this, 0);
        gridData.setLayout((Layout)new FillLayout());
        this.tViewer = new ResolutionRingTableViewer((Composite)gridData, this, this);
        this.tViewer.setInput(this.resolutionRingList);
    }

    public void drawStandardSampleRings() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        if (iPreferenceStore.isDefault("diffviewer.standardName")) {
            iPreferenceStore.getDefaultString("diffviewer.standardName");
        } else {
            iPreferenceStore.getString("diffviewer.standardName");
        }
        String string = iPreferenceStore.isDefault("diffviewer.standardDistances") ? iPreferenceStore.getDefaultString("diffviewer.standardDistances") : iPreferenceStore.getString("diffviewer.standardDistances");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(Double.valueOf(string2));
            System.out.println(Double.valueOf(string2));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            this.resolutionRingList.add((Object)new ResolutionRing(d, true, Color.RED, false, false, true));
        }
        this.tViewer.refresh();
        this.diffView.updateRings(this.resolutionRingList);
    }

    public void removeStandardSampleRings() {
        ResolutionRingList resolutionRingList = new ResolutionRingList();
        if (this.resolutionRingList != null && this.resolutionRingList.size() > 1) {
            int n = 0;
            while (n < this.resolutionRingList.size()) {
                ResolutionRing resolutionRing = (ResolutionRing)this.resolutionRingList.get(n);
                if (!resolutionRing.isStandard()) {
                    resolutionRingList.add((Object)resolutionRing);
                }
                ++n;
            }
            this.resolutionRingList.clear();
            this.resolutionRingList.addAll((Collection)resolutionRingList);
            this.tViewer.refresh();
            this.diffView.updateRings(this.resolutionRingList);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.tViewer.deleteItem)) {
            int n = this.tViewer.getSelectionIndex();
            this.resolutionRingList.remove(n);
            this.diffView.updateRings(this.resolutionRingList);
            this.tViewer.refresh();
        }
    }

    public void dispose() {
        if (!this.addIce.isDisposed()) {
            this.addIce.removeSelectionListener(this.addIceListener);
        }
        if (!this.addRing.isDisposed()) {
            this.addRing.removeSelectionListener(this.addRingListener);
        }
        if (!this.addSpacedRings.isDisposed()) {
            this.addSpacedRings.removeSelectionListener(this.addEvenlySpacedRings);
        }
        if (!this.beamCentre.isDisposed()) {
            this.beamCentre.removeSelectionListener(this.displayBeamCentre);
        }
        if (!this.removeRings.isDisposed()) {
            this.removeRings.removeSelectionListener(this.clearRings);
        }
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    public boolean isMaskEnabled() {
        return this.mask.getSelection();
    }

    public void redrawExistingRings() {
        if (this.resolutionRingList != null) {
            this.diffView.updateRings(this.resolutionRingList);
        }
    }
}

