/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import gda.observable.IObservable;
import gda.observable.IObserver;
import java.awt.Color;
import java.util.LinkedList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.DataWindowView;

public class DataWindowOverlay
implements Overlay2DConsumer,
IObservable {
    private Overlay2DProvider provider = null;
    private LinkedList<IObserver> observers;
    private DataWindowView view;
    private int selectPrimID = -1;
    private int selectStartX;
    private int selectStartY;
    private int selectEndX;
    private int selectEndY;
    private int oldSelectEndX = 0;
    private int oldSelectEndY = 0;
    private int xScale;
    private int yScale;
    private boolean allowUndersampling;
    private int xSamplingMode;
    private int ySamplingMode;
    private int xAspect = 0;
    private int yAspect = 0;
    private Color outLineColour = Color.green;
    private static final Color overSampleLineColour = Color.orange;
    private static final Color normalColour = Color.green;

    public DataWindowOverlay(int n, int n2, DataWindowView dataWindowView) {
        this.xScale = n;
        this.yScale = n2;
        this.observers = new LinkedList();
        this.view = dataWindowView;
    }

    public void setScaling(int n, int n2) {
        this.xScale = n;
        this.yScale = n2;
        this.selectStartX = 0;
        this.selectStartY = 0;
        this.selectEndX = DataSet3DPlot3D.MAXDIM / n;
        this.selectEndY = DataSet3DPlot3D.MAXDIM / n2;
        this.selectPrimID = -1;
        this.drawOverlay();
    }

    public void setAllowUndersampling(boolean bl) {
        this.allowUndersampling = bl;
    }

    public void setSamplingMode(int n, int n2) {
        this.xSamplingMode = n;
        this.ySamplingMode = n2;
    }

    public void setAspects(int n, int n2) {
        this.xAspect = n;
        this.yAspect = n2;
    }

    public void setSelectPosition(int n, int n2, int n3, int n4) {
        if (this.selectPrimID == -1) {
            this.selectPrimID = this.provider.registerPrimitive(PrimitiveType.BOX);
        }
        this.selectStartX = n / this.xScale;
        this.selectStartY = n2 / this.yScale;
        this.selectEndX = this.selectStartX + n3 / this.xScale;
        this.selectEndY = this.selectStartY + n4 / this.yScale;
        if (!this.allowUndersampling) {
            this.clampToMax();
        } else {
            this.checkIfAboveMax();
        }
        this.drawOverlay();
        this.view.setSpinnerValues(this.selectStartX * this.xScale, this.selectStartY * this.yScale, Math.abs(this.selectEndX - this.selectStartX) * this.xScale, Math.abs(this.selectEndY - this.selectStartY) * this.yScale);
        this.notifyObservers();
    }

    @Override
    public void hideOverlays() {
    }

    @Override
    public void showOverlays() {
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay2DProvider)overlayProvider;
    }

    private void drawOverlay() {
        this.provider.begin(OverlayType.VECTOR2D);
        if (this.selectPrimID != -1) {
            this.provider.setStyle(this.selectPrimID, VectorOverlayStyles.OUTLINE);
            this.provider.setColour(this.selectPrimID, this.outLineColour);
            this.provider.drawBox(this.selectPrimID, this.selectStartX, this.selectStartY, this.selectEndX, this.selectEndY);
        }
        this.provider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void removePrimitives() {
        if (this.selectPrimID != -1) {
            this.provider.unregisterPrimitive(this.selectPrimID);
        }
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    private void checkIfAboveMax() {
        int n;
        int n2 = Math.abs(this.selectEndX - this.selectStartX) * this.xScale;
        this.outLineColour = n2 * (n = Math.abs(this.selectEndY - this.selectStartY) * this.yScale) > DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM ? overSampleLineColour : normalColour;
    }

    private void clampToMax() {
        int n;
        int n2 = Math.abs(this.selectEndX - this.selectStartX) * this.xScale;
        if (n2 * (n = Math.abs(this.selectEndY - this.selectStartY) * this.yScale) > DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM) {
            float f = (float)(DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM) / (float)(n2 * n);
            int n3 = Math.abs(this.selectEndX - this.oldSelectEndX);
            int n4 = Math.abs(this.selectEndY - this.oldSelectEndY);
            float f2 = (float)n3 / (float)(n3 + n4);
            float f3 = 1.0f - (1.0f - f) * f2;
            float f4 = 1.0f - (1.0f - f) * (1.0f - f2);
            this.selectEndX = this.selectEndX > this.selectStartX ? this.selectStartX + (int)((float)Math.abs(this.selectEndX - this.selectStartX) * f3) : this.selectStartX - (int)((float)Math.abs(this.selectEndX - this.selectStartX) * f3);
            this.selectEndY = this.selectEndY > this.selectStartY ? this.selectStartY + (int)((float)Math.abs(this.selectEndY - this.selectStartY) * f4) : this.selectStartY - (int)((float)Math.abs(this.selectEndY - this.selectStartY) * f4);
        }
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        this.selectEndX = iImagePositionEvent.getImagePosition()[0];
        this.selectEndY = iImagePositionEvent.getImagePosition()[1];
        if (!this.allowUndersampling) {
            this.clampToMax();
        } else {
            this.checkIfAboveMax();
        }
        this.drawOverlay();
        this.view.setSpinnerValues(this.selectStartX * this.xScale, this.selectStartY * this.yScale, Math.abs(this.selectEndX - this.selectStartX) * this.xScale, Math.abs(this.selectEndY - this.selectStartY) * this.yScale);
        this.oldSelectEndX = this.selectEndX;
        this.oldSelectEndY = this.selectEndY;
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        this.selectEndX = iImagePositionEvent.getImagePosition()[0];
        this.selectEndY = iImagePositionEvent.getImagePosition()[1];
        if (!this.allowUndersampling) {
            this.clampToMax();
        } else {
            this.checkIfAboveMax();
        }
        this.drawOverlay();
        this.view.setSpinnerValues(this.selectStartX * this.xScale, this.selectStartY * this.yScale, Math.abs(this.selectEndX - this.selectStartX) * this.xScale, Math.abs(this.selectEndY - this.selectStartY) * this.yScale);
        this.notifyObservers();
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        if (this.selectPrimID == -1) {
            this.selectPrimID = this.provider.registerPrimitive(PrimitiveType.BOX);
        }
        this.selectStartX = iImagePositionEvent.getImagePosition()[0];
        this.selectStartY = iImagePositionEvent.getImagePosition()[1];
        this.oldSelectEndX = this.selectStartX;
        this.oldSelectEndY = this.selectStartY;
    }

    private void notifyObservers() {
        int n;
        int n2 = Math.abs(this.selectEndX - this.selectStartX) * this.xScale;
        int n3 = n2 * (n = Math.abs(this.selectEndY - this.selectStartY) * this.yScale) > DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM ? this.xSamplingMode : 0;
        int n4 = n2 * n > DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM ? this.ySamplingMode : 0;
        SurfacePlotROI surfacePlotROI = new SurfacePlotROI(this.selectStartX * this.xScale, this.selectStartY * this.yScale, this.selectEndX * this.xScale, this.selectEndY * this.yScale, n3, n4, this.xAspect, this.yAspect);
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, (Object)surfacePlotROI);
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }
}

