/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.LinearROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;

public final class LinearROITableViewer
extends ROITableViewer {
    public LinearROITableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener) {
        super(composite, selectionListener, iCellEditorListener);
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        LinearROIData linearROIData = (LinearROIData)object;
        if (linearROIData != null) {
            LinearROI linearROI = linearROIData.getROI();
            switch (n) {
                case 1: {
                    string = Integer.toString(linearROI.getIntPoint()[0]);
                    break;
                }
                case 2: {
                    string = Integer.toString(linearROI.getIntPoint()[1]);
                    break;
                }
                case 3: {
                    string = String.format("%.2f", linearROI.getEndPoint()[0]);
                    break;
                }
                case 4: {
                    string = String.format("%.2f", linearROI.getEndPoint()[1]);
                    break;
                }
                case 5: {
                    string = String.format("%.2f", linearROI.getLength());
                    break;
                }
                case 6: {
                    string = String.format("%.2f", linearROI.getAngleDegrees());
                    break;
                }
                case 7: {
                    if (linearROI.isCrossHair()) {
                        string = "Y";
                        break;
                    }
                    string = "N";
                    break;
                }
                case 8: {
                    string = String.format("%.2f", linearROIData.getProfileSum());
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Plot", "x_s", "y_s", "x_e", "y_e", "len", "phi", "Cross", "Sum"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{40, 50, 50, 70, 70, 70, 70, 40, 80};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Plot", "Start x", "Start y", "End x", "End y", "Length", "Angle", "Cross hair", "Sum of profile"};
    }
}

