/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.util.LinkedList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;

public class TickFactory {
    private TickFormatting formatOfTicks;
    private static final int TICKMINDIST_IN_PIXELS_X = 60;
    private static final int TICKMINDIST_IN_PIXELS_Y = 30;
    private static final double EPSILON = 1.0E-20;
    private int numTicks = 0;
    private double tickUnit = 0.0;
    private double internalGraphmin;
    private double realGraphmin;
    private double graphmax;
    private int nfrac;
    private boolean overwriteMinAnyway = false;

    public TickFactory(TickFormatting tickFormatting) {
        this.formatOfTicks = tickFormatting;
    }

    public void setTickMode(TickFormatting tickFormatting) {
        this.formatOfTicks = tickFormatting;
    }

    private double nicenum(double d, boolean bl) {
        int n = (int)Math.floor(Math.log10(d));
        double d2 = d / Math.pow(10.0, n);
        double d3 = bl ? (d2 < 1.5 ? 1.0 : (d2 < 3.0 ? 2.0 : (d2 < 7.0 ? 5.0 : 10.0))) : (d2 <= 1.0 ? 1.0 : (d2 <= 2.0 ? 2.0 : (d2 <= 5.0 ? 5.0 : 10.0)));
        return d3 * Math.pow(10.0, n);
    }

    private void determineNumTicks(int n, double d, double d2, short s, boolean bl) {
        int n2 = 0;
        this.overwriteMinAnyway = false;
        switch (s) {
            case 0: {
                n2 = Math.min(8, n / 60);
                break;
            }
            case 1: {
                n2 = Math.min(8, n / 30);
                break;
            }
            case 2: {
                n2 = n;
            }
        }
        double d3 = d2 - d;
        this.numTicks = n2;
        if (Math.abs(d3) < 1.0E-20) {
            this.numTicks = 0;
        } else {
            d3 = this.nicenum(d2 - d, false);
            this.tickUnit = this.nicenum(d3 / (double)(this.numTicks - 1), true);
            if (bl) {
                this.internalGraphmin = Math.floor(d / this.tickUnit) * this.tickUnit;
                if (d - this.internalGraphmin > 1000.0) {
                    this.overwriteMinAnyway = true;
                    this.realGraphmin = d;
                } else {
                    this.realGraphmin = this.internalGraphmin;
                }
                this.graphmax = Math.ceil(d2 / this.tickUnit) * this.tickUnit;
            } else {
                this.internalGraphmin = d;
                this.realGraphmin = d;
                this.graphmax = d2;
            }
            this.nfrac = (int)Math.max(-Math.floor(Math.log10(this.tickUnit)), 0.0);
        }
    }

    String getTickString(double d) {
        String string = "";
        switch (this.formatOfTicks) {
            case plainMode: {
                String string2 = String.format("%%.%df", this.nfrac);
                string = String.format(string2, d);
                break;
            }
            case roundAndChopMode: {
                long l = Math.round(d);
                string = String.format("%d", l);
                break;
            }
            case useExponent: {
                String string3 = String.format("%%.%de", this.nfrac);
                string = String.format(string3, d);
                break;
            }
            case useSIunits: {
                double d2 = Math.abs(d);
                if (d2 <= 1.0E-12 && d2 != 0.0) {
                    string = String.valueOf(String.format("%6.2f", d * 1.0E12)) + "p";
                    break;
                }
                if (d2 <= 1.0E-9 && d2 != 0.0) {
                    string = String.valueOf(String.format("%6.2f", d * 1.0E9)) + "n";
                    break;
                }
                if (d2 <= 1.0E-6 && d2 != 0.0) {
                    string = String.valueOf(String.format("%6.2f", d * 1000000.0)) + "\u00b5";
                    break;
                }
                if (d2 <= 0.001 & d2 != 0.0) {
                    string = String.valueOf(String.format("%6.2f", d * 1000.0)) + "m";
                    break;
                }
                if (d2 < 1000.0) {
                    string = String.format("%6.2f", d);
                    break;
                }
                if (d2 < 1000000.0) {
                    string = String.valueOf(String.format("%6.2f", d / 1000.0)) + "k";
                    break;
                }
                if (d2 < 1.0E9) {
                    string = String.valueOf(String.format("%6.2f", d / 1000000.0)) + "M";
                    break;
                }
                if (d2 < 1.0E12) {
                    string = String.valueOf(String.format("%6,2f", d / 1.0E9)) + "G";
                    break;
                }
                if (d2 < 1.0E15) {
                    string = String.valueOf(String.format("%6.2f", d / 1.0E12)) + "T";
                    break;
                }
                if (!(d2 < 1.0E18)) break;
                string = String.valueOf(String.format("%6,2f", d / 1.0E15)) + "P";
            }
        }
        return string;
    }

    public double getTickUnit() {
        return this.tickUnit;
    }

    public double getLabelMin() {
        return this.realGraphmin;
    }

    public double getLabelMax() {
        return this.graphmax;
    }

    public LinkedList<Tick> generateTicks(int n, double d, double d2, short s, boolean bl) {
        LinkedList<Tick> linkedList = new LinkedList<Tick>();
        this.determineNumTicks(n, d, d2, s, bl);
        double d3 = this.internalGraphmin;
        while (d3 < this.graphmax + 0.5 * this.tickUnit) {
            double d4;
            Tick tick = new Tick();
            if (d3 == this.internalGraphmin && this.overwriteMinAnyway) {
                tick.setTickValue(this.realGraphmin);
            } else {
                tick.setTickValue(d3);
            }
            tick.setTickName(this.getTickString(tick.getTickValue()));
            if (bl || d3 <= d2) {
                linkedList.add(tick);
            }
            if (d3 == (d4 = d3 + this.tickUnit)) break;
            d3 = d4;
        }
        return linkedList;
    }
}

