/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.SurfPlotStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.DataWindowView;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;
import uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView;

public class PlotSurf3DUI
implements IPlotUI,
IObserver {
    private AxisValues xAxis = null;
    private AxisValues yAxis = null;
    private AxisValues zAxis = null;
    private PlotWindow plotWindow = null;
    private DataSetPlotter mainPlotter;
    private Composite parent;
    private HistogramView histogramView;
    private DataWindowView dataWindowView;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private Action boundingBox;
    private Action xCoordGrid;
    private Action yCoordGrid;
    private Action zCoordGrid;
    private Action saveGraph;
    private Action printGraph;
    private Action displayFilled;
    private Action displayWireframe;
    private Action displayLinegraph;
    private Action displayPoint;
    private Action resetView;
    private static final Logger logger = LoggerFactory.getLogger(PlotSurf3DUI.class);

    public PlotSurf3DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.parent = composite;
        this.plotWindow = plotWindow;
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        this.zAxis = new AxisValues();
        this.mainPlotter = dataSetPlotter;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        try {
            this.histogramView = (HistogramView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        try {
            this.dataWindowView = (DataWindowView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.DataWindowView", string, 3);
            if (this.histogramView != null) {
                this.histogramView.addIObserver(this.dataWindowView);
            }
            this.dataWindowView.addIObserver(this);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        if (this.dataWindowView == null) {
            logger.warn("Cannot find data window");
        }
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                PlotSurf3DUI.this.mainPlotter.resetView();
                PlotSurf3DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.boundingBox = new Action("", 2){

            public void run() {
                dataSetPlotter.enableBoundingBox(PlotSurf3DUI.this.boundingBox.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.boundingBox.setText("Bounding box on/off");
        this.boundingBox.setToolTipText("Bounding box on/off");
        this.boundingBox.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/box.png"));
        this.boundingBox.setChecked(true);
        this.xCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.xCoordGrid.setChecked(true);
        this.xCoordGrid.setText("X grid lines ON/OFF");
        this.xCoordGrid.setToolTipText("Toggle x axis grid lines on/off");
        this.xCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify_rot.png"));
        this.yCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.yCoordGrid.setChecked(true);
        this.yCoordGrid.setText("Y grid lines ON/OFF");
        this.yCoordGrid.setToolTipText("Toggle y axis grid lines on/off");
        this.yCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify.png"));
        this.zCoordGrid = new Action("", 2){

            public void run() {
                dataSetPlotter.setTickGridLines(PlotSurf3DUI.this.xCoordGrid.isChecked(), PlotSurf3DUI.this.yCoordGrid.isChecked(), PlotSurf3DUI.this.zCoordGrid.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.zCoordGrid.setChecked(true);
        this.zCoordGrid.setText("Z grid lines ON/OFF");
        this.zCoordGrid.setToolTipText("Toggle z axis grid lines on/off");
        this.zCoordGrid.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/text_align_justify.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(DataSetPlotter.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                dataSetPlotter.saveGraph(this.filename, DataSetPlotter.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText("Save/Export graph");
        this.saveGraph.setToolTipText("Export / save the plotting");
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/picture_save.png"));
        this.printGraph = new Action(){

            public void run() {
                PrintDialog printDialog = new PrintDialog(shell, 0);
                PrinterData printerData = printDialog.open();
                dataSetPlotter.printGraph(printerData);
            }
        };
        this.printGraph.setText("Print graph");
        this.printGraph.setToolTipText("Print the plotting");
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/printer.png"));
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.boundingBox);
        iToolBarManager.add((IAction)this.xCoordGrid);
        iToolBarManager.add((IAction)this.yCoordGrid);
        iToolBarManager.add((IAction)this.zCoordGrid);
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.printGraph);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.displayFilled = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.FILLED);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayFilled.setText("Filled mode");
        this.displayFilled.setDescription("Render the graph in filled mode");
        this.displayWireframe = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.WIREFRAME);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayWireframe.setText("Wireframe mode");
        this.displayWireframe.setDescription("Render the graph in wireframe mode");
        this.displayLinegraph = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.LINEGRAPH);
                dataSetPlotter.refresh(true);
            }
        };
        this.displayLinegraph.setText("Linegraph mode");
        this.displayLinegraph.setDescription("Render the graph in linegraph mode");
        this.displayPoint = new Action(){

            public void run() {
                dataSetPlotter.setPlot2DSurfStyle(SurfPlotStyles.POINTS);
                dataSetPlotter.refresh(false);
            }
        };
        this.displayPoint.setText("Point mode");
        this.displayPoint.setDescription("Render the graph in dot mode");
        iMenuManager.add((IAction)this.displayFilled);
        iMenuManager.add((IAction)this.displayWireframe);
        iMenuManager.add((IAction)this.displayLinegraph);
        iMenuManager.add((IAction)this.displayPoint);
    }

    @Override
    public void disposeOverlays() {
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        Collection collection = dataBean.getData();
        if (collection != null) {
            int n;
            Iterator iterator = collection.iterator();
            List<IDataset> list = Collections.synchronizedList(new LinkedList());
            IDataset iDataset = dataBean.getAxis("x-axis");
            IDataset iDataset2 = dataBean.getAxis("y-axis");
            IDataset iDataset3 = dataBean.getAxis("z-axis");
            this.xAxis.clear();
            this.yAxis.clear();
            this.zAxis.clear();
            this.mainPlotter.setAxisModes(iDataset == null ? AxisMode.LINEAR : AxisMode.CUSTOM, iDataset2 == null ? AxisMode.LINEAR : AxisMode.CUSTOM, iDataset3 == null ? AxisMode.LINEAR : AxisMode.CUSTOM);
            if (iDataset != null) {
                if (iDataset.getName() != null && iDataset.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(iDataset.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                n = 0;
                while (n < iDataset.getSize()) {
                    this.xAxis.addValue(iDataset.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
            } else {
                this.mainPlotter.setXAxisLabel("X-Axis");
            }
            if (iDataset2 != null) {
                if (iDataset2.getName() != null && iDataset2.getName().length() > 0) {
                    this.mainPlotter.setYAxisLabel(iDataset2.getName());
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                n = 0;
                while (n < iDataset2.getSize()) {
                    this.yAxis.addValue(iDataset2.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setYAxisValues(this.yAxis);
            } else {
                this.mainPlotter.setYAxisLabel("Y-Axis");
            }
            if (iDataset3 != null) {
                if (iDataset3.getName() != null && iDataset3.getName().length() > 0) {
                    this.mainPlotter.setZAxisLabel(iDataset3.getName());
                } else {
                    this.mainPlotter.setZAxisLabel("Z-Axis");
                }
                n = 0;
                while (n < iDataset3.getSize()) {
                    this.zAxis.addValue(iDataset3.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setZAxisValues(this.zAxis);
            } else {
                this.mainPlotter.setZAxisLabel("Z-Axis");
            }
            this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
            while (iterator.hasNext()) {
                DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                IDataset iDataset4 = dataSetWithAxisInformation.getData();
                list.add(iDataset4);
            }
            if (list.get(0) instanceof AbstractCompoundDataset) {
                logger.warn("Surface plotting of CompoundDatasets is currently not supported!");
                this.plotWindow.notifyUpdateFinished();
            } else {
                final HistogramDataUpdate histogramDataUpdate = new HistogramDataUpdate((IDataset)list.get(0));
                try {
                    this.mainPlotter.replaceAllPlots(list);
                }
                catch (PlotException plotException) {
                    plotException.printStackTrace();
                }
                this.dataWindowView.setData((IDataset)list.get(0), this.xAxis, this.yAxis);
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlotSurf3DUI.this.mainPlotter.refresh(true);
                        PlotSurf3DUI.this.plotWindow.notifyHistogramChange(histogramDataUpdate);
                        PlotSurf3DUI.this.plotWindow.notifyUpdateFinished();
                    }
                });
            }
        }
    }

    @Override
    public void deactivate(boolean bl) {
        this.histogramView.deleteIObserver(this.dataWindowView);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.dataWindowView);
        this.plotWindow.deleteIObserver(this.histogramView);
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }

    public void update(Object object, Object object2) {
        if (object2 instanceof SurfacePlotROI) {
            SurfacePlotROI surfacePlotROI = (SurfacePlotROI)object2;
            this.mainPlotter.setDataWindowPosition(surfacePlotROI);
            this.mainPlotter.refresh(false);
        }
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
    }

    @Override
    public SidePlotView getSidePlotView() {
        return null;
    }

    @Override
    public void initSidePlotView() {
    }
}

