/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class PlotScatter3DUI
implements IPlotUI {
    private Composite parent;
    private PlotWindow plotWindow;
    private AxisValues xAxis;
    private AxisValues yAxis;
    private AxisValues zAxis;
    private DataSetPlotter mainPlotter;
    private Action boundingBox;
    private Action saveGraph;
    private Action printGraph;
    private Action useTransparency;
    private Action renderEdgeOnly;
    private Action xLabelTypeRound = null;
    private Action xLabelTypeFloat = null;
    private Action xLabelTypeExponent = null;
    private Action xLabelTypeSI = null;
    private Action yLabelTypeRound = null;
    private Action yLabelTypeFloat = null;
    private Action yLabelTypeExponent = null;
    private Action yLabelTypeSI = null;
    private Action zLabelTypeRound = null;
    private Action zLabelTypeFloat = null;
    private Action zLabelTypeExponent = null;
    private Action zLabelTypeSI = null;
    private HistogramView histogramView;
    private Action resetView;

    public PlotScatter3DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.parent = composite;
        this.plotWindow = plotWindow;
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
        this.zAxis = new AxisValues();
        this.mainPlotter = dataSetPlotter;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        try {
            this.histogramView = (HistogramView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.resetView = new Action(){

            public void run() {
                PlotScatter3DUI.this.mainPlotter.resetView();
                PlotScatter3DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.boundingBox = new Action("", 2){

            public void run() {
                dataSetPlotter.enableBoundingBox(PlotScatter3DUI.this.boundingBox.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.boundingBox.setText("Bounding box on/off");
        this.boundingBox.setToolTipText("Bounding box on/off");
        this.boundingBox.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/box.png"));
        this.boundingBox.setChecked(true);
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(DataSetPlotter.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                dataSetPlotter.saveGraph(this.filename, DataSetPlotter.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText("Save/Export graph");
        this.saveGraph.setToolTipText("Export / save the plotting");
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/picture_save.png"));
        this.printGraph = new Action(){

            public void run() {
                PrintDialog printDialog = new PrintDialog(shell, 0);
                PrinterData printerData = printDialog.open();
                dataSetPlotter.printGraph(printerData);
            }
        };
        this.printGraph.setText("Print graph");
        this.printGraph.setToolTipText("Print the plotting");
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/printer.png"));
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.boundingBox);
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.printGraph);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.useTransparency = new Action("", 2){

            public void run() {
                dataSetPlotter.useTransparency(PlotScatter3DUI.this.useTransparency.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.useTransparency.setText("Use transparency");
        this.useTransparency.setToolTipText("Switch on/off transparency");
        this.renderEdgeOnly = new Action("", 2){

            public void run() {
                if (PlotScatter3DUI.this.renderEdgeOnly.isChecked()) {
                    dataSetPlotter.useTransparency(true);
                } else {
                    dataSetPlotter.useTransparency(PlotScatter3DUI.this.useTransparency.isChecked());
                }
                dataSetPlotter.useDrawOutlinesOnly(PlotScatter3DUI.this.renderEdgeOnly.isChecked());
            }
        };
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeRound.setChecked(true);
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the y-axis to integer numbers");
        this.yLabelTypeRound.setChecked(true);
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        this.zLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setZTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeRound.setText("Z-Axis labels integer");
        this.zLabelTypeRound.setToolTipText("Change the labelling on the z-axis to integer numbers");
        this.zLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeFloat.setText("Z-Axis labels real");
        this.zLabelTypeFloat.setToolTipText("Change the labelling on the z-axis to real numbers");
        this.zLabelTypeFloat.setChecked(true);
        this.zLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeExponent.setText("Z-Axis labels exponents");
        this.zLabelTypeExponent.setToolTipText("Change the labelling on the z-axis to using exponents");
        this.zLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setZTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(false);
            }
        };
        this.zLabelTypeSI.setText("Z-Axis labels SI units");
        this.zLabelTypeSI.setToolTipText("Change the labelling on the z-axis to using SI units");
        this.renderEdgeOnly.setText("Draw outlines only");
        this.renderEdgeOnly.setToolTipText("Switch on/off drawing outlines only");
        iMenuManager.add((IAction)this.useTransparency);
        iMenuManager.add((IAction)this.renderEdgeOnly);
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        MenuManager menuManager3 = new MenuManager("Z-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        iMenuManager.add((IContributionItem)menuManager3);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        menuManager3.add((IAction)this.zLabelTypeFloat);
        menuManager3.add((IAction)this.zLabelTypeRound);
        menuManager3.add((IAction)this.zLabelTypeExponent);
        menuManager3.add((IAction)this.zLabelTypeSI);
    }

    @Override
    public void deactivate(boolean bl) {
    }

    @Override
    public void disposeOverlays() {
    }

    @Override
    public ISidePlotView getSidePlotView() {
        return null;
    }

    @Override
    public void initSidePlotView() {
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        Collection collection = dataBean.getData();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            List<IDataset> list = Collections.synchronizedList(new LinkedList());
            IDataset iDataset = dataBean.getAxis("x-axis");
            IDataset iDataset2 = dataBean.getAxis("y-axis");
            IDataset iDataset3 = dataBean.getAxis("z-axis");
            if (iDataset != null && iDataset2 != null && iDataset3 != null) {
                IDataset iDataset4;
                if (!bl) {
                    this.xAxis.clear();
                    this.yAxis.clear();
                    this.zAxis.clear();
                    if (iDataset.getName() != null && iDataset.getName().length() > 0) {
                        this.mainPlotter.setXAxisLabel(iDataset.getName());
                    } else {
                        this.mainPlotter.setXAxisLabel("X-Axis");
                    }
                    if (iDataset2.getName() != null && iDataset2.getName().length() > 0) {
                        this.mainPlotter.setYAxisLabel(iDataset2.getName());
                    } else {
                        this.mainPlotter.setYAxisLabel("Y-Axis");
                    }
                    if (iDataset3.getName() != null && iDataset3.getName().length() > 0) {
                        this.mainPlotter.setZAxisLabel(iDataset3.getName());
                    } else {
                        this.mainPlotter.setZAxisLabel("Z-Axis");
                    }
                }
                int n = 0;
                while (n < iDataset.getSize()) {
                    this.xAxis.addValue(iDataset.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
                n = 0;
                while (n < iDataset2.getSize()) {
                    this.yAxis.addValue(iDataset2.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setYAxisValues(this.yAxis);
                n = 0;
                while (n < iDataset3.getSize()) {
                    this.zAxis.addValue(iDataset3.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setZAxisValues(this.zAxis);
                this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                while (iterator.hasNext()) {
                    DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                    iDataset4 = dataSetWithAxisInformation.getData();
                    list.add(iDataset4);
                }
                if (!bl) {
                    try {
                        this.mainPlotter.replaceAllPlots(list);
                    }
                    catch (PlotException plotException) {
                        plotException.printStackTrace();
                    }
                } else {
                    IDataset iDataset5 = (IDataset)list.get(0);
                    iDataset4 = this.mainPlotter.getCurrentDataSet();
                    int n2 = iDataset4.getSize();
                    int n3 = iDataset5.getSize();
                    int n4 = 0;
                    while (n4 < n3) {
                        iDataset4.set(iDataset5.getObject(new int[]{n4}), new int[]{n4 + n2});
                        ++n4;
                    }
                    list.set(0, iDataset4);
                    try {
                        this.mainPlotter.replaceAllPlots(list);
                    }
                    catch (PlotException plotException) {
                        plotException.printStackTrace();
                    }
                }
                final HistogramDataUpdate histogramDataUpdate = new HistogramDataUpdate((IDataset)list.get(0));
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlotScatter3DUI.this.mainPlotter.refresh(true);
                        PlotScatter3DUI.this.plotWindow.notifyHistogramChange(histogramDataUpdate);
                        PlotScatter3DUI.this.plotWindow.notifyUpdateFinished();
                    }
                });
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
    }

    public void deleteIObserver(IObserver iObserver) {
    }

    public void deleteIObservers() {
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }
}

