/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;

public class PlotScatter2DUI
implements IPlotUI {
    private static final String STATUSSTRING = "Pos: ";
    public static final String STATUSITEMID = "uk.ac.dimaond.scisoft.analysis.rcp.plotting.PlotScatter2DUI";
    private DataSetPlotter mainPlotter;
    private Composite parent;
    private Action xLabelTypeRound;
    private Action xLabelTypeFloat;
    private Action xLabelTypeExponent;
    private Action xLabelTypeSI;
    private Action yLabelTypeRound;
    private Action yLabelTypeFloat;
    private Action yLabelTypeExponent;
    private Action yLabelTypeSI;
    private Action saveGraph;
    private Action printGraph;
    private Action displayPlotPos;
    private StatusLineContributionItem statusLine;
    private AxisValues xAxis;
    private AxisValues yAxis;
    private PlotWindow plotWindow;

    public PlotScatter2DUI(PlotWindow plotWindow, IActionBars iActionBars, DataSetPlotter dataSetPlotter, Composite composite) {
        this.mainPlotter = dataSetPlotter;
        this.parent = composite;
        this.plotWindow = plotWindow;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell(), dataSetPlotter.getColourTable());
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        this.buildStatusLineItems(iActionBars.getStatusLineManager());
        this.mainPlotter.registerUI(this);
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, Shell shell, Plot1DGraphTable plot1DGraphTable) {
        this.displayPlotPos = new Action("", 2){

            public void run() {
                dataSetPlotter.setPlotActionEnabled(PlotScatter2DUI.this.displayPlotPos.isChecked());
            }
        };
        this.displayPlotPos.setText("Display graph position");
        this.displayPlotPos.setToolTipText("Display the position on the graph");
        this.displayPlotPos.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/monitor.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(PlotScatter2DUI.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(DataSetPlotter.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                dataSetPlotter.saveGraph(this.filename, DataSetPlotter.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText("Save/Export graph");
        this.saveGraph.setToolTipText("Export / save the plotting");
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/picture_save.png"));
        this.printGraph = new Action(){

            public void run() {
                PrintDialog printDialog = new PrintDialog(PlotScatter2DUI.this.parent.getShell(), 0);
                PrinterData printerData = printDialog.open();
                dataSetPlotter.printGraph(printerData);
            }
        };
        this.printGraph.setText("Print graph");
        this.printGraph.setToolTipText("Print the plotting");
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/printer.png"));
        iToolBarManager.add((IAction)this.displayPlotPos);
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.printGraph);
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
    }

    @Override
    public void deactivate(boolean bl) {
    }

    @Override
    public void disposeOverlays() {
    }

    @Override
    public ISidePlotView getSidePlotView() {
        return null;
    }

    @Override
    public void initSidePlotView() {
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processPlotUpdate(DataBean var1_1, boolean var2_2) {
        block10: {
            block11: {
                var3_3 = var1_1.getData();
                if (var3_3 == null) break block10;
                var4_4 = var3_3.iterator();
                var5_5 = Collections.synchronizedList(new LinkedList<E>());
                var6_6 = var1_1.getAxis("x-axis");
                var7_7 = var1_1.getAxis("y-axis");
                if (var6_6 == null || var7_7 == null) break block10;
                if (var2_2) ** GOTO lbl51
                this.xAxis.clear();
                this.yAxis.clear();
                var8_8 = var6_6.getName();
                if (var8_8 != null && var8_8.length() > 0) {
                    this.mainPlotter.setXAxisLabel(var8_8);
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                var9_10 = var7_7.getName();
                if (var9_10 != null && var9_10.length() > 0) {
                    this.mainPlotter.setYAxisLabel(var9_10);
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                var10_12 = this.mainPlotter.getColourTable();
                var10_12.clearLegend();
                this.mainPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.CUSTOM, AxisMode.LINEAR);
                this.xAxis.setValues(var6_6);
                this.yAxis.setValues(var7_7);
                this.mainPlotter.setXAxisValues(this.xAxis, var3_3.size());
                this.mainPlotter.setYAxisValues(this.yAxis);
                while (var4_4.hasNext()) {
                    var11_14 = (DataSetWithAxisInformation)var4_4.next();
                    var12_17 = var11_14.getData();
                    var5_5.add(var12_17);
                }
                try {
                    this.mainPlotter.replaceAllPlots(var5_5);
                }
                catch (PlotException var11_15) {
                    var11_15.printStackTrace();
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    var8_9 = new AxisValues();
                    var9_11 = new AxisValues();
                    var8_9.setValues(var6_6);
                    var9_11.setValues(var7_7);
                    var10_13 = (DataSetWithAxisInformation)var4_4.next();
                    var11_16 = var10_13.getData();
                    try {
                        this.mainPlotter.addToCurrentPlot(var11_16, var8_9, var9_11);
                        continue;
                    }
                    catch (PlotException var12_18) {
                        var12_18.printStackTrace();
                    }
lbl51:
                    // 3 sources

                    ** while (var4_4.hasNext())
                }
            }
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotScatter2DUI.this.mainPlotter.refresh(true);
                    PlotScatter2DUI.this.mainPlotter.updateAllAppearance();
                    PlotScatter2DUI.this.plotWindow.notifyUpdateFinished();
                }
            });
        }
    }

    public void buildStatusLineItems(IStatusLineManager iStatusLineManager) {
        this.statusLine = new StatusLineContributionItem(STATUSITEMID);
        this.statusLine.setText(STATUSSTRING);
        iStatusLineManager.add((IContributionItem)this.statusLine);
    }

    public void addIObserver(IObserver iObserver) {
    }

    public void deleteIObserver(IObserver iObserver) {
    }

    public void deleteIObservers() {
    }

    @Override
    public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int n = (int)Math.max(-Math.floor(Math.log10(Math.abs(plotActionEvent.getPosition()[0]))), 3.0);
                String string = String.format("%%.%df", n + 1);
                String string2 = String.format(string, plotActionEvent.getPosition()[0]);
                n = (int)Math.max(-Math.floor(Math.log10(Math.abs(plotActionEvent.getPosition()[1]))), 3.0);
                string = String.format("%%.%df", n + 1);
                String string3 = String.format(string, plotActionEvent.getPosition()[1]);
                PlotScatter2DUI.this.statusLine.setText("Pos:  " + string2 + ":" + string3);
            }
        });
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }
}

