/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import gda.observable.IObserver;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramDataUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.SidePlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;
import uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView;

public class Plot2DUI
implements IPlotUI,
IPartListener2 {
    public static final String STATUSITEMID = "uk.ac.dimaond.scisoft.analysis.rcp.plotting.Plot2DUI";
    private DataSetPlotter mainPlotter;
    private Composite compParent;
    private IWorkbenchPage page;
    private String plotViewID;
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private PlotWindow plotWindow;
    private HistogramView histogramView;
    private Action resetView;
    private Action printGraph;
    private Action monitorValues;
    private Action saveGraph;
    private Action canvasAspect;
    private AxisValues xAxis = null;
    private AxisValues yAxis = null;
    private Action xLabelTypeRound = null;
    private Action xLabelTypeFloat = null;
    private Action xLabelTypeExponent = null;
    private Action xLabelTypeSI = null;
    private Action yLabelTypeRound = null;
    private Action yLabelTypeFloat = null;
    private Action yLabelTypeExponent = null;
    private Action yLabelTypeSI = null;
    private Action colourCastLinear = null;
    private Action colourCastLog = null;
    private IGuiInfoManager manager = null;
    private IToolBarManager toolManager = null;
    private List<Action> switchToTabs;
    private boolean sidePlotInitialized = false;
    private boolean histogramInitialized = false;
    private HistogramDataUpdate histoUpdate = null;
    private static final Logger logger = LoggerFactory.getLogger(Plot2DUI.class);

    public Plot2DUI(PlotWindow plotWindow, DataSetPlotter dataSetPlotter, IGuiInfoManager iGuiInfoManager, Composite composite, IWorkbenchPage iWorkbenchPage, IActionBars iActionBars, String string) {
        this.mainPlotter = dataSetPlotter;
        this.compParent = composite;
        this.plotWindow = plotWindow;
        this.page = iWorkbenchPage;
        this.plotViewID = string;
        this.manager = iGuiInfoManager;
        this.initHistogramView(this.plotViewID);
        this.mainPlotter.registerUI(this);
        this.initSidePlotView();
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter, composite.getShell());
        this.buildMenuActions(iActionBars.getMenuManager(), dataSetPlotter);
        iWorkbenchPage.addPartListener((IPartListener2)this);
        this.xAxis = new AxisValues();
        this.yAxis = new AxisValues();
    }

    public void initHistogramView(String string) {
        try {
            this.histogramView = (HistogramView)this.page.showView("uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView", string, 3);
            SidePlotUtils.bringToTop(this.page, (IWorkbenchPart)this.histogramView);
            this.plotWindow.addIObserver(this.histogramView);
            this.histogramView.addIObserver(this.plotWindow);
            this.histogramInitialized = true;
        }
        catch (PartInitException partInitException) {
            logger.error("Failed to initialized histogram View");
        }
    }

    @Override
    public void initSidePlotView() {
        try {
            SidePlotView sidePlotView = this.getSidePlotView();
            sidePlotView.setPlotView(this.plotWindow.getMainPlotter(), this.manager);
            sidePlotView.setSwitchActions(this.switchToTabs);
            this.sidePlotInitialized = true;
            SidePlotUtils.bringToTop(this.page, (IWorkbenchPart)sidePlotView);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        Collection collection = dataBean.getData();
        if (collection != null) {
            boolean bl2;
            int n;
            Iterator iterator = collection.iterator();
            List<IDataset> list = Collections.synchronizedList(new LinkedList());
            IDataset iDataset = dataBean.getAxis("x-axis");
            IDataset iDataset2 = dataBean.getAxis("y-axis");
            this.xAxis.clear();
            this.yAxis.clear();
            this.mainPlotter.setAxisModes(iDataset == null ? AxisMode.LINEAR : AxisMode.CUSTOM, iDataset2 == null ? AxisMode.LINEAR : AxisMode.CUSTOM, AxisMode.LINEAR);
            if (iDataset != null) {
                if (iDataset.getName() != null && iDataset.getName().length() > 0) {
                    this.mainPlotter.setXAxisLabel(iDataset.getName());
                } else {
                    this.mainPlotter.setXAxisLabel("X-Axis");
                }
                n = 0;
                while (n < iDataset.getSize()) {
                    this.xAxis.addValue(iDataset.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setXAxisValues(this.xAxis, 1);
            } else {
                this.mainPlotter.setXAxisLabel("X-Axis");
            }
            if (iDataset2 != null) {
                if (iDataset2.getName() != null && iDataset2.getName().length() > 0) {
                    this.mainPlotter.setYAxisLabel(iDataset2.getName());
                } else {
                    this.mainPlotter.setYAxisLabel("Y-Axis");
                }
                n = 0;
                while (n < iDataset2.getSize()) {
                    this.yAxis.addValue(iDataset2.getDouble(new int[]{n++}));
                }
                this.mainPlotter.setYAxisValues(this.yAxis);
            } else {
                this.mainPlotter.setYAxisLabel("Y-Axis");
            }
            this.mainPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
            this.mainPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
            while (iterator.hasNext()) {
                DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                IDataset iDataset3 = dataSetWithAxisInformation.getData();
                list.add(iDataset3);
            }
            this.histoUpdate = new HistogramDataUpdate((IDataset)list.get(0));
            try {
                this.mainPlotter.replaceAllPlots(list);
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            this.mainPlotter.setTitle(((IDataset)list.get(0)).getName());
            this.compParent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Plot2DUI.this.getSidePlotView().processPlotUpdate();
                    Plot2DUI.this.plotWindow.notifyUpdateFinished();
                }
            });
            IDataset iDataset4 = (IDataset)list.get(0);
            boolean bl3 = bl2 = iDataset4 instanceof RGBDataset || iDataset4 instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)iDataset4).getElementsPerItem() == 3 || ((AbstractCompoundDataset)iDataset4).getElementsPerItem() == 4);
            if (!bl2) {
                this.plotWindow.notifyHistogramChange(this.histoUpdate);
            } else {
                this.mainPlotter.refresh(true);
            }
        }
    }

    public HistogramView getHistogramView() {
        return this.histogramView;
    }

    private void buildMenuActions(IMenuManager iMenuManager, final DataSetPlotter dataSetPlotter) {
        this.xLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeRound.setText("X-Axis labels integer");
        this.xLabelTypeRound.setToolTipText("Change the labelling on the x-axis to integer numbers");
        this.xLabelTypeRound.setChecked(true);
        this.xLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeFloat.setText("X-Axis labels real");
        this.xLabelTypeFloat.setToolTipText("Change the labelling on the x-axis to real numbers");
        this.xLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeExponent.setText("X-Axis labels exponents");
        this.xLabelTypeExponent.setToolTipText("Change the labelling on the x-axis to using exponents");
        this.xLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setXTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.xLabelTypeSI.setText("X-Axis labels SI units");
        this.xLabelTypeSI.setToolTipText("Change the labelling on the x-axis to using SI units");
        this.yLabelTypeRound = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.roundAndChopMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeRound.setText("Y-Axis labels integer");
        this.yLabelTypeRound.setToolTipText("Change the labelling on the y-axis to integer numbers");
        this.yLabelTypeRound.setChecked(true);
        this.yLabelTypeFloat = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.plainMode);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeFloat.setText("Y-Axis labels real");
        this.yLabelTypeFloat.setToolTipText("Change the labelling on the y-axis to real numbers");
        this.yLabelTypeExponent = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useExponent);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeExponent.setText("Y-Axis labels exponents");
        this.yLabelTypeExponent.setToolTipText("Change the labelling on the y-axis to using exponents");
        this.yLabelTypeSI = new Action("", 8){

            public void run() {
                dataSetPlotter.setYTickLabelFormat(TickFormatting.useSIunits);
                dataSetPlotter.refresh(true);
            }
        };
        this.yLabelTypeSI.setText("Y-Axis labels SI units");
        this.yLabelTypeSI.setToolTipText("Change the labelling on the y-axis to using SI units");
        this.colourCastLinear = new Action("", 8){

            public void run() {
                dataSetPlotter.setZAxisScaling(ScaleType.LINEAR);
                dataSetPlotter.refresh(true);
                Plot2DUI.this.histogramView.setScaling(ScaleType.LINEAR);
            }
        };
        this.colourCastLinear.setChecked(true);
        this.colourCastLinear.setText("Linear mappig colours");
        this.colourCastLinear.setToolTipText("Apply linear colour mapping to image");
        this.colourCastLog = new Action("", 8){

            public void run() {
                dataSetPlotter.setZAxisScaling(ScaleType.LN);
                dataSetPlotter.refresh(true);
                Plot2DUI.this.histogramView.setScaling(ScaleType.LN);
            }
        };
        this.colourCastLog.setText("Logarithmic mappig colours");
        this.colourCastLog.setToolTipText("Apply logarithmic colour mapping to image");
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        iMenuManager.add((IAction)this.colourCastLinear);
        iMenuManager.add((IAction)this.colourCastLog);
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter, final Shell shell) {
        this.toolManager = iToolBarManager;
        this.resetView = new Action(){

            public void run() {
                Plot2DUI.this.mainPlotter.resetView();
                Plot2DUI.this.mainPlotter.refresh(false);
            }
        };
        this.resetView.setText("Reset view");
        this.resetView.setToolTipText("Reset panning and zooming");
        this.resetView.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/house_go.png"));
        this.monitorValues = new Action("", 2){

            public void run() {
                dataSetPlotter.setPlotActionEnabled(Plot2DUI.this.monitorValues.isChecked());
            }
        };
        this.monitorValues.setText("Monitor position");
        this.monitorValues.setToolTipText("Monitor the position in the image");
        this.monitorValues.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/monitor.png"));
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 8192);
                String[] stringArray = new String[]{"*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(DataSetPlotter.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                dataSetPlotter.saveGraph(this.filename, DataSetPlotter.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText("Save/Export graph");
        this.saveGraph.setToolTipText("Export / save the plotting");
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/picture_save.png"));
        this.printGraph = new Action(){

            public void run() {
                PrintDialog printDialog = new PrintDialog(shell, 0);
                PrinterData printerData = printDialog.open();
                dataSetPlotter.printGraph(printerData);
            }
        };
        this.printGraph.setText("Print graph");
        this.printGraph.setToolTipText("Print the plotting");
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/printer.png"));
        this.canvasAspect = new Action("", 2){

            public void run() {
                dataSetPlotter.imagePlotSetCanvasAspectRatio(Plot2DUI.this.canvasAspect.isChecked());
                dataSetPlotter.refresh(false);
            }
        };
        this.canvasAspect.setText("Canvas");
        this.canvasAspect.setToolTipText("Switch between canvas/data aspect ratio");
        this.canvasAspect.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/arrow_out.png"));
        iToolBarManager.add((IContributionItem)new Separator());
        try {
            this.switchToTabs = this.getSidePlotView().createSwitchActions(this);
            for (Action action : this.switchToTabs) {
                iToolBarManager.add((IAction)action);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.resetView);
        iToolBarManager.add((IAction)this.monitorValues);
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IAction)this.canvasAspect);
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }

    @Override
    public void disposeOverlays() {
        this.getSidePlotView().disposeOverlays();
    }

    @Override
    public void deactivate(boolean bl) {
        this.histoUpdate = null;
        this.page.removePartListener((IPartListener2)this);
        this.plotWindow.deleteIObserver(this.histogramView);
        try {
            this.getSidePlotView().deactivate(bl);
        }
        catch (IllegalStateException illegalStateException) {}
        this.page.hideView((IViewPart)this.histogramView);
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
        this.getSidePlotView().updateGUI(guiBean);
    }

    @Override
    public SidePlotView getSidePlotView() {
        return SidePlotUtils.getSidePlotView(this.page, this.plotViewID);
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        String string = "Side: " + this.plotViewID;
        String string2 = "Histogram " + new File(this.plotViewID).getName();
        if (iWorkbenchPartReference.getPartName().equals(string) && !this.sidePlotInitialized) {
            this.initSidePlotView();
            if (!this.histogramInitialized) {
                this.initHistogramView(this.plotViewID);
                if (this.histoUpdate != null) {
                    this.plotWindow.notifyHistogramChange(this.histoUpdate);
                }
            }
            try {
                this.switchToTabs = this.getSidePlotView().createSwitchActions(this);
                for (Action action : this.switchToTabs) {
                    this.toolManager.add((IAction)action);
                }
                this.toolManager.update(true);
            }
            catch (Exception exception) {}
        } else if (iWorkbenchPartReference.getPartName().equals(string2) && !this.histogramInitialized) {
            this.initHistogramView(this.plotViewID);
            if (this.histoUpdate != null) {
                this.plotWindow.notifyHistogramChange(this.histoUpdate);
            }
        }
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }
}

