/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.PointSetFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SelectedWindow;

public class DataSetScatterPlot2D
extends DataSet3DPlot1D {
    private List<AxisValues> yAxes = Collections.synchronizedList(new LinkedList());
    private LinkedList<DefaultPointShader> graphPointShaders;
    private double dataMin;
    private double dataMax;
    private static final double MAXRADII = 64.0;

    public DataSetScatterPlot2D(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, Plot1DGraphTable plot1DGraphTable, boolean bl) {
        super(abstractViewerApp, composite, cursor, plot1DGraphTable, bl);
        this.xAxis = AxisMode.CUSTOM;
        this.yAxis = AxisMode.CUSTOM;
        this.graphPointShaders = new LinkedList();
    }

    @Override
    protected void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        Iterator iterator2 = this.xAxes.iterator();
        Iterator<AxisValues> iterator3 = this.yAxes.iterator();
        this.globalYmin = 3.4028234663852886E38;
        this.globalYmax = -3.4028234663852886E38;
        this.globalXmin = 3.4028234663852886E38;
        this.globalXmax = -3.4028234663852886E38;
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = -3.4028234663852886E38;
        this.dataMin = 3.4028234663852886E38;
        this.dataMax = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            AxisValues axisValues = (AxisValues)iterator2.next();
            AxisValues axisValues2 = iterator3.next();
            this.globalRealXmin = Math.min(this.globalRealXmin, axisValues.getMin());
            this.globalXmax = this.globalRealXmax = Math.max(this.globalRealXmax, axisValues.getMax());
            this.globalYmin = Math.min(this.globalYmin, axisValues2.getMin());
            this.globalYmax = Math.max(this.globalYmax, axisValues2.getMax());
            this.dataMin = Math.min(iDataset.min().doubleValue(), this.dataMin);
            this.dataMax = Math.max(iDataset.max().doubleValue(), this.dataMax);
        }
        this.sanityCheckMinMax();
        this.buildTickLists();
    }

    private PointSet createGraphGeometry(IDataset iDataset, AxisValues axisValues, AxisValues axisValues2) {
        int n = iDataset.getSize();
        PointSetFactory pointSetFactory = new PointSetFactory();
        double[] dArray = new double[n * 3];
        double[] dArray2 = new double[]{};
        if (this.dataMin != this.dataMax) {
            dArray2 = new double[n];
        }
        Iterator<Double> iterator = axisValues.getIterator();
        Iterator<Double> iterator2 = axisValues2.getIterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            double d = iterator.next();
            double d2 = iterator2.next();
            dArray[n2 * 3] = (d - this.graphXmin) * (14.75 / (this.graphXmax - this.graphXmin));
            dArray[n2 * 3 + 1] = (d2 - this.graphYmin) * (15.0 / (this.graphYmax - this.graphYmin));
            dArray[n2 * 3 + 2] = 0.0;
            if (this.dataMin != this.dataMax) {
                dArray2[n2] = this.dataMax > 64.0 ? 64.0 * iDataset.getDouble(new int[]{n2}) / this.dataMax : iDataset.getDouble(new int[]{n2});
            }
            ++n2;
        }
        pointSetFactory.setVertexCount(n);
        if (this.dataMin != this.dataMax) {
            pointSetFactory.setVertexRelativeRadii(dArray2);
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            IDataset iDataset;
            this.graphGroupNode = SceneGraphUtility.createFullSceneGraphComponent((String)"groupNode");
            this.sets = list;
            this.graph = sceneGraphComponent;
            this.determineRanges(list);
            Iterator<IDataset> iterator = list.iterator();
            Iterator iterator2 = this.xAxes.iterator();
            Iterator<AxisValues> iterator3 = this.yAxes.iterator();
            this.currentSelectWindow = new SelectedWindow(0.0, (int)this.globalXmax, 0.0, 0.0);
            this.numGraphs = 0;
            while (iterator.hasNext()) {
                iDataset = iterator.next();
                SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
                this.subGraphs.add(sceneGraphComponent2);
                AxisValues axisValues = (AxisValues)iterator2.next();
                AxisValues axisValues2 = iterator3.next();
                sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues, axisValues2));
                Appearance appearance = new Appearance();
                sceneGraphComponent2.setAppearance(appearance);
                DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
                appearance.setAttribute("lineShader.tubeDraw", false);
                appearance.setAttribute("pointShader.spheresDraw", false);
                appearance.setAttribute("attenuatePointSize", false);
                appearance.setAttribute("lightingEnabled", false);
                defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(false));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                this.graphPointShaders.add(defaultPointShader);
                Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(plot1DAppearance.getColour());
                if (this.dataMin == this.dataMax) {
                    defaultPointShader.setPointSize(Double.valueOf(this.dataMin));
                } else {
                    defaultPointShader.setPointSize(Double.valueOf(1.0));
                }
                this.graphShaders.add(defaultGeometryShader);
                this.graphGroupNode.addChild(sceneGraphComponent2);
                ++this.numGraphs;
            }
            this.buildClipPlanes(sceneGraphComponent);
            this.resizeAndPositionNodes();
            iDataset = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
            iDataset.setFieldOfView(56.5);
            if (this.background == null) {
                this.buildBackground();
                sceneGraphComponent.addChild(this.background);
                sceneGraphComponent.addTool((Tool)this.tool);
            }
            if (this.areaSelection == null) {
                this.buildAreaSelection();
            }
            if (this.xTicks != null) {
                this.xTicks.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTicks != null) {
                this.yTicks.setGeometry((Geometry)this.createYTicksGeometry());
            }
        }
        return sceneGraphComponent;
    }

    public void addAxises(AxisValues axisValues, AxisValues axisValues2) {
        this.xAxes.add(axisValues);
        this.yAxes.add(axisValues2);
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
        if (this.yAxes.size() > 0) {
            this.yAxes.set(0, axisValues);
        } else {
            this.yAxes.add(axisValues);
        }
    }

    @Override
    protected SceneGraphComponent buildAdditionalGraphNode() {
        SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)(String.valueOf(GRAPHNAMEPREFIX) + this.numGraphs));
        this.subGraphs.add(sceneGraphComponent);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        appearance.setAttribute("pointShader.spheresDraw", false);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("attenuatePointSize", false);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(this.numGraphs);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
        defaultPointShader.setPointSize(Double.valueOf(4.0));
        defaultPointShader.setDiffuseColor(plot1DAppearance.getColour());
        this.graphShaders.add(defaultGeometryShader);
        this.graphPointShaders.add(defaultPointShader);
        this.graphGroupNode.addChild(sceneGraphComponent);
        ++this.numGraphs;
        return sceneGraphComponent;
    }

    @Override
    public void removeLastGraphNode() {
        if (this.graph != null) {
            assert (this.graphPointShaders.size() > 1);
            this.graphPointShaders.remove(this.graphPointShaders.size() - 1);
            this.graphShaders.remove(this.graphShaders.size() - 1);
            SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)this.subGraphs.get(this.subGraphs.size() - 1);
            this.graphGroupNode.removeChild(sceneGraphComponent);
            this.subGraphs.remove(this.subGraphs.size() - 1);
            int n = this.subGraphs.size();
            while (n < this.xAxes.size()) {
                this.xAxes.remove(this.xAxes.size() - 1);
                ++n;
            }
            n = this.subGraphs.size();
            while (n < this.yAxes.size()) {
                this.yAxes.remove(this.yAxes.size() - 1);
                ++n;
            }
            --this.numGraphs;
        }
    }

    @Override
    protected void updateGraphs() {
        if (this.graph != null) {
            IDataset iDataset;
            int n = this.subGraphs.size();
            while (n < this.sets.size()) {
                this.buildAdditionalGraphNode();
                ++n;
            }
            Iterator iterator = this.sets.iterator();
            Iterator iterator2 = this.subGraphs.iterator();
            Iterator iterator3 = this.xAxes.iterator();
            Iterator<AxisValues> iterator4 = this.yAxes.iterator();
            Iterator iterator5 = this.graphPointShaders.iterator();
            while (iterator.hasNext()) {
                iDataset = (IDataset)iterator.next();
                SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)iterator2.next();
                AxisValues axisValues = (AxisValues)iterator3.next();
                AxisValues axisValues2 = iterator4.next();
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(iDataset, axisValues, axisValues2));
                DefaultPointShader defaultPointShader = (DefaultPointShader)iterator5.next();
                if (this.dataMin == this.dataMax) {
                    defaultPointShader.setPointSize(Double.valueOf(this.dataMin));
                    continue;
                }
                defaultPointShader.setPointSize(Double.valueOf(1.0));
            }
            while (iterator2.hasNext()) {
                iDataset = (SceneGraphComponent)iterator2.next();
                iDataset.setGeometry(null);
            }
        }
    }

    @Override
    protected void updateWindowWithNewRanges(List<IDataset> list, SelectedWindow selectedWindow) {
        Iterator iterator = this.xAxes.iterator();
        Iterator<AxisValues> iterator2 = this.yAxes.iterator();
        double d = 3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = 3.4028234663852886E38;
        double d4 = -3.4028234663852886E38;
        while (iterator.hasNext()) {
            AxisValues axisValues = (AxisValues)iterator.next();
            AxisValues axisValues2 = iterator2.next();
            d3 = Math.min(d3, axisValues.getMin());
            d4 = Math.max(d4, axisValues.getMax());
            d = Math.min(d, axisValues2.getMin());
            d2 = Math.max(d2, axisValues2.getMax());
        }
        selectedWindow.setStartWindowX(d3);
        selectedWindow.setEndWindowX(d4);
        selectedWindow.setStartWindowY(d);
        selectedWindow.setEndWindowY(d2);
    }

    @Override
    public void updateAllGraphAppearances() {
        int n = 0;
        while (n < this.graphShaders.size()) {
            Plot1DAppearance plot1DAppearance = this.graphColours.getLegendEntry(n);
            SceneGraphComponent sceneGraphComponent = (SceneGraphComponent)this.subGraphs.get(n);
            sceneGraphComponent.setVisible(plot1DAppearance.isVisible());
            ++n;
        }
    }

    @Override
    protected void updateGraphInZoom() {
        this.currentSelectWindow.getStartWindowX();
        this.currentSelectWindow.getEndWindowX();
        SelectedWindow selectedWindow = (SelectedWindow)this.undoSelectStack.get(this.undoSelectStack.size() - 1);
        this.updateWindowWithNewRanges(this.sets, selectedWindow);
    }
}

