/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.TickFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.SurfPlotStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SurfacePlotROI;

public class DataSet3DPlot3D
implements IDataSet3DCorePlot {
    public static int MAXDIM;
    public static final double HANDNESS = 1.0;
    protected static final Logger logger;
    protected static final int MAXJOGLDIM = 1200;
    protected static final int MAXSOFTDIM = 256;
    protected IDataset currentData = null;
    protected IDataset displayData = null;
    protected AxisMode xAxis = AxisMode.LINEAR;
    protected AxisMode yAxis = AxisMode.LINEAR;
    protected AxisMode zAxis = AxisMode.LINEAR;
    protected SceneGraphComponent graph = null;
    protected SceneGraphComponent xLabelNode = null;
    protected SceneGraphComponent yLabelNode = null;
    protected SceneGraphComponent zLabelNode = null;
    protected SceneGraphComponent xTicksNode = null;
    protected SceneGraphComponent yTicksNode = null;
    protected SceneGraphComponent zTicksNode = null;
    protected Appearance graphAppearance = null;
    protected DefaultGeometryShader dgsGraph = null;
    protected AxisValues xAxisValues;
    protected AxisValues yAxisValues;
    protected AxisValues zAxisValues;
    protected ColourImageData colourTable = null;
    protected double globalZmin;
    protected double globalZmax;
    protected double globalRealXmin;
    protected double globalRealXmax;
    protected double globalRealYmin;
    protected double globalRealYmax;
    protected double xSpan;
    protected double ySpan;
    protected double colourTableMin;
    protected double colourTableMax;
    protected int windowEndPosX;
    protected int windowEndPosY;
    protected int windowStartPosX;
    protected int windowStartPosY;
    protected boolean useWindow;
    protected boolean hasJOGL;
    protected boolean xCoordActive = true;
    protected boolean yCoordActive = true;
    protected boolean zCoordActive = true;
    private AbstractViewerApp app;
    private SceneGraphComponent axis = null;
    private SceneGraphComponent boundBoxNode = null;
    private SceneGraphComponent xAxisLabel = null;
    private SceneGraphComponent yAxisLabel = null;
    private SceneGraphComponent zAxisLabel = null;
    private DefaultTextShader dtsXTicks = null;
    private DefaultTextShader dtsYTicks = null;
    private DefaultTextShader dtsZTicks = null;
    private TickFactory tickFactory = null;
    private int MAXDIMSQR;
    private int currentXdim;
    private int currentYdim;
    private int samplingRate;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private TickFormatting xLabelMode = TickFormatting.plainMode;
    private TickFormatting yLabelMode = TickFormatting.plainMode;
    private TickFormatting zLabelMode = TickFormatting.plainMode;
    private String xAxisLabelStr;
    private String yAxisLabelStr;
    private String zAxisLabelStr;
    private SurfPlotStyles currentStyle = SurfPlotStyles.FILLED;

    static {
        logger = LoggerFactory.getLogger(DataSetPlotter.class);
    }

    public DataSet3DPlot3D(AbstractViewerApp abstractViewerApp, boolean bl, boolean bl2) {
        this.app = abstractViewerApp;
        this.hasJOGL = bl;
        this.useWindow = bl2;
        MAXDIM = this.hasJOGL ? 1200 : 256;
        this.MAXDIMSQR = MAXDIM * MAXDIM;
        this.tickFactory = new TickFactory(this.yLabelMode);
    }

    private IndexedLineSet createBBoxGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double[][] dArray = new double[8][3];
        int[][] nArray = new int[12][2];
        dArray[0][0] = -this.xSpan * 0.5;
        dArray[0][1] = 0.0;
        dArray[0][2] = -this.ySpan;
        dArray[1][0] = this.xSpan * 0.5;
        dArray[1][1] = 0.0;
        dArray[1][2] = -this.ySpan;
        dArray[2][0] = this.xSpan * 0.5;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = -this.xSpan * 0.5;
        dArray[3][1] = 0.0;
        dArray[3][2] = 0.0;
        dArray[4][0] = -this.xSpan * 0.5;
        dArray[4][1] = 15.0;
        dArray[4][2] = -this.ySpan;
        dArray[5][0] = this.xSpan * 0.5;
        dArray[5][1] = 15.0;
        dArray[5][2] = -this.ySpan;
        dArray[6][0] = this.xSpan * 0.5;
        dArray[6][1] = 15.0;
        dArray[6][2] = 0.0;
        dArray[7][0] = -this.xSpan * 0.5;
        dArray[7][1] = 15.0;
        dArray[7][2] = 0.0;
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 1;
        nArray[1][1] = 2;
        nArray[2][0] = 2;
        nArray[2][1] = 3;
        nArray[3][0] = 3;
        nArray[3][1] = 0;
        nArray[4][0] = 4;
        nArray[4][1] = 5;
        nArray[5][0] = 5;
        nArray[5][1] = 6;
        nArray[6][0] = 6;
        nArray[6][1] = 7;
        nArray[7][0] = 7;
        nArray[7][1] = 4;
        nArray[8][0] = 0;
        nArray[8][1] = 4;
        nArray[9][0] = 1;
        nArray[9][1] = 5;
        nArray[10][0] = 2;
        nArray[10][1] = 6;
        nArray[11][0] = 3;
        nArray[11][1] = 7;
        indexedLineSetFactory.setEdgeCount(12);
        indexedLineSetFactory.setVertexCount(8);
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildBoundingBox() {
        this.boundBoxNode = SceneGraphUtility.createFullSceneGraphComponent((String)"BBox");
        Appearance appearance = new Appearance();
        this.boundBoxNode.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setDiffuseColor(Color.GRAY);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        this.boundBoxNode.setGeometry((Geometry)this.createBBoxGeometry());
        MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.boundBoxNode);
        return this.boundBoxNode;
    }

    protected IndexedLineSet createXAxisTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, d, d2, (short)0, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[] dArray = new double[linkedList.size() * 2 * 3];
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        int n2 = 0;
        while (n2 < linkedList.size()) {
            double d3 = this.tickFactory.getTickUnit() * (double)n2;
            dArray[n2 * 2 * 3] = -this.xSpan * 0.5 + d3 / (this.globalRealXmax - this.globalRealXmin) * this.xSpan;
            dArray[n2 * 2 * 3 + 1] = 0.0;
            dArray[n2 * 2 * 3 + 2] = -this.ySpan;
            dArray[(n2 * 2 + 1) * 3] = -this.xSpan * 0.5 + d3 / (this.globalRealXmax - this.globalRealXmin) * this.xSpan;
            dArray[(n2 * 2 + 1) * 3 + 1] = 0.0;
            dArray[(n2 * 2 + 1) * 3 + 2] = 0.0;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createYAxisTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[] dArray = new double[linkedList.size() * 2 * 3];
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        double d = this.globalRealYmax - this.globalRealYmin;
        double d2 = this.ySpan * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        int n2 = 0;
        while (n2 < linkedList.size()) {
            dArray[n2 * 2 * 3] = -this.xSpan * 0.5;
            dArray[n2 * 2 * 3 + 1] = 0.0;
            dArray[n2 * 2 * 3 + 2] = -this.ySpan + (double)n2 * d2;
            dArray[(n2 * 2 + 1) * 3] = this.xSpan * 0.5;
            dArray[(n2 * 2 + 1) * 3 + 1] = 0.0;
            dArray[(n2 * 2 + 1) * 3 + 2] = -this.ySpan + (double)n2 * d2;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createZAxisTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        this.tickFactory.setTickMode(this.zLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalZmin, this.globalZmax, (short)1, false);
        double d = this.globalZmax - this.globalZmin;
        double d2 = 15.0 * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[] dArray = new double[linkedList.size() * 2 * 3];
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        int n2 = 0;
        while (n2 < linkedList.size()) {
            dArray[n2 * 2 * 3] = -this.xSpan * 0.5;
            dArray[n2 * 2 * 3 + 1] = (double)n2 * d2;
            dArray[n2 * 2 * 3 + 2] = -this.ySpan;
            dArray[(n2 * 2 + 1) * 3] = this.xSpan * 0.5;
            dArray[(n2 * 2 + 1) * 3 + 1] = (double)n2 * d2;
            dArray[(n2 * 2 + 1) * 3 + 2] = -this.ySpan;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxesTicks() {
        SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)"ticks");
        this.xTicksNode = SceneGraphUtility.createFullSceneGraphComponent((String)"xTicks");
        this.yTicksNode = SceneGraphUtility.createFullSceneGraphComponent((String)"yTicks");
        this.zTicksNode = SceneGraphUtility.createFullSceneGraphComponent((String)"zTicks");
        Appearance appearance = new Appearance();
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        defaultLineShader.setDiffuseColor(Color.black);
        defaultLineShader.setLineStipple(Boolean.valueOf(true));
        this.xTicksNode.setAppearance(appearance);
        this.yTicksNode.setAppearance(appearance);
        this.zTicksNode.setAppearance(appearance);
        sceneGraphComponent.addChild(this.xTicksNode);
        sceneGraphComponent.addChild(this.yTicksNode);
        sceneGraphComponent.addChild(this.zTicksNode);
        return sceneGraphComponent;
    }

    private IndexedLineSet createAxisGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double[][] dArray = new double[6][3];
        int[][] nArray = new int[3][2];
        dArray[0][0] = -this.xSpan * 0.5;
        dArray[0][1] = 0.0;
        dArray[0][2] = -this.ySpan;
        dArray[1][0] = this.xSpan * 0.5;
        dArray[1][1] = 0.0;
        dArray[1][2] = -this.ySpan;
        dArray[2][0] = -this.xSpan * 0.5;
        dArray[2][1] = 0.0;
        dArray[2][2] = -this.ySpan;
        dArray[3][0] = -this.xSpan * 0.5;
        dArray[3][1] = 15.0;
        dArray[3][2] = -this.ySpan;
        dArray[4][0] = -this.xSpan * 0.5;
        dArray[4][1] = 0.0;
        dArray[4][2] = -this.ySpan;
        dArray[5][0] = -this.xSpan * 0.5;
        dArray[5][1] = 0.0;
        dArray[5][2] = 0.0;
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 2;
        nArray[1][1] = 3;
        nArray[2][0] = 4;
        nArray[2][1] = 5;
        indexedLineSetFactory.setEdgeCount(3);
        indexedLineSetFactory.setVertexCount(6);
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    private PointSet createXAxisLabel() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        String string = this.xAxisLabelStr == null ? "" : this.xAxisLabelStr;
        String[] stringArray = new String[]{string};
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    private PointSet createYAxisLabel() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
        dArray[0][0] = -this.xSpan * 0.5 - 0.25;
        dArray[0][1] = 0.25;
        dArray[0][2] = -this.ySpan * 0.5;
        String string = this.yAxisLabelStr == null ? "" : this.yAxisLabelStr;
        String[] stringArray = new String[]{string};
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    private PointSet createZAxisLabel() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        pointSetFactory.setVertexCount(1);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(1);
        dArray[0][0] = -this.xSpan * 0.5 - 0.25;
        dArray[0][1] = 7.5;
        dArray[0][2] = -this.ySpan;
        String string = this.zAxisLabelStr == null ? "" : this.zAxisLabelStr;
        String[] stringArray = new String[]{string};
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxis(SceneGraphComponent sceneGraphComponent) {
        this.axis = sceneGraphComponent;
        this.xAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"xAxisLabel");
        this.yAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"yAxisLabel");
        this.zAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"zAxisLabel");
        this.axis.addChild(this.xAxisLabel);
        this.axis.addChild(this.yAxisLabel);
        this.axis.addChild(this.zAxisLabel);
        Appearance appearance = new Appearance();
        this.xAxisLabel.setAppearance(appearance);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        DefaultTextShader defaultTextShader = (DefaultTextShader)defaultPointShader.createTextShader("default");
        defaultTextShader.setDiffuseColor(Color.black);
        defaultTextShader.setScale(Double.valueOf(0.0075));
        appearance = new Appearance();
        this.yAxisLabel.setAppearance(appearance);
        appearance.setAttribute("pointShader.spheresDraw", false);
        defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        DefaultTextShader defaultTextShader2 = (DefaultTextShader)defaultPointShader.createTextShader("default");
        defaultTextShader2.setDiffuseColor(Color.black);
        defaultTextShader2.setScale(Double.valueOf(0.0075));
        appearance = new Appearance();
        this.zAxisLabel.setAppearance(appearance);
        appearance.setAttribute("pointShader.spheresDraw", false);
        defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        DefaultTextShader defaultTextShader3 = (DefaultTextShader)defaultPointShader.createTextShader("default");
        defaultTextShader3.setDiffuseColor(Color.black);
        defaultTextShader3.setScale(Double.valueOf(0.0075));
        defaultTextShader3.setTextdirection(Integer.valueOf(1));
        Appearance appearance2 = sceneGraphComponent.getAppearance();
        DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
        appearance2.setAttribute("lineShader.tubeDraw", false);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(false));
        return sceneGraphComponent;
    }

    protected void determineGraphSize(int n, int n2) {
        if (n == 0 || n2 == 0) {
            int n3;
            int n4 = this.displayData.getShape()[1];
            int n5 = this.displayData.getShape()[0];
            if (n5 > (n3 = n4)) {
                n3 = n5;
            }
            this.xSpan = 15.0 * ((double)n4 / (double)n3);
            this.ySpan = 15.0 * ((double)n5 / (double)n3);
            this.xSpan = Math.max(this.xSpan, 4.0);
            this.ySpan = Math.max(this.ySpan, 4.0);
        } else if (n > n2) {
            this.xSpan = 15.0;
            this.ySpan = 15.0 * ((double)n2 / (double)n);
        } else {
            this.ySpan = 15.0;
            this.xSpan = 15.0 * ((double)n / (double)n2);
        }
    }

    private Geometry switchToLineGraphGeometry() {
        if (this.graph != null) {
            DataList dataList = this.graph.getGeometry().getAttributes("VERTEX", Attribute.COORDINATES);
            DataList dataList2 = this.graph.getGeometry().getAttributes("VERTEX", Attribute.COLORS);
            int n = this.displayData.getShape()[1];
            int n2 = this.displayData.getShape()[0];
            IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
            indexedLineSetFactory.setVertexCount(n * n2);
            indexedLineSetFactory.setEdgeCount((n - 1) * (n2 - 1));
            indexedLineSetFactory.setVertexCoordinates(dataList);
            indexedLineSetFactory.setVertexColors(dataList2);
            int[][] nArray = new int[(n - 1) * (n2 - 1)][2];
            int n3 = 0;
            while (n3 < n2 - 1) {
                int n4 = 0;
                while (n4 < n - 1) {
                    nArray[n4 + n3 * (n - 1)][0] = n4 + n3 * n;
                    nArray[n4 + n3 * (n - 1)][1] = n4 + 1 + n3 * n;
                    ++n4;
                }
                ++n3;
            }
            indexedLineSetFactory.setEdgeIndices(nArray);
            indexedLineSetFactory.update();
            return indexedLineSetFactory.getIndexedLineSet();
        }
        return null;
    }

    private Geometry switchToStandardGraphGeometry() {
        if (this.graph != null) {
            DataList dataList = this.graph.getGeometry().getAttributes("VERTEX", Attribute.COORDINATES);
            DataList dataList2 = this.graph.getGeometry().getAttributes("VERTEX", Attribute.COLORS);
            int n = this.displayData.getShape()[1];
            int n2 = this.displayData.getShape()[0];
            QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
            quadMeshFactory.setVLineCount(n2);
            quadMeshFactory.setULineCount(n);
            quadMeshFactory.setClosedInUDirection(false);
            quadMeshFactory.setClosedInVDirection(false);
            quadMeshFactory.setVertexCoordinates(dataList);
            quadMeshFactory.setVertexColors(dataList2);
            quadMeshFactory.setGenerateFaceNormals(true);
            quadMeshFactory.setGenerateTextureCoordinates(false);
            quadMeshFactory.setGenerateEdgesFromFaces(true);
            quadMeshFactory.setEdgeFromQuadMesh(true);
            quadMeshFactory.update();
            return quadMeshFactory.getIndexedFaceSet();
        }
        return null;
    }

    protected Geometry createGraphGeometry(int n, int n2) {
        int n3 = this.displayData.getShape()[1];
        int n4 = this.displayData.getShape()[0];
        this.determineGraphSize(n, n2);
        double[] dArray = new double[n3 * n4 * 3];
        double[] dArray2 = new double[n3 * n4 * 3];
        double d = this.xSpan / (double)n3;
        double d2 = this.ySpan / (double)n4;
        double d3 = 15.0 / (this.globalZmax - this.globalZmin);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                double d4 = this.displayData.getDouble(new int[]{n5, n6});
                dArray[(n6 + n5 * n3) * 3] = -this.xSpan * 0.5 + d * (double)n6;
                dArray[(n6 + n5 * n3) * 3 + 1] = d3 * (d4 - this.globalZmin);
                dArray[(n6 + n5 * n3) * 3 + 2] = this.ySpan * -1.0 + (double)n5 * 1.0 * d2;
                if (this.colourTable == null) {
                    dArray2[(n6 + n5 * n3) * 3] = 0.25;
                    dArray2[(n6 + n5 * n3) * 3 + 1] = (d4 - this.globalZmin) / (this.globalZmax - this.globalZmin);
                    dArray2[(n6 + n5 * n3) * 3 + 2] = 0.25;
                } else if (this.hasJOGL) {
                    n11 = (int)((double)this.colourTable.getWidth() * ((d4 - this.colourTableMin) / (this.colourTableMax - this.colourTableMin)));
                    n11 = Math.min(Math.max(0, n11), this.colourTable.getWidth() - 1);
                    n10 = this.colourTable.get(n11);
                    n9 = n10 >> 16 & 0xFF;
                    n8 = n10 >> 8 & 0xFF;
                    n7 = n10 & 0xFF;
                    dArray2[(n6 + n5 * n3) * 3] = (double)n9 / 255.0;
                    dArray2[(n6 + n5 * n3) * 3 + 1] = (double)n8 / 255.0;
                    dArray2[(n6 + n5 * n3) * 3 + 2] = (double)n7 / 255.0;
                } else {
                    n11 = Math.min(n6, this.colourTable.getWidth() - 1);
                    n10 = Math.min(n5, this.colourTable.getHeight() - 1);
                    n9 = this.colourTable.get(n11 + n10 * this.colourTable.getWidth());
                    n8 = n9 >> 16 & 0xFF;
                    n7 = n9 >> 8 & 0xFF;
                    int n12 = n9 & 0xFF;
                    dArray2[(n6 + n5 * n3) * 3] = (double)n8 / 255.0;
                    dArray2[(n6 + n5 * n3) * 3 + 1] = (double)n7 / 255.0;
                    dArray2[(n6 + n5 * n3) * 3 + 2] = (double)n12 / 255.0;
                }
                ++n6;
            }
            ++n5;
        }
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        quadMeshFactory.setVLineCount(n4);
        quadMeshFactory.setULineCount(n3);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setVertexColors(dArray2);
        quadMeshFactory.setGenerateFaceNormals(false);
        quadMeshFactory.setGenerateTextureCoordinates(false);
        quadMeshFactory.setGenerateEdgesFromFaces(true);
        quadMeshFactory.setEdgeFromQuadMesh(false);
        quadMeshFactory.update();
        return quadMeshFactory.getIndexedFaceSet();
    }

    protected void buildDisplayDataSet() {
        int n;
        int n2 = this.currentData.getShape()[1];
        if (n2 * (n = this.currentData.getShape()[0]) > this.MAXDIMSQR) {
            if (this.useWindow) {
                logger.info("DataSet is too large to visualize all at once using window");
                this.samplingRate = 1;
                float f = (float)this.MAXDIMSQR / (float)(n2 * n);
                float f2 = (float)n2 / (float)(n2 + n);
                float f3 = (float)n / (float)(n2 + n);
                float f4 = 1.0f - (1.0f - f) * f2;
                float f5 = 1.0f - (1.0f - f) * f3;
                this.currentXdim = (int)((float)n2 * f4 * 0.75f);
                this.currentYdim = (int)((float)n * f5 * 0.75f);
                this.windowStartPosX = 0;
                this.windowStartPosY = 0;
                this.windowEndPosX = this.currentXdim - 1;
                this.windowEndPosY = this.currentYdim - 1;
            } else {
                logger.info("DataSet is too large to visualize all at once using subsampling");
                this.samplingRate = n > n2 ? (int)Math.ceil(n / MAXDIM) : (int)Math.ceil(n2 / MAXDIM);
                this.currentYdim = n / this.samplingRate;
                this.currentXdim = n2 / this.samplingRate;
            }
            int[] nArray = new int[2];
            int[] nArray2 = new int[]{this.useWindow ? this.currentYdim : n, this.useWindow ? this.currentXdim : n2};
            int[] nArray3 = new int[]{this.samplingRate, this.samplingRate};
            this.displayData = this.currentData.getSlice(nArray, nArray2, nArray3);
        } else {
            this.displayData = this.currentData;
            this.windowEndPosX = n2 - 1;
            this.windowEndPosY = n - 1;
        }
    }

    protected void setGlobalMinMax() {
        switch (this.xAxis) {
            case LINEAR: {
                this.globalRealXmin = 0.0;
                if (!this.useWindow) {
                    this.globalRealXmax = this.currentData.getShape()[1];
                    break;
                }
                this.globalRealXmax = this.windowEndPosX;
                this.globalRealXmin = this.windowStartPosX;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealXmin = this.xOffset;
                if (!this.useWindow) {
                    this.globalRealXmax = (double)this.currentData.getShape()[1] + this.xOffset;
                    break;
                }
                this.globalRealXmax = (double)this.windowEndPosX + this.xOffset;
                this.globalRealXmin = (double)this.windowStartPosX + this.xOffset;
                break;
            }
            case CUSTOM: {
                if (!this.useWindow || this.windowEndPosX == 0) {
                    this.globalRealXmin = this.xAxisValues.getMin();
                    this.globalRealXmax = this.xAxisValues.getMax();
                    break;
                }
                this.globalRealXmin = this.xAxisValues.getValue(this.windowStartPosX);
                this.globalRealXmax = this.xAxisValues.getValue(this.windowEndPosX);
            }
        }
        switch (this.yAxis) {
            case LINEAR: {
                this.globalRealYmin = 0.0;
                if (!this.useWindow) {
                    this.globalRealYmax = this.currentData.getShape()[0];
                    break;
                }
                this.globalRealYmax = this.windowEndPosY;
                this.globalRealYmin = this.windowStartPosY;
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealYmin = this.yOffset;
                if (!this.useWindow) {
                    this.globalRealYmax = (double)this.currentData.getShape()[0] + this.yOffset;
                    break;
                }
                this.globalRealYmax = (double)this.windowEndPosY + this.yOffset;
                this.globalRealYmin = (double)this.windowStartPosY + this.yOffset;
                break;
            }
            case CUSTOM: {
                if (!this.useWindow || this.windowEndPosY == 0) {
                    this.globalRealYmin = this.yAxisValues.getMin();
                    this.globalRealYmax = this.yAxisValues.getMax();
                    break;
                }
                this.globalRealYmin = this.yAxisValues.getValue(this.windowStartPosY);
                this.globalRealYmax = this.yAxisValues.getValue(this.windowEndPosY);
            }
        }
    }

    public void setDataWindow(SurfacePlotROI surfacePlotROI) {
        if (this.useWindow) {
            int n;
            this.windowStartPosX = surfacePlotROI.getStartX();
            this.windowStartPosY = surfacePlotROI.getStartY();
            this.windowEndPosX = surfacePlotROI.getEndX();
            this.windowEndPosY = surfacePlotROI.getEndY();
            if (this.windowStartPosX > this.windowEndPosX) {
                n = this.windowStartPosX;
                this.windowStartPosX = this.windowEndPosX;
                this.windowEndPosX = n;
            }
            if (this.windowStartPosY > this.windowEndPosY) {
                n = this.windowStartPosY;
                this.windowStartPosY = this.windowEndPosY;
                this.windowEndPosY = n;
            }
            int n2 = Math.abs(this.windowEndPosX - this.windowStartPosX);
            int n3 = Math.abs(this.windowEndPosY - this.windowStartPosY);
            if (n2 < 2) {
                if (this.windowEndPosX + 2 >= this.currentData.getShape()[1]) {
                    this.windowStartPosX -= 2;
                } else {
                    this.windowEndPosX += 2;
                }
            }
            if (n3 < 2) {
                if (this.windowEndPosY + 2 >= this.currentData.getShape()[0]) {
                    this.windowStartPosY -= 2;
                } else {
                    this.windowEndPosY += 2;
                }
            }
            if (this.windowStartPosX == this.windowEndPosX) {
                ++this.windowEndPosX;
            }
            if (this.windowStartPosY == this.windowEndPosY) {
                // empty if block
            }
            int[] nArray = new int[]{this.windowStartPosY, this.windowStartPosX};
            int[] nArray2 = new int[]{++this.windowEndPosY, this.windowEndPosX};
            int[] nArray3 = new int[]{1, 1};
            this.displayData = this.currentData.getSlice(nArray, nArray2, nArray3);
            if (surfacePlotROI.getXSamplingMode() > 0 || surfacePlotROI.getYSamplingMode() > 0) {
                int n4 = Math.abs(this.windowEndPosX - this.windowStartPosX);
                int n5 = Math.abs(this.windowEndPosY - this.windowStartPosY);
                float f = (float)this.MAXDIMSQR / (float)(n4 * n5);
                float f2 = (float)n4 / (float)(n5 + n4);
                float f3 = (float)n5 / (float)(n5 + n4);
                float f4 = (1.0f - f) * (surfacePlotROI.getYSamplingMode() != 0 ? f2 : 1.0f);
                float f5 = (1.0f - f) * (surfacePlotROI.getXSamplingMode() != 0 ? f3 : 1.0f);
                f4 = (float)Math.sqrt(f4);
                f5 = (float)Math.sqrt(f5);
                int n6 = surfacePlotROI.getXSamplingMode() == 0 ? n4 : (int)Math.floor((float)n4 * (1.0f - f4));
                int n7 = surfacePlotROI.getYSamplingMode() == 0 ? n5 : (int)Math.floor((float)n5 * (1.0f - f5));
                DownsampleMode downsampleMode = DownsampleMode.POINT;
                switch (surfacePlotROI.getXSamplingMode()) {
                    case 2: {
                        downsampleMode = DownsampleMode.MEAN;
                        break;
                    }
                    case 3: {
                        downsampleMode = DownsampleMode.MAXIMUM;
                        break;
                    }
                    case 4: {
                        downsampleMode = DownsampleMode.MINIMUM;
                    }
                }
                int n8 = (int)Math.ceil((double)n4 / (double)n6);
                int n9 = (int)Math.round((double)n5 / (double)n7);
                Downsample downsample = new Downsample(downsampleMode, new int[]{surfacePlotROI.getYSamplingMode() == surfacePlotROI.getXSamplingMode() ? n9 : 1, n8});
                this.displayData = (IDataset)downsample.value(new IDataset[]{this.displayData}).get(0);
                if (surfacePlotROI.getYSamplingMode() != surfacePlotROI.getXSamplingMode() && surfacePlotROI.getYSamplingMode() != 0) {
                    switch (surfacePlotROI.getYSamplingMode()) {
                        case 1: {
                            downsampleMode = DownsampleMode.POINT;
                            break;
                        }
                        case 2: {
                            downsampleMode = DownsampleMode.MEAN;
                            break;
                        }
                        case 3: {
                            downsampleMode = DownsampleMode.MAXIMUM;
                            break;
                        }
                        case 4: {
                            downsampleMode = DownsampleMode.MINIMUM;
                        }
                    }
                    downsample = new Downsample(downsampleMode, new int[]{n9, 1});
                    this.displayData = (IDataset)downsample.value(new IDataset[]{this.displayData}).get(0);
                }
            }
            this.updateDisplay(surfacePlotROI.getXAspect(), surfacePlotROI.getYAspect());
        }
    }

    protected void buildOtherNodes() {
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFieldOfView(56.5);
        MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.graph);
        if (this.axis != null) {
            this.axis.setGeometry((Geometry)this.createAxisGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.axis);
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.xLabelNode);
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.yLabelNode);
        }
        if (this.zLabelNode != null) {
            this.zLabelNode.setGeometry((Geometry)this.createZLabelsGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.zLabelNode);
        }
        if (this.xTicksNode != null) {
            this.xTicksNode.setGeometry((Geometry)this.createXAxisTicksGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.xTicksNode);
        }
        if (this.yTicksNode != null) {
            this.yTicksNode.setGeometry((Geometry)this.createYAxisTicksGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.yTicksNode);
        }
        if (this.zTicksNode != null) {
            this.zTicksNode.setGeometry((Geometry)this.createZAxisTicksGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.zTicksNode);
        }
        if (this.xAxisLabel != null) {
            this.xAxisLabel.setGeometry((Geometry)this.createXAxisLabel());
        }
        if (this.yAxisLabel != null) {
            this.yAxisLabel.setGeometry((Geometry)this.createYAxisLabel());
        }
        if (this.zAxisLabel != null) {
            this.zAxisLabel.setGeometry((Geometry)this.createZAxisLabel());
        }
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        if (sceneGraphComponent != null) {
            this.graph = sceneGraphComponent;
            this.currentData = list.get(0);
            this.buildDisplayDataSet();
            this.setGlobalMinMax();
            this.globalZmin = this.displayData.min().doubleValue();
            this.globalZmax = this.displayData.max().doubleValue();
            this.graphAppearance = new Appearance();
            sceneGraphComponent.setGeometry(this.createGraphGeometry(0, 0));
            sceneGraphComponent.setAppearance(this.graphAppearance);
            this.dgsGraph = ShaderUtility.createDefaultGeometryShader((Appearance)this.graphAppearance, (boolean)true);
            this.graphAppearance.setAttribute("vertexColors", true);
            this.graphAppearance.setAttribute("lightingEnabled", false);
            this.graphAppearance.setAttribute("lineShader.tubeDraw", false);
            this.graphAppearance.setAttribute("pointShader.spheresDraw", false);
            this.graphAppearance.setAttribute("pointShader.pointSize", 1.0);
            this.graphAppearance.setAttribute("attenuatePointSize", false);
            this.dgsGraph.setShowFaces(Boolean.valueOf(true));
            this.dgsGraph.setShowLines(Boolean.valueOf(false));
            this.dgsGraph.setShowPoints(Boolean.valueOf(false));
            this.buildOtherNodes();
        }
        return sceneGraphComponent;
    }

    protected PointSet createXLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, d, d2, (short)0, false);
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        double d3 = -100.0;
        if (this.xAxis == AxisMode.CUSTOM) {
            boolean bl = this.xAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                double d4;
                double d5 = this.tickFactory.getTickUnit() * (double)n2;
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray[n2][0] = d4 = -this.xSpan * 0.5 + d5 / (this.globalRealXmax - this.globalRealXmin) * this.xSpan;
                dArray[n2][1] = -0.125;
                dArray[n2][2] = -this.ySpan - 0.25;
                if (Math.abs(d4 - d3) > 0.5) {
                    stringArray[n2] = tick.getTickName();
                    d3 = d4;
                } else {
                    stringArray[n2] = "";
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                double d6 = this.tickFactory.getTickUnit() * (double)n3;
                Tick tick = linkedList.get(n3);
                double d7 = -this.xSpan * 0.5 + d6 / (this.globalRealXmax - this.globalRealXmin) * this.xSpan;
                dArray[n3][0] = -this.xSpan * 0.5 + d6 / (this.globalRealXmax - this.globalRealXmin) * this.xSpan;
                dArray[n3][1] = -0.125;
                dArray[n3][2] = -this.ySpan - 0.25;
                if (Math.abs(d7 - d3) > 0.5) {
                    stringArray[n3] = tick.getTickName();
                    d3 = d7;
                } else {
                    stringArray[n3] = "";
                }
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected PointSet createYLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        double d = this.globalRealYmax - this.globalRealYmin;
        double d2 = this.ySpan * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        if (this.yAxis == AxisMode.CUSTOM) {
            boolean bl = this.yAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray[n2][0] = -this.xSpan * 0.5 - 0.25;
                dArray[n2][1] = 0.0;
                dArray[n2][2] = -this.ySpan + (double)n2 * d2;
                stringArray[n2] = tick.getTickName();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                Tick tick = linkedList.get(n3);
                dArray[n3][0] = -this.xSpan * 0.5 - 0.25;
                dArray[n3][1] = 0.0;
                dArray[n3][2] = -this.ySpan + (double)n3 * d2;
                stringArray[n3] = tick.getTickName();
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    protected PointSet createZLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        this.tickFactory.setTickMode(this.zLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalZmin, this.globalZmax, (short)1, false);
        double d = this.globalZmax - this.globalZmin;
        double d2 = 15.0 * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        int n2 = 0;
        while (n2 < linkedList.size()) {
            Tick tick = linkedList.get(n2);
            dArray[n2][0] = -this.xSpan * 0.5 - 0.25;
            dArray[n2][1] = (double)n2 * d2;
            dArray[n2][2] = -this.ySpan;
            stringArray[n2] = tick.getTickName();
            ++n2;
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public void buildXCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.xLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        this.xLabelNode.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsXTicks.setOffset(dArray);
        this.dtsXTicks.setScale(Double.valueOf(0.0075));
        this.dtsXTicks.setDiffuseColor(Color.black);
        this.dtsXTicks.setAlignment(Integer.valueOf(0));
    }

    @Override
    public void buildYCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.yLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        this.yLabelNode.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsYTicks.setOffset(dArray);
        this.dtsYTicks.setScale(Double.valueOf(0.0075));
        this.dtsYTicks.setDiffuseColor(Color.black);
        this.dtsYTicks.setAlignment(Integer.valueOf(0));
    }

    @Override
    public void buildZCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.zLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        this.zLabelNode.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsZTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsZTicks.setOffset(dArray);
        this.dtsZTicks.setScale(Double.valueOf(0.0075));
        this.dtsZTicks.setDiffuseColor(Color.black);
        this.dtsZTicks.setAlignment(Integer.valueOf(0));
    }

    @Override
    public void cleanUpGraphNode() {
        if (this.axis != null) {
            this.axis.removeChild(this.xAxisLabel);
            this.axis.removeChild(this.yAxisLabel);
            this.axis.removeChild(this.zAxisLabel);
        }
        if (this.xAxisLabel != null) {
            this.xAxisLabel.setGeometry(null);
        }
        if (this.yAxisLabel != null) {
            this.yAxisLabel.setGeometry(null);
        }
        if (this.zAxisLabel != null) {
            this.zAxisLabel.setGeometry(null);
        }
        if (this.zLabelNode != null) {
            this.zLabelNode.setGeometry(null);
        }
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        if (sceneGraphComponent != null) {
            this.colourTable = colourImageData;
            this.colourTableMin = d;
            this.colourTableMax = d2;
            if (sceneGraphComponent.getGeometry() != null) {
                PointSet pointSet = (PointSet)sceneGraphComponent.getGeometry();
                int n = this.displayData.getShape()[1];
                int n2 = this.displayData.getShape()[0];
                double[][] dArray = new double[n * n2][3];
                if (this.hasJOGL) {
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = 0;
                        while (n4 < n) {
                            double d3 = this.displayData.getDouble(new int[]{n3, n4});
                            int n5 = (int)((double)colourImageData.getWidth() * ((d3 - d) / (d2 - d)));
                            n5 = Math.min(Math.max(0, n5), colourImageData.getWidth() - 1);
                            int n6 = colourImageData.get(n5);
                            int n7 = n6 >> 16 & 0xFF;
                            int n8 = n6 >> 8 & 0xFF;
                            int n9 = n6 & 0xFF;
                            dArray[n4 + n3 * n][0] = (double)n7 / 255.0;
                            dArray[n4 + n3 * n][1] = (double)n8 / 255.0;
                            dArray[n4 + n3 * n][2] = (double)n9 / 255.0;
                            ++n4;
                        }
                        ++n3;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        int n11 = 0;
                        while (n11 < n) {
                            int n12 = colourImageData.get(n11 + n10 * n);
                            int n13 = n12 >> 16 & 0xFF;
                            int n14 = n12 >> 8 & 0xFF;
                            int n15 = n12 & 0xFF;
                            dArray[n11 + n10 * n][0] = (double)n13 / 255.0;
                            dArray[n11 + n10 * n][1] = (double)n14 / 255.0;
                            dArray[n11 + n10 * n][2] = (double)n15 / 255.0;
                            ++n11;
                        }
                        ++n10;
                    }
                }
                pointSet.setVertexAttributes(Attribute.COLORS, (DataList)new DoubleArrayArray.Array(dArray));
            }
        }
    }

    @Override
    public void notifyComponentResize(int n, int n2) {
    }

    @Override
    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.xAxis = axisMode;
        this.yAxis = axisMode2;
        this.zAxis = axisMode3;
    }

    @Override
    public void setScaling(ScaleType scaleType) {
    }

    @Override
    public void setTickGridLinesActive(boolean bl, boolean bl2, boolean bl3) {
        this.xCoordActive = bl;
        this.yCoordActive = bl2;
        this.zCoordActive = bl3;
        if (bl) {
            this.xTicksNode.setGeometry((Geometry)this.createXAxisTicksGeometry());
        } else {
            this.xTicksNode.setGeometry(null);
        }
        if (bl2) {
            this.yTicksNode.setGeometry((Geometry)this.createYAxisTicksGeometry());
        } else {
            this.yTicksNode.setGeometry(null);
        }
        if (bl3) {
            this.zTicksNode.setGeometry((Geometry)this.createZAxisTicksGeometry());
        } else {
            this.zTicksNode.setGeometry(null);
        }
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void setXAxisLabel(String string) {
        if (!string.equals(this.xAxisLabelStr)) {
            this.xAxisLabelStr = string;
            if (this.xAxisLabel != null) {
                this.xAxisLabel.setGeometry((Geometry)this.createXAxisLabel());
            }
        }
    }

    @Override
    public void setXAxisLabelMode(TickFormatting tickFormatting) {
        this.xLabelMode = tickFormatting;
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
    }

    @Override
    public void setXAxisOffset(double d) {
        this.xOffset = d;
    }

    @Override
    public void setXAxisValues(AxisValues axisValues, int n) {
        this.xAxisValues = axisValues;
    }

    @Override
    public void setYAxisLabel(String string) {
        if (!string.equals(this.yAxisLabelStr)) {
            this.yAxisLabelStr = string;
            if (this.yAxisLabel != null) {
                this.yAxisLabel.setGeometry((Geometry)this.createYAxisLabel());
            }
        }
    }

    @Override
    public void setYAxisLabelMode(TickFormatting tickFormatting) {
        this.yLabelMode = tickFormatting;
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
    }

    @Override
    public void setYAxisOffset(double d) {
        this.yOffset = d;
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
        this.yAxisValues = axisValues;
    }

    @Override
    public void setZAxisLabel(String string) {
        if (!string.equals(this.zAxisLabelStr)) {
            this.zAxisLabelStr = string;
            if (this.zAxisLabel != null) {
                this.zAxisLabel.setGeometry((Geometry)this.createZAxisLabel());
            }
        }
    }

    @Override
    public void setZAxisLabelMode(TickFormatting tickFormatting) {
        this.zLabelMode = tickFormatting;
        if (this.zLabelNode != null) {
            this.zLabelNode.setGeometry((Geometry)this.createZLabelsGeometry());
        }
    }

    @Override
    public void setZAxisOffset(double d) {
        this.zOffset = d;
    }

    @Override
    public void setZAxisValues(AxisValues axisValues) {
        this.zAxisValues = axisValues;
    }

    protected void updateDisplay(int n, int n2) {
        this.setGlobalMinMax();
        this.globalZmin = this.displayData.min().doubleValue();
        this.globalZmax = this.displayData.max().doubleValue();
        this.graph.setGeometry(this.createGraphGeometry(n, n2));
        if (this.axis != null) {
            this.axis.setGeometry((Geometry)this.createAxisGeometry());
            MatrixBuilder.euclidean().translate(0.0, -7.5, 0.0).assignTo(this.axis);
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        if (this.zLabelNode != null) {
            this.zLabelNode.setGeometry((Geometry)this.createZLabelsGeometry());
        }
        if (this.xTicksNode != null && this.xCoordActive) {
            this.xTicksNode.setGeometry((Geometry)this.createXAxisTicksGeometry());
        }
        if (this.yTicksNode != null && this.yCoordActive) {
            this.yTicksNode.setGeometry((Geometry)this.createYAxisTicksGeometry());
        }
        if (this.zTicksNode != null && this.zCoordActive) {
            this.zTicksNode.setGeometry((Geometry)this.createZAxisTicksGeometry());
        }
        if (this.boundBoxNode != null) {
            this.boundBoxNode.setGeometry((Geometry)this.createBBoxGeometry());
        }
    }

    @Override
    public void updateGraph(IDataset iDataset) {
        if (this.graph != null) {
            this.currentData = iDataset;
            this.buildDisplayDataSet();
            this.updateDisplay(0, 0);
        }
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        this.updateGraph(list.get(0));
    }

    public void setStyle(SurfPlotStyles surfPlotStyles) {
        if (surfPlotStyles != this.currentStyle) {
            if (this.currentStyle == SurfPlotStyles.LINEGRAPH) {
                this.graph.setGeometry(this.switchToStandardGraphGeometry());
            }
            if (this.currentStyle != SurfPlotStyles.LINEGRAPH && surfPlotStyles == SurfPlotStyles.LINEGRAPH) {
                this.graph.setGeometry(this.switchToLineGraphGeometry());
            }
            switch (surfPlotStyles) {
                case FILLED: {
                    this.dgsGraph.setShowFaces(Boolean.valueOf(true));
                    this.dgsGraph.setShowLines(Boolean.valueOf(false));
                    this.dgsGraph.setShowPoints(Boolean.valueOf(false));
                    break;
                }
                case WIREFRAME: {
                    this.dgsGraph.setShowFaces(Boolean.valueOf(false));
                    this.dgsGraph.setShowLines(Boolean.valueOf(true));
                    this.dgsGraph.setShowPoints(Boolean.valueOf(false));
                    break;
                }
                case LINEGRAPH: {
                    this.dgsGraph.setShowFaces(Boolean.valueOf(false));
                    this.dgsGraph.setShowLines(Boolean.valueOf(true));
                    this.dgsGraph.setShowPoints(Boolean.valueOf(false));
                    break;
                }
                case POINTS: {
                    this.dgsGraph.setShowFaces(Boolean.valueOf(false));
                    this.dgsGraph.setShowLines(Boolean.valueOf(false));
                    this.dgsGraph.setShowPoints(Boolean.valueOf(true));
                }
            }
            this.currentStyle = surfPlotStyles;
        }
    }

    @Override
    public void resetView() {
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFieldOfView(56.5);
    }

    @Override
    public ScaleType getScaling() {
        return ScaleType.LINEAR;
    }

    @Override
    public List<AxisValues> getAxisValues() {
        return null;
    }
}

