/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.nexus;

import gda.data.nexus.tree.INexusTree;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.NexusLabelProvider;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.NexusLazyContentProvider;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.TreeFilter;

public class NexusTableTree
extends Composite {
    private TreeViewer tViewer = null;
    private Listener slistener;
    private Listener dlistener;

    public NexusTableTree(Composite composite, Listener listener, Listener listener2) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.slistener = listener;
        this.dlistener = listener2;
        String[] stringArray = new String[]{"target"};
        TreeFilter treeFilter = new TreeFilter(stringArray);
        this.tViewer = new TreeViewer((Composite)this, 0x10000800);
        this.tViewer.addFilter((ViewerFilter)treeFilter);
        Tree tree = this.tViewer.getTree();
        tree.setHeaderVisible(true);
        String[] stringArray2 = new String[]{"Name", "Class", "Dims", "Type", "Data"};
        int[] nArray = new int[]{250, 120, 80, 60, 300};
        int n = 0;
        while (n < stringArray2.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.tViewer, 0);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(stringArray2[n]);
            treeColumn.setWidth(nArray[n]);
            treeColumn.setMoveable(true);
            ++n;
        }
        this.tViewer.setContentProvider((IContentProvider)new NexusLazyContentProvider(this.tViewer, treeFilter));
        this.tViewer.setLabelProvider((IBaseLabelProvider)new NexusLabelProvider());
        if (listener != null) {
            tree.addListener(4, listener);
        }
        if (listener2 != null) {
            tree.addListener(8, listener2);
        }
        this.addMenu(this.tViewer);
    }

    public Viewer getViewer() {
        return this.tViewer;
    }

    public void dispose() {
        if (this.slistener != null) {
            this.tViewer.getTree().removeListener(4, this.slistener);
        }
        if (this.dlistener != null) {
            this.tViewer.getTree().removeListener(8, this.dlistener);
        }
        this.tViewer.getTree().dispose();
        super.dispose();
    }

    private void addMenu(TreeViewer treeViewer) {
        MenuManager menuManager = new MenuManager();
        int n = 0;
        while (n < treeViewer.getTree().getColumnCount()) {
            final TreeColumn treeColumn = treeViewer.getTree().getColumn(n);
            Action action = new Action(treeViewer.getTree().getColumn(n).getText(), 32){

                public void runWithEvent(Event event) {
                    if (!this.isChecked()) {
                        int n = treeColumn.getWidth();
                        treeColumn.setData("restoredWidth", (Object)new Integer(n));
                        treeColumn.setWidth(0);
                    } else {
                        int n = (Integer)treeColumn.getData("restoredWidth");
                        treeColumn.setWidth(n);
                    }
                }
            };
            action.setChecked(true);
            menuManager.add((IAction)action);
            ++n;
        }
        treeViewer.getControl().setMenu(menuManager.createContextMenu(treeViewer.getControl()));
    }

    public void setInput(INexusTree iNexusTree) {
        if (this.tViewer != null && this.tViewer.getContentProvider() != null) {
            this.tViewer.setInput((Object)iNexusTree);
        }
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.tViewer.getSelection();
    }

    public void expandAll() {
        this.tViewer.expandAll();
    }
}

