/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.imagegrid;

import java.util.ArrayList;
import uk.ac.diamond.scisoft.analysis.plotserver.GridImageEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.AbstractGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.GridEntryMonitor;

public abstract class AbstractImageGrid {
    public static int MAXTHUMBWIDTH = 96;
    public static int MAXTHUMBHEIGHT = 96;
    public static int MINTHUMBWIDTH = 48;
    public static int MINTHUMBHEIGHT = 48;
    public static int MAXMEMORYUSAGE = 0x9600000;
    protected int gridWidth;
    protected int gridHeight;
    protected AbstractGridEntry[] table;
    protected int nextEntryX = 0;
    protected int nextEntryY = 0;
    protected GridEntryMonitor monitor = null;

    public AbstractImageGrid() {
        this.gridWidth = 10;
        this.gridHeight = 10;
        this.table = new AbstractGridEntry[this.gridWidth * this.gridHeight];
        int n = 0;
        while (n < this.gridHeight) {
            int n2 = 0;
            while (n2 < this.gridWidth) {
                this.table[n2 + n * this.gridWidth] = null;
                ++n2;
            }
            ++n;
        }
    }

    public AbstractImageGrid(int n, int n2) {
        this.gridWidth = n;
        this.gridHeight = n2;
        this.nextEntryX = 0;
        this.nextEntryY = 0;
        this.table = new AbstractGridEntry[this.gridWidth * this.gridHeight];
        int n3 = 0;
        while (n3 < this.gridHeight) {
            int n4 = 0;
            while (n4 < this.gridWidth) {
                this.table[n4 + n3 * this.gridWidth] = null;
                ++n4;
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(AbstractGridEntry abstractGridEntry) {
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            this.table[this.nextEntryX + this.nextEntryY * this.gridWidth] = abstractGridEntry;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.monitor != null) {
                this.monitor.addEntry(abstractGridEntry, this.nextEntryX, this.nextEntryY);
            }
            abstractGridEntryArray = this.table;
            synchronized (this.table) {
                this.determineNextEntryPos();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public void setSize(int n, int n2) {
        this.resizeGrid(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(AbstractGridEntry abstractGridEntry, int n, int n2) {
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            if (n > this.gridWidth - 1 || n2 > this.gridHeight - 1) {
                this.resizeGrid(Math.max(n + 1, this.gridWidth), Math.max(n2 + 1, this.gridHeight));
            }
            this.table[n + n2 * this.gridWidth] = abstractGridEntry;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.monitor != null) {
                this.monitor.addEntry(abstractGridEntry, n, n2);
            }
            abstractGridEntryArray = this.table;
            synchronized (this.table) {
                this.determineNextEntryPos();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    protected void determineNextEntryPos() {
        while (this.table[this.nextEntryX + this.nextEntryY * this.gridWidth] != null) {
            ++this.nextEntryX;
            if (this.nextEntryX > this.gridWidth - 1) {
                this.nextEntryX = 0;
                ++this.nextEntryY;
            }
            if (this.nextEntryY <= this.gridHeight - 1) continue;
            this.resizeGrid(this.gridWidth, this.nextEntryY + 2);
        }
    }

    protected void resizeGrid(int n, int n2) {
        int n3;
        AbstractGridEntry[] abstractGridEntryArray = new AbstractGridEntry[n * n2];
        int n4 = 0;
        while (n4 < Math.min(this.gridHeight, n2)) {
            n3 = 0;
            while (n3 < Math.min(this.gridWidth, n)) {
                abstractGridEntryArray[n3 + n4 * n] = this.table[n3 + n4 * this.gridWidth];
                this.table[n3 + n4 * this.gridWidth] = null;
                ++n3;
            }
            ++n4;
        }
        n4 = this.gridHeight;
        while (n4 < n2) {
            n3 = this.gridWidth;
            while (n3 < n) {
                abstractGridEntryArray[n3 + n4 * n] = null;
                ++n3;
            }
            ++n4;
        }
        this.monitor.gridResize(n, n2);
        this.table = abstractGridEntryArray;
        this.gridWidth = n;
        this.gridHeight = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractGridEntry getGridEntry(int n, int n2) {
        AbstractGridEntry abstractGridEntry = null;
        AbstractGridEntry[] abstractGridEntryArray = this.table;
        synchronized (this.table) {
            if (n < this.gridWidth && n2 < this.gridHeight) {
                abstractGridEntry = this.table[n + n2 * this.gridWidth];
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return abstractGridEntry;
        }
    }

    public abstract void displayGrid();

    public abstract void dispose();

    public abstract void setOverviewMode(boolean var1);

    public abstract boolean getOverviewMode();

    public abstract ArrayList<String> getSelections();

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setLocalProcessing(boolean bl) {
        if (this.monitor != null) {
            this.monitor.setLocalProcessing(bl);
        }
    }

    public ArrayList<GridImageEntry> getListOfEntries() {
        ArrayList<GridImageEntry> arrayList = new ArrayList<GridImageEntry>();
        int n = 0;
        while (n < this.gridHeight) {
            int n2 = 0;
            while (n2 < this.gridWidth) {
                if (this.table[n2 + n * this.gridWidth] != null) {
                    GridImageEntry gridImageEntry = new GridImageEntry(this.table[n2 + n * this.gridWidth].getFilename(), n2, n);
                    arrayList.add(gridImageEntry);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }
}

