/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram;

import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ScalingUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;

public class ColourLookupTable {
    private static final int LOOKUPTABLESIZE = 256;

    public static ColourImageData generateColourTable(IDataset iDataset, AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, AbstractMapFunction abstractMapFunction4, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, double d2, boolean bl5) {
        int n = iDataset.getShape()[1];
        int n2 = iDataset.getShape()[0];
        ColourImageData colourImageData = new ColourImageData(n, n2);
        if (bl5) {
            ScalingUtility.setSmallLogFlag(false);
            d = ScalingUtility.valueScaler(d, ScaleType.LN);
            d2 = ScalingUtility.valueScaler(d2, ScaleType.LN);
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                double d3 = iDataset.getDouble(new int[]{n3, n4});
                if (bl5) {
                    d3 = ScalingUtility.valueScaler(d3, ScaleType.LN);
                }
                d3 = (d3 - d) / (d2 - d);
                d3 = Math.min(d3, 1.0);
                d3 = Math.max(0.0, d3);
                short s = abstractMapFunction.mapToByte(d3);
                if (bl) {
                    s = (short)(255 - s);
                }
                short s2 = abstractMapFunction2.mapToByte(d3);
                if (bl2) {
                    s2 = (short)(255 - s2);
                }
                short s3 = abstractMapFunction3.mapToByte(d3);
                if (bl3) {
                    s3 = (short)(255 - s3);
                }
                short s4 = abstractMapFunction4.mapToByte(d3);
                if (bl4) {
                    s4 = (short)(255 - s4);
                }
                int n5 = ((s4 & 0xFF) << 24) + ((s & 0xFF) << 16) + ((s2 & 0xFF) << 8) + (s3 & 0xFF);
                colourImageData.set(n5, n4 + n3 * n);
                ++n4;
            }
            ++n3;
        }
        return colourImageData;
    }

    public static ColourImageData generateColourLookupTable(AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, AbstractMapFunction abstractMapFunction4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ColourImageData colourImageData = new ColourImageData(256, 1);
        int n = 0;
        while (n < 256) {
            double d = (double)n / 256.0;
            short s = abstractMapFunction.mapToByte(d);
            if (bl) {
                s = (short)(255 - s);
            }
            short s2 = abstractMapFunction2.mapToByte(d);
            if (bl2) {
                s2 = (short)(255 - s2);
            }
            short s3 = abstractMapFunction3.mapToByte(d);
            if (bl3) {
                s3 = (short)(255 - s3);
            }
            short s4 = abstractMapFunction4.mapToByte(d);
            if (bl4) {
                s4 = (short)(255 - s4);
            }
            int n2 = ((s4 & 0xFF) << 24) + ((s & 0xFF) << 16) + ((s2 & 0xFF) << 8) + (s3 & 0xFF);
            colourImageData.set(n2, n);
            ++n;
        }
        return colourImageData;
    }
}

