/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.editors;

import gda.data.nexus.tree.INexusTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.NexusTreeExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.util.NexusUtils;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetPlotView;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.ui.event.PartAdapter2;

public class NexusTreeEditor
extends EditorPart {
    private NexusTreeExplorer ntxp;
    private INexusTree nexusTree;
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.editors.NexusTreeEditor";
    private static final Logger logger = LoggerFactory.getLogger(NexusTreeEditor.class);

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        iEditorSite.getPage().addPartListener((IPartListener2)new PartAdapter2(){

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                if (iWorkbenchPartReference.getPartName().equals(NexusTreeEditor.this.getPartName())) {
                    NexusTreeEditor.this.notifyPlotView(NexusTreeEditor.this.getEditorInput());
                }
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.ntxp = new NexusTreeExplorer(composite, 0, this.getSite());
        if (this.nexusTree != null) {
            this.ntxp.setNexusTree(this.nexusTree);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        this.ntxp.setFocus();
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (!(iEditorInput instanceof IURIEditorInput)) {
            logger.warn("Editor input cannot be used here");
            return;
        }
        String string = ((IURIEditorInput)iEditorInput).getURI().getPath();
        this.setPartName(string);
        this.nexusTree = null;
        try {
            this.nexusTree = NexusUtils.loadTree(string, NexusUtils.getSel(), (IProgressMonitor)new NullProgressMonitor()).getNexusTree();
        }
        catch (Exception exception) {
            logger.warn("Could not load NeXus file {}", (Object)string);
        }
        this.notifyPlotView(iEditorInput);
    }

    private void notifyPlotView(IEditorInput iEditorInput) {
        IViewPart iViewPart = this.getEditorSite().getPage().findView("uk.ac.gda.views.nexus.NexusPlotView");
        if (iViewPart != null) {
            DataSetPlotView dataSetPlotView = (DataSetPlotView)iViewPart;
            try {
                dataSetPlotView.setFile(EclipseUtils.getFilePath((IEditorInput)iEditorInput), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                logger.error("File " + EclipseUtils.getFilePath((IEditorInput)iEditorInput) + " does not open with " + "uk.ac.gda.views.nexus.NexusPlotView", (Throwable)exception);
            }
        }
    }

    public void dispose() {
        this.ntxp.dispose();
        super.dispose();
    }
}

