/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.progress.UIJob;

public abstract class ElementLabelProvider
implements IElementLabelProvider {
    private Job fLabelJob = null;

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        String[] columnIds = update.getColumnIds();
        IPresentationContext presentationContext = update.getPresentationContext();
        TreePath elementPath = update.getElementPath();
        int numColumns = 1;
        if (columnIds != null) {
            numColumns = columnIds.length;
        }
        int i = 0;
        while (i < numColumns) {
            String columnId = null;
            if (columnIds != null) {
                columnId = columnIds[i];
            }
            update.setLabel(this.getLabel(elementPath, presentationContext, columnId), i);
            update.setImageDescriptor(this.getImageDescriptor(elementPath, presentationContext, columnId), i);
            update.setBackground(this.getBackground(elementPath, presentationContext, columnId), i);
            update.setForeground(this.getForeground(elementPath, presentationContext, columnId), i);
            update.setFontData(this.getFontData(elementPath, presentationContext, columnId), i);
            ++i;
        }
    }

    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return null;
    }

    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return null;
    }

    protected RGB getBackground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return null;
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return null;
    }

    protected abstract String getLabel(TreePath var1, IPresentationContext var2, String var3) throws CoreException;

    public synchronized void update(ILabelUpdate[] updates) {
        if (this.fLabelJob == null) {
            this.fLabelJob = this.newLabelJob(updates);
        }
        if (!((ILabelJob)this.fLabelJob).queue(updates)) {
            this.fLabelJob = this.newLabelJob(updates);
            ((ILabelJob)this.fLabelJob).queue(updates);
        }
        this.fLabelJob.schedule();
    }

    private Job newLabelJob(ILabelUpdate[] updates) {
        if (this.requiresUIJob(updates)) {
            return new UILabelJob();
        }
        return new LabelJob();
    }

    protected boolean requiresUIJob(ILabelUpdate[] updates) {
        return false;
    }

    protected ISchedulingRule getRule(ILabelUpdate update) {
        return null;
    }

    static interface ILabelJob {
        public boolean queue(ILabelUpdate[] var1);
    }

    class LabelJob
    extends Job
    implements ILabelJob {
        private LabelUpdater fUpdater;

        public LabelJob() {
            super("Label Job");
            this.fUpdater = new LabelUpdater();
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fUpdater.run();
            return Status.OK_STATUS;
        }

        public boolean queue(ILabelUpdate[] updates) {
            return this.fUpdater.queue(updates);
        }

        public boolean shouldRun() {
            return this.fUpdater.shouldRun();
        }
    }

    class LabelUpdater
    implements Runnable {
        LinkedList fQueue = new LinkedList();

        LabelUpdater() {
        }

        public synchronized boolean queue(ILabelUpdate[] updates) {
            if (this.fQueue == null) {
                return false;
            }
            int i = 0;
            while (i < updates.length) {
                this.fQueue.addLast(updates[i]);
                ++i;
            }
            return true;
        }

        public void run() {
            ILabelUpdate update = this.getNextUpdate();
            while (update != null) {
                block11: {
                    ISchedulingRule rule = ElementLabelProvider.this.getRule(update);
                    if (!update.isCanceled()) {
                        try {
                            try {
                                if (rule != null) {
                                    Job.getJobManager().beginRule(rule, null);
                                }
                                ElementLabelProvider.this.retrieveLabel(update);
                            }
                            catch (CoreException e) {
                                update.setStatus(e.getStatus());
                                if (rule != null) {
                                    Job.getJobManager().endRule(rule);
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            if (rule != null) {
                                Job.getJobManager().endRule(rule);
                            }
                            throw throwable;
                        }
                        if (rule != null) {
                            Job.getJobManager().endRule(rule);
                        }
                    }
                }
                update.done();
                update = this.getNextUpdate();
            }
        }

        public synchronized ILabelUpdate getNextUpdate() {
            if (this.fQueue == null) {
                return null;
            }
            ILabelUpdate update = null;
            try {
                update = (ILabelUpdate)this.fQueue.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.fQueue = null;
            }
            return update;
        }

        public boolean shouldRun() {
            return this.fQueue != null;
        }
    }

    class UILabelJob
    extends UIJob
    implements ILabelJob {
        private LabelUpdater fUpdater;

        public UILabelJob() {
            super("Label Job");
            this.fUpdater = new LabelUpdater();
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.fUpdater.run();
            return Status.OK_STATUS;
        }

        public boolean queue(ILabelUpdate[] updates) {
            return this.fUpdater.queue(updates);
        }

        public boolean shouldRun() {
            return this.fUpdater.shouldRun();
        }
    }
}

