/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views.run;

import uk.ac.gda.ui.views.run.ExperimentException;
import uk.ac.gda.ui.views.run.ExperimentStatus;

public abstract class ExperimentObject {
    protected String message;
    private ExperimentStatus runStatus = ExperimentStatus.READY_TO_RUN;
    private int percentComplete;
    private int repetition;
    protected int numberRepetitions = 1;
    protected String id;
    protected String cloneId;

    public abstract ExperimentObject clone();

    public abstract boolean isValid() throws ExperimentException;

    protected ExperimentObject() {
    }

    public ExperimentStatus getExperimentStatus() {
        return this.runStatus;
    }

    public void setExperimentStatus(ExperimentStatus experimentStatus) {
        this.runStatus = experimentStatus;
        if (experimentStatus == ExperimentStatus.FINISHED || experimentStatus == ExperimentStatus.SKIPPED) {
            this.setMessage(null);
        }
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Number number) {
        this.percentComplete = number.intValue();
    }

    public boolean isRunning() {
        return this.getExperimentStatus() == ExperimentStatus.RUNNING;
    }

    public boolean isAborted() {
        return this.getExperimentStatus() == ExperimentStatus.ABORTED;
    }

    public boolean isSkipped() {
        return this.getExperimentStatus() == ExperimentStatus.SKIPPED;
    }

    public int getRepetition() {
        return this.repetition;
    }

    public void setRepetition(int n) {
        this.repetition = n;
    }

    public Integer getNumberRepetitions() {
        return this.numberRepetitions;
    }

    public void setNumberRepetitions(Integer n) {
        this.numberRepetitions = n;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String string) {
        this.cloneId = string;
    }

    public abstract String getName();

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

