/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views.run;

import com.swtdesigner.ResourceManager;
import java.lang.reflect.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;
import uk.ac.gda.ui.views.run.AbstractScanController;
import uk.ac.gda.ui.views.run.ControllerStatus;
import uk.ac.gda.ui.views.run.ExperimentObject;

public abstract class ExperimentControlsView
extends ViewPart {
    protected Action back;
    protected Action pause;
    protected Action run;
    protected Action stop;
    protected Action forward;
    protected TableViewer tableViewer;
    protected boolean enabled = false;
    private boolean on = true;
    protected AbstractScanController controller;

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        Table table = new Table(composite2, 101124);
        this.createColumns(table);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setEnabled(false);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        int n = table.getColumnCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = "Column_" + n2;
            ++n2;
        }
        this.tableViewer.setColumnProperties(stringArray);
        this.tableViewer.setContentProvider((IContentProvider)this.getTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        this.tableViewer.setInput(this.getRootObject());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.addListeners();
        this.initializeToolBar();
        this.createRightClickMenu();
    }

    public void dispose() {
        super.dispose();
        if (this.getSite().getSelectionProvider() != null) {
            ((Viewer)this.getSite().getSelectionProvider()).getControl().dispose();
        }
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.tableViewer.getControl().setMenu(menuManager.createContextMenu(this.tableViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    protected void addListeners() {
    }

    protected abstract void createColumns(Table var1);

    protected abstract IStructuredContentProvider getTableContentProvider();

    protected abstract ITableLabelProvider getTableLabelProvider();

    protected abstract Object getRootObject();

    protected abstract ExperimentObject getExperimentObjectFromElement(Object var1);

    protected void createActions() {
        this.back = this.addAction("back", 0, null);
        this.pause = this.addAction("pause", 2, null);
        this.run = this.addAction("run", 0, "Run");
        this.run.setToolTipText("Run selected scan.");
        this.stop = this.addAction("stop", 0, "Halt");
        this.forward = this.addAction("forward", 0, null);
    }

    private Action addAction(final String string, int n, String string2) {
        Action action = new Action(null, n){

            public void run() {
                try {
                    String string3 = string.substring(0, 1).toUpperCase();
                    String string2 = String.valueOf(string3) + string.substring(1);
                    Method method = ExperimentControlsView.this.controller.getClass().getMethod("do" + string2, new Class[0]);
                    method.invoke((Object)ExperimentControlsView.this.controller, new Object[0]);
                    if ("Run".equals(string2)) {
                        ExperimentControlsView.this.setPlayState(ControllerStatus.PLAYING);
                    } else if ("Stop".equals(string2)) {
                        ExperimentControlsView.this.setPlayState(ControllerStatus.INACTIVE);
                        ExperimentControlsView.this.pause.setChecked(false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        if (string2 != null) {
            action.setText(string2);
        }
        action.setImageDescriptor(ResourceManager.getImageDescriptor(ExperimentControlsView.class, "/control_" + string + "_blue.png"));
        action.setId(string);
        return action;
    }

    public ExperimentObject getSelected() {
        return (ExperimentObject)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    public void setSelected(Object object) {
        try {
            try {
                this.setOn(false);
                StructuredSelection structuredSelection = new StructuredSelection(object);
                this.tableViewer.setSelection((ISelection)structuredSelection);
            }
            catch (Exception exception) {
                this.setOn(true);
            }
        }
        finally {
            this.setOn(true);
        }
    }

    protected void initializeToolBar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.back);
        iToolBarManager.add((IAction)this.pause);
        iToolBarManager.add((IAction)this.run);
        iToolBarManager.add((IAction)this.stop);
        iToolBarManager.add((IAction)this.forward);
        this.setPlayState(ControllerStatus.INACTIVE);
    }

    protected void setPlayState(ControllerStatus controllerStatus) {
        if (!this.enabled) {
            this.back.setEnabled(false);
            this.pause.setEnabled(false);
            this.run.setEnabled(false);
            this.stop.setEnabled(false);
            this.forward.setEnabled(false);
            return;
        }
        if (controllerStatus == ControllerStatus.PLAYING) {
            this.back.setEnabled(this.isBackAllowed());
            this.pause.setEnabled(true);
            this.run.setEnabled(false);
            this.stop.setEnabled(true);
            this.forward.setEnabled(this.isForwardAllowed());
            return;
        }
        if (controllerStatus == ControllerStatus.PAUSED) {
            this.back.setEnabled(false);
            this.pause.setEnabled(true);
            this.run.setEnabled(false);
            this.stop.setEnabled(true);
            this.forward.setEnabled(false);
            return;
        }
        if (controllerStatus == ControllerStatus.INACTIVE) {
            this.back.setEnabled(false);
            this.pause.setEnabled(false);
            this.run.setEnabled(true);
            this.stop.setEnabled(false);
            this.forward.setEnabled(false);
            return;
        }
    }

    private boolean isBackAllowed() {
        Object[] objectArray = this.getTableContentProvider().getElements(null);
        if (objectArray == null || objectArray.length < 1) {
            return false;
        }
        if (this.getExperimentObjectFromElement(objectArray[0]).isRunning()) {
            return false;
        }
        return !this.isNothingRunning(objectArray);
    }

    private boolean isNothingRunning(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (this.getExperimentObjectFromElement(objectArray[n]).isRunning()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isForwardAllowed() {
        Object[] objectArray = this.getTableContentProvider().getElements(null);
        if (objectArray == null || objectArray.length < 1) {
            return false;
        }
        if (this.getExperimentObjectFromElement(objectArray[objectArray.length - 1]).isRunning()) {
            return false;
        }
        return !this.isNothingRunning(objectArray);
    }

    public void setFocus() {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public Action getBack() {
        return this.back;
    }

    public Action getPause() {
        return this.pause;
    }

    public Action getRun() {
        return this.run;
    }

    public Action getStop() {
        return this.stop;
    }

    public Action getForward() {
        return this.forward;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setPlayState(this.controller.getState());
        this.tableViewer.getTable().setEnabled(bl);
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }
}

