/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.CommandServiceFacade;
import uk.ac.gda.ui.views.run.AbstractScanController;
import uk.ac.gda.ui.views.run.ControllerStatus;
import uk.ac.gda.ui.views.run.ControllerStatusEvent;
import uk.ac.gda.ui.views.run.ControllerStatusListener;
import uk.ac.gda.ui.views.run.ExperimentObject;
import uk.ac.gda.ui.views.run.ExperimentStatus;

public abstract class SingleScanControlsView
extends ViewPart {
    private static Logger logger = LoggerFactory.getLogger(SingleScanControlsView.class);
    protected Label currentScanStatus;
    protected Label currentScanName;
    protected Button pauseButton;
    protected Button runScanButton;
    protected Button stopScanButton;
    protected Composite container;
    protected Link perspectiveLink;
    private ProgressBar progressMonitor;
    private Label label;
    private SelectionAdapter selectionListener;
    private SelectionAdapter runListener;
    private SelectionAdapter pauseListener;
    private SelectionAdapter stopListener;
    private ControllerStatusListener controllerListener;

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new ColumnLayout());
        this.container = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.container.setLayout((Layout)gridLayout);
        this.label = new Label(this.container, 0);
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.progressMonitor = new ProgressBar(this.container, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 200;
        this.progressMonitor.setLayoutData((Object)gridData);
        this.progressMonitor.setVisible(false);
        this.pauseButton = new Button(this.container, 2);
        this.pauseButton.setImage(SWTResourceManager.getImage(SingleScanControlsView.class, "/control_pause_blue.png"));
        this.pauseButton.setText("Pause");
        this.pauseButton.setEnabled(false);
        this.runScanButton = new Button(this.container, 0);
        this.runScanButton.setImage(SWTResourceManager.getImage(SingleScanControlsView.class, "/control_play_blue.png"));
        this.runScanButton.setText("Run");
        this.stopScanButton = new Button(this.container, 0);
        this.stopScanButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.stopScanButton.setEnabled(false);
        this.stopScanButton.setImage(SWTResourceManager.getImage(SingleScanControlsView.class, "/control_stop_blue.png"));
        this.stopScanButton.setText("Stop");
        new Label(this.container, 0);
        this.currentScanStatus = new Label(this.container, 0);
        this.currentScanStatus.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        gridData = new GridData();
        gridData.minimumWidth = 200;
        this.currentScanStatus.setLayoutData((Object)gridData);
        this.currentScanStatus.setVisible(false);
        this.currentScanName = new Label(this.container, 0);
        GridData gridData2 = new GridData();
        gridData2.minimumWidth = 200;
        this.currentScanName.setLayoutData((Object)gridData2);
        this.currentScanName.setVisible(false);
        new Label(this.container, 0);
        this.perspectiveLink = new Link(this.container, 0);
        this.perspectiveLink.setText("<a>View Scan</a>");
        this.perspectiveLink.setEnabled(false);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    PlatformUI.getWorkbench().showPerspective(SingleScanControlsView.this.getScanPerspectiveId(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException workbenchException) {
                    logger.error("Cannot change perspective to " + SingleScanControlsView.this.getScanPerspectiveId(), (Throwable)workbenchException);
                }
            }
        };
        this.perspectiveLink.addSelectionListener((SelectionListener)this.selectionListener);
        this.addListeners();
        this.initializeToolBar();
    }

    public void dispose() {
        if (this.perspectiveLink != null && !this.perspectiveLink.isDisposed()) {
            this.perspectiveLink.removeSelectionListener((SelectionListener)this.selectionListener);
        }
        AbstractScanController.getInstance().removeControllerStatusListener(this.controllerListener);
        if (this.runScanButton != null && !this.runScanButton.isDisposed()) {
            this.runScanButton.removeSelectionListener((SelectionListener)this.runListener);
        }
        if (this.pauseButton != null && !this.pauseButton.isDisposed()) {
            this.pauseButton.removeSelectionListener((SelectionListener)this.pauseListener);
        }
        if (this.stopScanButton != null && !this.stopScanButton.isDisposed()) {
            this.stopScanButton.removeSelectionListener((SelectionListener)this.stopListener);
        }
        super.dispose();
    }

    protected void addListeners() {
        this.runListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    Object object = CommandServiceFacade.runCommand(SingleScanControlsView.this.getSite(), SingleScanControlsView.this.getRunScanCommandId());
                    if (object != null && !Boolean.FALSE.equals(object)) {
                        SingleScanControlsView.this.setButtonStatus(true);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot run " + SingleScanControlsView.this.getRunScanCommandId(), (Throwable)exception);
                }
            }
        };
        this.runScanButton.addSelectionListener((SelectionListener)this.runListener);
        this.pauseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    CommandServiceFacade.runCommand(SingleScanControlsView.this.getSite(), SingleScanControlsView.this.getPauseScanCommandId());
                }
                catch (Exception exception) {
                    logger.error("Cannot run " + SingleScanControlsView.this.getRunScanCommandId(), (Throwable)exception);
                }
            }
        };
        this.pauseButton.addSelectionListener((SelectionListener)this.pauseListener);
        this.stopListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    Object object = CommandServiceFacade.runCommand(SingleScanControlsView.this.getSite(), SingleScanControlsView.this.getStopScanCommandId());
                    if (object != null && !Boolean.FALSE.equals(object)) {
                        SingleScanControlsView.this.setButtonStatus(false);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot run " + SingleScanControlsView.this.getStopScanCommandId(), (Throwable)exception);
                }
            }
        };
        this.stopScanButton.addSelectionListener((SelectionListener)this.stopListener);
        this.controllerListener = new ControllerStatusListener(){

            @Override
            public void statusChangePerformed(ControllerStatusEvent controllerStatusEvent) {
                ExperimentObject experimentObject = controllerStatusEvent.getCurrentRun();
                SingleScanControlsView.this.currentScanName.setVisible(true);
                SingleScanControlsView.this.currentScanStatus.setVisible(true);
                if (experimentObject != null) {
                    SingleScanControlsView.this.currentScanName.setText(experimentObject.getName());
                }
                if (experimentObject != null && experimentObject.getExperimentStatus() == ExperimentStatus.RUNNING) {
                    if (experimentObject.getPercentComplete() == 100) {
                        SingleScanControlsView.this.currentScanStatus.setText("Complete");
                        SingleScanControlsView.this.progressMonitor.setVisible(false);
                        SingleScanControlsView.this.setButtonStatus(false);
                    } else {
                        SingleScanControlsView.this.progressMonitor.setVisible(true);
                        SingleScanControlsView.this.progressMonitor.setSelection(experimentObject.getPercentComplete());
                        SingleScanControlsView.this.progressMonitor.setToolTipText(String.valueOf(experimentObject.getPercentComplete()) + " %");
                        SingleScanControlsView.this.currentScanStatus.setText(experimentObject.getMessage() != null ? experimentObject.getMessage() : "");
                        SingleScanControlsView.this.setButtonStatus(true);
                    }
                } else if (controllerStatusEvent.getState() == ControllerStatus.INACTIVE) {
                    SingleScanControlsView.this.currentScanStatus.setText(experimentObject != null ? experimentObject.getExperimentStatus().getSuggestedLabel() : "Complete");
                    SingleScanControlsView.this.progressMonitor.setVisible(false);
                    SingleScanControlsView.this.setButtonStatus(false);
                }
                SingleScanControlsView.this.container.layout();
            }
        };
        AbstractScanController.getInstance().addControllerStatusListener(this.controllerListener);
    }

    protected void setButtonStatus(boolean bl) {
        this.stopScanButton.setEnabled(bl);
        this.pauseButton.setEnabled(bl);
        this.runScanButton.setEnabled(!bl);
        this.perspectiveLink.setEnabled(bl);
    }

    protected abstract String getRunScanCommandId();

    protected abstract String getPauseScanCommandId();

    protected abstract String getStopScanCommandId();

    protected abstract String getScanPerspectiveId();

    public void setFocus() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }
}

