/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.operations.LinearUndoViolationUserApprover;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.common.rcp.util.IStorageUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.RichBeanEditorPart;
import uk.ac.gda.richbeans.editors.xml.XMLBeanEditor;
import uk.ac.gda.util.beans.xml.URLResolver;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public abstract class RichBeanMultiPageEditorPart
extends MultiPageEditorPart
implements DirtyContainer,
IReusableEditor {
    private boolean undoRegistered = false;
    private static final Logger logger;
    protected Object editingBean;
    protected RichBeanEditorPart richBeanEditor;
    protected XMLBeanEditor xmlEditor;
    protected String path;
    protected UndoActionHandler undoAction;
    protected RedoActionHandler redoAction;
    protected IUndoContext context;
    private boolean allowDirtyUpdates = true;
    private boolean isDirty = false;
    private boolean pageChangeProcessing = false;

    static {
        XMLHelpers.setUrlResolver((URLResolver)EclipseUtils.getUrlResolver());
        logger = LoggerFactory.getLogger(RichBeanMultiPageEditorPart.class);
    }

    public RichBeanMultiPageEditorPart() {
        this.setPartProperty("RichBeanEditorPart", "true");
    }

    public abstract Class<?> getBeanClass();

    public abstract URL getMappingUrl();

    public abstract URL getSchemaUrl();

    protected abstract RichBeanEditorPart getRichBeanEditorPart(String var1, Object var2);

    public void setInput(IEditorInput iEditorInput) {
        this.assignInput(iEditorInput);
        this.createBean();
        this.linkUI();
        IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorPart iEditorPart;
            if (iEditorReferenceArray[n].getId().equals(this.getSite().getId()) && (iEditorPart = iEditorReferenceArray[n].getEditor(false)) != this) {
                this.getSite().getPage().closeEditor(iEditorPart, true);
            }
            ++n;
        }
    }

    protected void createBean() {
        try {
            if (this.getEditorInput() instanceof IStorageEditorInput) {
                IStorage iStorage = ((IStorageEditorInput)this.getEditorInput()).getStorage();
                InputSource inputSource = new InputSource(IStorageUtils.getContents(iStorage));
                this.editingBean = XMLHelpers.createFromXML((URL)this.getMappingUrl(), this.getBeanClass(), (URL)this.getSchemaUrl(), (InputSource)inputSource, (boolean)false);
            } else {
                this.editingBean = XMLHelpers.createFromXML((URL)this.getMappingUrl(), this.getBeanClass(), (URL)this.getSchemaUrl(), (String)this.path, (boolean)false);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    protected void createUndoRedoActions() {
        this.context = new ObjectUndoContext((Object)this);
        this.undoAction = new UndoActionHandler(this.getSite(), this.context);
        this.redoAction = new RedoActionHandler(this.getSite(), this.context);
        IOperationHistory iOperationHistory = OperationHistoryFactory.getOperationHistory();
        iOperationHistory.addOperationApprover((IOperationApprover)new NonLocalUndoUserApprover(this.context, (IEditorPart)this, new Object[]{this.getEditorInput()}, Object.class));
        iOperationHistory.addOperationApprover((IOperationApprover)new LinearUndoViolationUserApprover(this.context, (IWorkbenchPart)this));
    }

    protected void assignInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.path = EclipseUtils.getFilePath(iEditorInput);
        this.setPartName(iEditorInput.getName());
        if (this.richBeanEditor != null) {
            try {
                this.pageChangeProcessing = false;
                this.richBeanEditor.setInput(iEditorInput);
                this.richBeanEditor.setPath(this.path);
            }
            finally {
                this.pageChangeProcessing = true;
            }
        }
        if (this.xmlEditor != null) {
            this.xmlEditor.setInput(iEditorInput);
        }
    }

    protected void linkUI() {
        if (this.richBeanEditor != null) {
            try {
                this.pageChangeProcessing = false;
                super.setActivePage(0);
                this.richBeanEditor.setEditingBean(this.editingBean);
                this.richBeanEditor.linkUI(false);
            }
            finally {
                this.pageChangeProcessing = true;
            }
        }
        if (this.xmlEditor != null) {
            this.xmlEditor.setEditingBean(this.editingBean);
        }
    }

    protected void createPages() {
        this.createUndoRedoActions();
        this.richBeanEditor = this.createPage0();
        this.xmlEditor = this.createPage1();
    }

    protected RichBeanEditorPart createPage0() {
        try {
            RichBeanEditorPart richBeanEditorPart = this.getRichBeanEditorPart(this.path, this.editingBean);
            richBeanEditorPart.setUndoableContext(this.context);
            int n = this.addPage((IEditorPart)richBeanEditorPart, this.getEditorInput());
            richBeanEditorPart.linkUI(false);
            this.setPageText(n, richBeanEditorPart.getRichEditorTabText());
            return richBeanEditorPart;
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)("Error creating " + this.richBeanEditor.getRichEditorTabText() + " for " + this.getClass().getName()), null, (IStatus)partInitException.getStatus());
            return null;
        }
    }

    protected XMLBeanEditor createPage1() {
        try {
            XMLBeanEditor xMLBeanEditor = new XMLBeanEditor(this, this.getMappingUrl(), this.getSchemaUrl(), this.editingBean);
            int n = this.addPage((IEditorPart)xMLBeanEditor, this.getEditorInput());
            this.setPageText(n, "XML");
            return xMLBeanEditor;
        }
        catch (PartInitException partInitException) {
            logger.error(partInitException.getMessage(), (Throwable)partInitException);
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)("Error creating text editor for " + this.getClass().getName()), null, (IStatus)partInitException.getStatus());
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        if (this.path == null) {
            return false;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        if (!this.allowDirtyUpdates) {
            return;
        }
        this.isDirty = bl;
        this.firePropertyChange(257);
    }

    protected void initializePageSwitching() {
        super.initializePageSwitching();
        this.pageChangeProcessing = true;
    }

    protected void pageChange(int n) {
        block20: {
            if (!this.pageChangeProcessing) {
                if (!this.undoRegistered) {
                    this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RichBeanMultiPageEditorPart.this.setUIUndoRedo();
                        }
                    });
                }
                super.pageChange(n);
                return;
            }
            if (n == 1) {
                try {
                    this.setXMLUndoRedo();
                    BeanUI.uiToBean(this.richBeanEditor, this.editingBean);
                    this.xmlEditor.beanToXML(this.getPrivateXMLFields());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n == 0) {
                block18: {
                    try {
                        this.setUIUndoRedo();
                        this.xmlEditor.xmlToBean();
                    }
                    catch (Exception exception) {
                        try {
                            logger.debug("XML Validation stack trace.", (Throwable)exception);
                            boolean bl = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"XML Validation Error", (String)("The XML is not valid.\n\nDo you want to continue to change screen and lose your edits?\n\nError message:\n" + XMLBeanEditor.getSantitizedExceptionMessage(exception.getMessage())));
                            if (bl) break block18;
                            try {
                                this.pageChangeProcessing = false;
                                super.setActivePage(1);
                            }
                            finally {
                                this.pageChangeProcessing = true;
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
                try {
                    try {
                        this.allowDirtyUpdates = false;
                        this.richBeanEditor.linkUI(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.allowDirtyUpdates = true;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.allowDirtyUpdates = true;
                    throw throwable;
                }
                this.allowDirtyUpdates = true;
            }
        }
        super.pageChange(n);
    }

    protected void setUIUndoRedo() {
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        iActionBars.updateActionBars();
        OperationHistoryFactory.getOperationHistory().dispose(this.context, true, true, false);
        this.undoRegistered = true;
    }

    protected void setXMLUndoRedo() {
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.xmlEditor.getAction(ActionFactory.UNDO.getId()));
        iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.xmlEditor.getAction(ActionFactory.REDO.getId()));
        iActionBars.updateActionBars();
        OperationHistoryFactory.getOperationHistory().dispose(this.context, true, true, false);
        this.undoRegistered = true;
    }

    public void doSaveAs() {
        IFile iFile = EclipseUtils.getIFile(this.getEditorInput());
        IFolder iFolder = iFile != null ? (IFolder)iFile.getParent() : null;
        FileDialog fileDialog = new FileDialog(this.getSite().getShell(), 8192);
        fileDialog.setText("Save as XML");
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        File file = new File(this.path);
        fileDialog.setFilterPath(file.getParentFile().getAbsolutePath());
        String string = fileDialog.open();
        if (string != null) {
            FileStoreEditorInput fileStoreEditorInput;
            boolean bl;
            if (!string.endsWith(".xml")) {
                string = String.valueOf(string) + ".xml";
            }
            if ((string = this.validateFileName(string)) == null) {
                return;
            }
            File file2 = new File(string);
            if (file2.exists() && !(bl = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm File Overwrite", (String)("The file '" + file2.getName() + "' exists in '" + file2.getParentFile().getName() + "'.\n\n" + "Would you like to overwrite it?")))) {
                return;
            }
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Cannot save file.", (String)("The file '" + file2.getName() + "' cannot be created in '" + file2.getParentFile().getName() + "'.\n\n" + iOException.getMessage()));
                return;
            }
            try {
                if (!this.confirmFileNameChange(file, file2)) {
                    file2.delete();
                    return;
                }
            }
            catch (Exception exception) {
                logger.error("Cannot confirm name change", (Throwable)exception);
                return;
            }
            if (iFolder != null && iFolder.getLocation().toFile().equals(file2.getParentFile())) {
                IFile iFile2 = iFolder.getFile(file2.getName());
                try {
                    iFile2.refreshLocal(0, null);
                }
                catch (CoreException coreException) {
                    logger.error("Cannot refresh " + iFile2, (Throwable)coreException);
                }
                fileStoreEditorInput = new FileEditorInput(iFile2);
            } else {
                fileStoreEditorInput = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(file2));
            }
            this.assignInput((IEditorInput)fileStoreEditorInput);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
            this.setDirty(false);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        int n = this.getActivePage();
        if (n == 0) {
            this.richBeanEditor.doSave(iProgressMonitor);
        } else if (n == 1) {
            this.xmlEditor.doSave(iProgressMonitor);
            try {
                try {
                    this.allowDirtyUpdates = false;
                    BeanUI.beanToUI(this.editingBean, this.richBeanEditor);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.allowDirtyUpdates = true;
                }
            }
            finally {
                this.allowDirtyUpdates = true;
            }
        }
    }

    protected boolean confirmFileNameChange(File file, File file2) throws Exception {
        return true;
    }

    protected String validateFileName(String string) {
        return string;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public RichBeanEditorPart getRichBeanEditor() {
        return this.richBeanEditor;
    }

    public List<String> getPrivateXMLFields() {
        return null;
    }

    public void dispose() {
        this.editingBean = null;
        this.richBeanEditor.dispose();
        this.richBeanEditor = null;
        super.dispose();
    }
}

