/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.StringUtils;

public class LabelWrapper
extends FieldComposite
implements IFieldWidget {
    private int decimalPlaces = 2;
    private Label label;
    private NumberFormat numberFormat;
    private String text;
    private TEXT_TYPE textType;
    private String unit;

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int n) {
        this.decimalPlaces = n;
        this.numberFormat.setMaximumFractionDigits(n);
    }

    public LabelWrapper(Composite composite, int n) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this, n);
        this.mainControl = this.label;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(this.decimalPlaces);
        this.numberFormat.setGroupingUsed(false);
    }

    @Override
    public Object getValue() {
        return this.text;
    }

    public void setTextType(TEXT_TYPE tEXT_TYPE) {
        this.textType = tEXT_TYPE;
    }

    @Override
    public void setValue(Object object) {
        Object object2;
        if (this.textType == null || this.textType == TEXT_TYPE.NUMBER_WITH_UNIT) {
            this.text = object != null ? this.numberFormat.format(object) : "";
            object2 = "";
            if (!"".equals(this.text)) {
                object2 = StringUtils.keepDigits(this.text, this.decimalPlaces).toString();
                if (this.unit != null) {
                    object2 = String.valueOf(object2) + " " + this.unit;
                }
            }
            this.label.setText((String)object2);
        } else {
            this.text = object != null ? "" + object : "";
            this.label.setText(this.text);
        }
        if (this.notifyType != null && this.notifyType == FieldComposite.NOTIFY_TYPE.VALUE_CHANGED) {
            object2 = new ValueEvent(this.label, this.getFieldName());
            ((ValueEvent)object2).setValue(object);
            this.eventDelegate.notifyValueListeners((ValueEvent)object2);
        }
    }

    public double getNumericValue() throws ParseException {
        Object object = this.getValue();
        if (object == null) {
            return Double.NaN;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return this.numberFormat.parse(object.toString()).doubleValue();
    }

    protected void checkSubclass() {
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setText(String string) {
        if (this.textType == TEXT_TYPE.NUMBER_WITH_UNIT && this.getUnit() != null) {
            this.label.setText(String.valueOf(string) + " " + this.unit);
        } else {
            this.label.setText(string);
        }
    }

    public void setAlignment(int n) {
        this.label.setAlignment(n);
    }

    public static enum TEXT_TYPE {
        PLAIN_TEXT,
        NUMBER_WITH_UNIT;

    }
}

