/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;
import uk.ac.gda.richbeans.event.ValueEvent;

public class FloatSpinnerWrapper
extends SpinnerWrapper {
    private int width;
    private int precision;
    private int maximumValue;
    private double factor;

    public FloatSpinnerWrapper(Composite composite, int n) {
        this(composite, n, 3, 1);
    }

    public FloatSpinnerWrapper(Composite composite, int n, int n2, int n3) {
        super(composite, n);
        this.setFormat(n2, n3);
    }

    public void setFormat(int n, int n2) {
        this.precision = n2;
        this.setWidth(n);
        this.maximumValue = (int)Math.pow(10.0, n);
        this.factor = Math.pow(10.0, n2);
        this.spinner.setDigits(n2);
        this.spinner.setMinimum(-this.maximumValue);
        this.spinner.setMaximum(this.maximumValue);
        this.spinner.setIncrement(1);
        this.spinner.setPageIncrement(5);
        this.spinner.setSelection(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.spinner.setSelection(this.spinner.getMinimum());
            return;
        }
        this.spinner.setSelection((int)(((Number)object).doubleValue() * this.factor));
        if (this.notifyType != null && (this.notifyType == FieldComposite.NOTIFY_TYPE.ALWAYS || this.notifyType == FieldComposite.NOTIFY_TYPE.VALUE_CHANGED)) {
            ValueEvent valueEvent = new ValueEvent(this.spinner, this.getFieldName());
            valueEvent.setValue(this.getValue());
            this.eventDelegate.notifyValueListeners(valueEvent);
        }
    }

    @Override
    public Object getValue() {
        return (double)this.spinner.getSelection() / this.factor;
    }

    public void setFloat(double d) {
        this.setValue(d);
    }

    public double getFloat() {
        return ((Number)this.getValue()).doubleValue();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.spinner.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (!this.spinner.isDisposed()) {
            this.spinner.removeSelectionListener(selectionListener);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.spinner.addModifyListener(modifyListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        if (!this.spinner.isDisposed()) {
            this.spinner.removeModifyListener(modifyListener);
        }
    }

    public void setMinimum(double d) {
        this.spinner.setMinimum((int)(d * this.factor));
    }

    public void setMaximum(double d) {
        this.spinner.setMaximum((int)(d * this.factor));
    }
}

