/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.SWTResourceManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;
import uk.ac.gda.richbeans.components.selector.ListEditorUI;
import uk.ac.gda.richbeans.event.ValueEvent;

public final class VerticalListEditor
extends ListEditor {
    protected TableViewer listViewer;
    protected final Button add;
    protected final Button delete;
    protected final Button up;
    protected final Button down;
    private ISelectionChangedListener selectionChangedListener;
    private SelectionAdapter addListener;
    private SelectionAdapter deleteListener;
    private SelectionAdapter upListener;
    private SelectionAdapter downListener;
    private String[] additionalFields;
    private int[] columnWidths = new int[]{300};
    protected boolean labelProivderAdded = false;
    protected List<TableViewerColumn> extraColumns;
    private boolean isShowingAdditionalFields = false;

    public VerticalListEditor(Composite composite, int n) {
        super(composite, n, VerticalListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.setLayout((Layout)new GridLayout(1, false));
        this.listViewer = new TableViewer((Composite)this, 2820);
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!VerticalListEditor.this.isOn()) {
                    return;
                }
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                BeanWrapper beanWrapper = (BeanWrapper)iStructuredSelection.getFirstElement();
                VerticalListEditor.super.setSelectedBean(beanWrapper, true);
            }
        };
        this.listViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.listViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.setListHeight(100);
        Composite composite2 = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.add = new Button(composite2, 0);
        this.add.setImage(SWTResourceManager.getImage(VerticalListEditor.class, "add.png"));
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.setText("Add");
        this.addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!VerticalListEditor.this.getListEditorUI().isAddAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.addBean();
            }
        };
        this.add.addSelectionListener((SelectionListener)this.addListener);
        this.delete = new Button(composite2, 0);
        this.delete.setImage(SWTResourceManager.getImage(VerticalListEditor.class, "delete.png"));
        this.delete.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.delete.setText("Delete");
        this.deleteListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!VerticalListEditor.this.getListEditorUI().isDeleteAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.deleteBean();
            }
        };
        this.delete.addSelectionListener((SelectionListener)this.deleteListener);
        this.up = new Button(composite2, 4);
        this.up.setText("button");
        this.upListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!VerticalListEditor.this.getListEditorUI().isReorderAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.moveBean(-1);
            }
        };
        this.up.addSelectionListener((SelectionListener)this.upListener);
        this.down = new Button(composite2, 1028);
        this.down.setText("button");
        this.downListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (VerticalListEditor.this.editorUI instanceof ListEditorUI && !((ListEditorUI)VerticalListEditor.this.editorUI).isReorderAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.moveBean(1);
            }
        };
        this.down.addSelectionListener((SelectionListener)this.downListener);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("Compare", 2){
            private boolean show;
            {
                this.show = false;
            }

            public void run() {
                this.show = !this.show;
                VerticalListEditor.this.setShowAdditionalFields(this.show);
            }
        });
        Menu menu = menuManager.createContextMenu(this.listViewer.getControl());
        this.listViewer.getControl().setMenu(menu);
        this.editorUI = null;
    }

    @Override
    public void dispose() {
        if (this.listViewer != null && !this.listViewer.getControl().isDisposed()) {
            this.listViewer.removeSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.listViewer != null && !this.add.isDisposed()) {
            this.add.removeSelectionListener((SelectionListener)this.addListener);
        }
        if (this.delete != null && !this.delete.isDisposed()) {
            this.delete.removeSelectionListener((SelectionListener)this.deleteListener);
        }
        if (this.up != null && !this.up.isDisposed()) {
            this.up.removeSelectionListener((SelectionListener)this.upListener);
        }
        if (this.down != null && !this.down.isDisposed()) {
            this.down.removeSelectionListener((SelectionListener)this.downListener);
        }
        super.dispose();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.listViewer.getTable().setEnabled(bl);
        this.add.setEnabled(bl);
        this.delete.setEnabled(bl);
        this.up.setEnabled(bl);
        this.down.setEnabled(bl);
        if (bl) {
            this.updateButtons();
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.listViewer;
    }

    public void addBean() {
        try {
            this.addBean(this.beanTemplate.getClass().newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addBean(Object object) throws ClassCastException {
        this.addBean(object, this.getSelectedIndex() + 1);
    }

    public void addBean(Object object, int n) throws ClassCastException {
        if (!this.beanTemplate.getClass().isInstance(object)) {
            throw new ClassCastException("Bean passed to addBean is not an instance of beanTemplate.getClass()");
        }
        BeanWrapper beanWrapper = new BeanWrapper(object);
        beanWrapper.setName(this.getFreeName(beanWrapper, this.getTemplateName(), n));
        if (n < 0) {
            this.beans.add(beanWrapper);
        } else {
            this.beans.add(n, beanWrapper);
        }
        this.createProviders();
        this.listViewer.refresh();
        this.setSelectedBean(beanWrapper, true);
        this.listViewer.getControl().setFocus();
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    public void deleteBean() {
        BeanWrapper beanWrapper = this.getSelectedBeanWrapper();
        int n = this.beans.indexOf(beanWrapper);
        this.beans.remove(beanWrapper);
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            if (n > this.beans.size() - 1) {
                --n;
            }
            if (n < 0) {
                n = 0;
            }
            this.setSelectedBean((BeanWrapper)this.beans.get(n), true);
            this.listViewer.getControl().setFocus();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
        this.listViewer.refresh();
    }

    @Override
    protected void setSelectedBean(BeanWrapper beanWrapper, boolean bl) {
        this.listViewer.setSelection((ISelection)new StructuredSelection((Object)beanWrapper), true);
        super.setSelectedBean(beanWrapper, bl);
    }

    public void moveBean(int n) {
        BeanWrapper beanWrapper = this.getSelectedBeanWrapper();
        int n2 = this.beans.indexOf(beanWrapper);
        beanWrapper = (BeanWrapper)this.beans.remove(n2);
        int n3 = n2 + n;
        this.beans.add(n3, beanWrapper);
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            this.setSelectedBean((BeanWrapper)this.beans.get(n3), true);
            this.listViewer.getControl().setFocus();
        }
        this.notifyValueListeners();
        this.listViewer.refresh();
    }

    @Override
    protected void valueChanged(ValueEvent valueEvent) throws Exception {
        super.valueChanged(valueEvent);
        if (this.getNameField() != null && this.getNameField().equalsIgnoreCase(valueEvent.getFieldName()) || this.isShowingAdditionalFields) {
            this.updateName(this.lastSelectionBean);
            this.listViewer.refresh((Object)this.lastSelectionBean);
        }
    }

    @Override
    protected void updateButtons() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        boolean bl = this.getListEditorUI().isReorderAllowed(this);
        boolean bl2 = this.getListEditorUI().isAddAllowed(this);
        boolean bl3 = this.getListEditorUI().isDeleteAllowed(this);
        this.up.setEnabled(n > 0 && bl && this.isEnabled());
        this.down.setEnabled(bl && n < this.beans.size() - 1 && this.isEnabled());
        if (this.maxItems > 0) {
            this.add.setEnabled(bl2 && this.beans.size() < this.maxItems && this.isEnabled());
        } else {
            this.add.setEnabled(bl2 && this.isEnabled());
        }
        if (this.minItems > 0) {
            this.delete.setEnabled(bl3 && this.beans.size() > this.minItems && this.isEnabled());
        } else if (this.beans.isEmpty()) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(bl3 && this.isEnabled());
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.listViewer.getTable().getSelectionIndex();
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
        this.createProviders();
        if (!this.listViewer.getControl().isDisposed()) {
            this.listViewer.refresh();
        }
        try {
            if (!this.beans.isEmpty()) {
                this.setSelectedBean((BeanWrapper)this.beans.get(0), true);
            } else if (this.listeners != null) {
                BeanSelectionEvent beanSelectionEvent = new BeanSelectionEvent(this, -1, null);
                for (BeanSelectionListener beanSelectionListener : this.listeners) {
                    beanSelectionListener.selectionChanged(beanSelectionEvent);
                }
            }
            if (!this.listViewer.getControl().isDisposed()) {
                this.listViewer.refresh();
            }
        }
        finally {
            this.updateEditingUIVisibility();
            this.notifyValueListeners();
        }
    }

    private void createProviders() {
        if (this.listViewer.getContentProvider() == null) {
            this.listViewer.setContentProvider((IContentProvider)new BeanListProvider());
            this.createLabelProvider();
            if (!this.listViewer.getControl().isDisposed()) {
                this.listViewer.setInput(new Object());
            }
        }
    }

    public void setAdditionalFields(String[] stringArray) {
        this.additionalFields = stringArray;
    }

    public void setColumnWidths(int[] nArray) {
        this.columnWidths = nArray;
    }

    protected void createLabelProvider() {
        if (this.labelProivderAdded) {
            return;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.listViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.listViewer, 0, 0);
        if (this.getNameField() != null) {
            tableViewerColumn.getColumn().setText(BeansFactory.getFieldWithUpperCaseFirstLetter((String)this.getNameField()));
        } else {
            tableViewerColumn.getColumn().setText("Name");
        }
        tableViewerColumn.getColumn().setWidth(this.columnWidths[0]);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object object) {
                BeanWrapper beanWrapper = (BeanWrapper)object;
                String string = beanWrapper.getName();
                return string != null ? string : "null";
            }

            public String getToolTipText(Object object) {
                return VerticalListEditor.this.additionalFields != null ? "Right click to choose compare mode." : "";
            }
        });
        if (this.additionalFields != null) {
            this.extraColumns = new ArrayList<TableViewerColumn>(this.additionalFields.length);
            int n = 0;
            while (n < this.additionalFields.length) {
                final String string = BeansFactory.getFieldWithUpperCaseFirstLetter((String)this.additionalFields[n]);
                TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.listViewer, 0, n + 1);
                this.extraColumns.add(tableViewerColumn2);
                tableViewerColumn2.getColumn().setText(string);
                tableViewerColumn2.getColumn().setWidth(0);
                tableViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object object) {
                        BeanWrapper beanWrapper = (BeanWrapper)object;
                        Object object2 = beanWrapper.getBean();
                        try {
                            Method method = object2.getClass().getMethod("get" + string, new Class[0]);
                            return method.invoke(object2, new Object[0]).toString();
                        }
                        catch (Exception exception) {
                            return exception.getMessage();
                        }
                    }
                });
                ++n;
            }
        }
        this.labelProivderAdded = true;
    }

    public void setShowAdditionalFields(boolean bl) {
        this.isShowingAdditionalFields = bl;
        this.listViewer.getTable().setHeaderVisible(bl);
        int n = 1;
        for (TableViewerColumn tableViewerColumn : this.extraColumns) {
            if (bl) {
                tableViewerColumn.getColumn().setWidth(n < this.columnWidths.length ? this.columnWidths[n] : 200);
            } else {
                tableViewerColumn.getColumn().setWidth(0);
            }
            ++n;
        }
    }

    private class BeanListProvider
    implements IStructuredContentProvider {
        private BeanListProvider() {
        }

        public Object[] getElements(Object object) {
            return VerticalListEditor.this.beans.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

