/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.event.ValueEvent;

public final class HorizontalListEditor
extends ListEditor {
    private static final Logger logger = LoggerFactory.getLogger(HorizontalListEditor.class);
    private final TableViewer regionViewer;
    private final ISelectionChangedListener selectionChangedListener;
    private final Button add;
    private final Button delete;
    private SelectionAdapter addListener;
    private SelectionAdapter deleteListener;
    private int selectedIndex = 0;
    private String sizeField;

    public HorizontalListEditor(Composite composite, int n) {
        super(composite, n, HorizontalListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regionViewer = new TableViewer(composite2, 2818);
        this.regionViewer.getTable().setHeaderVisible(true);
        this.regionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return new Object[]{new Object()};
            }
        });
        this.regionViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                if (!HorizontalListEditor.this.isOn()) {
                    return false;
                }
                if ("Spacer".equals(string)) {
                    return false;
                }
                HorizontalListEditor.this.selectedIndex = Integer.parseInt(string);
                BeanWrapper beanWrapper = (BeanWrapper)HorizontalListEditor.this.beans.get(HorizontalListEditor.this.selectedIndex);
                HorizontalListEditor.this.setSelectedBean(beanWrapper, false);
                HorizontalListEditor.this.regionViewer.refresh();
                if (HorizontalListEditor.this.listeners != null) {
                    BeanSelectionEvent beanSelectionEvent = new BeanSelectionEvent(this, HorizontalListEditor.this.selectedIndex, beanWrapper.getBean());
                    for (BeanSelectionListener beanSelectionListener : HorizontalListEditor.this.listeners) {
                        beanSelectionListener.selectionChanged(beanSelectionEvent);
                    }
                }
                return false;
            }

            public Object getValue(Object object, String string) {
                return null;
            }

            public void modify(Object object, String string, Object object2) {
            }
        });
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!HorizontalListEditor.this.isOn()) {
                    return;
                }
                BeanWrapper beanWrapper = HorizontalListEditor.this.getSelectedBeanWrapper();
                HorizontalListEditor.this.setSelectedBean(beanWrapper, true);
            }
        };
        this.regionViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.regionViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.add = new Button(composite3, 0);
        this.add.setImage(SWTResourceManager.getImage(HorizontalListEditor.class, "add.png"));
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.add.setText("Add");
        this.addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HorizontalListEditor.this.addBean();
            }
        };
        this.add.addSelectionListener((SelectionListener)this.addListener);
        this.delete = new Button(composite3, 0);
        this.delete.setImage(SWTResourceManager.getImage(VerticalListEditor.class, "delete.png"));
        this.delete.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.delete.setText("Delete");
        this.deleteListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HorizontalListEditor.this.deleteBean();
            }
        };
        this.delete.addSelectionListener((SelectionListener)this.deleteListener);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("Add", ResourceManager.getImageDescriptor(HorizontalListEditor.class, "add.png")){

            public void run() {
                HorizontalListEditor.this.addBean();
            }
        });
        menuManager.add((IAction)new Action("Delete", ResourceManager.getImageDescriptor(HorizontalListEditor.class, "delete.png")){

            public void run() {
                HorizontalListEditor.this.deleteBean();
            }
        });
        Menu menu = menuManager.createContextMenu(this.regionViewer.getControl());
        this.regionViewer.getControl().setMenu(menu);
        this.editorUI = null;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected BeanWrapper getSelectedBeanWrapper() {
        return (BeanWrapper)this.beans.get(this.selectedIndex);
    }

    public void addBean() {
        try {
            this.addBean(this.beanTemplate.getClass().newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addBean(Object object) throws ClassCastException {
        this.addBean(object, this.getSelectedIndex() + 1);
    }

    public void addBean(Object object, int n) throws ClassCastException {
        if (!this.beanTemplate.getClass().isInstance(object)) {
            throw new ClassCastException("Bean passed to addBean is not an instance of beanTemplate.getClass()");
        }
        if (!this.getListEditorUI().isAddAllowed(this)) {
            return;
        }
        try {
            BeanWrapper beanWrapper = new BeanWrapper(object);
            beanWrapper.setName(this.getFreeName(beanWrapper, this.getTemplateName(), n));
            if (n < 0) {
                this.beans.add(beanWrapper);
            } else {
                this.beans.add(n, beanWrapper);
            }
            this.createColumns();
            this.setSelectedBean(beanWrapper, true);
            this.regionViewer.getControl().setFocus();
            this.updateEditingUIVisibility();
            this.notifyValueListeners();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteBean() {
        if (!this.getListEditorUI().isDeleteAllowed(this)) {
            return;
        }
        BeanWrapper beanWrapper = this.getSelectedBeanWrapper();
        int n = this.beans.indexOf(beanWrapper);
        this.beans.remove(beanWrapper);
        this.createColumns();
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            if (n > this.beans.size() - 1) {
                --n;
            }
            if (n < 0) {
                n = 0;
            }
            this.setSelectedBean((BeanWrapper)this.beans.get(n), true);
            this.regionViewer.getControl().setFocus();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    @Override
    public StructuredViewer getViewer() {
        return this.regionViewer;
    }

    @Override
    public void dispose() {
        if (this.regionViewer != null && !this.regionViewer.getControl().isDisposed()) {
            this.regionViewer.removeSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.regionViewer != null && !this.add.isDisposed()) {
            this.add.removeSelectionListener((SelectionListener)this.addListener);
        }
        if (this.delete != null && !this.delete.isDisposed()) {
            this.delete.removeSelectionListener((SelectionListener)this.deleteListener);
        }
        super.dispose();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.regionViewer.getTable().setEnabled(bl);
        this.add.setEnabled(bl);
        this.delete.setEnabled(bl);
        if (bl) {
            this.updateButtons();
        }
    }

    @Override
    protected void setSelectedBean(BeanWrapper beanWrapper, boolean bl) {
        super.setSelectedBean(beanWrapper, bl);
        this.selectedIndex = this.beans.indexOf(beanWrapper);
        this.regionViewer.refresh();
    }

    @Override
    protected void valueChanged(ValueEvent valueEvent) throws Exception {
        super.valueChanged(valueEvent);
        if (this.getNameField() != null && this.getNameField().equalsIgnoreCase(valueEvent.getFieldName())) {
            this.updateName(this.lastSelectionBean);
            this.regionViewer.refresh();
        }
    }

    @Override
    protected void updateButtons() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        boolean bl = this.getListEditorUI().isAddAllowed(this);
        boolean bl2 = this.getListEditorUI().isDeleteAllowed(this);
        if (this.maxItems > 0) {
            this.add.setEnabled(bl && this.beans.size() < this.maxItems && this.isEnabled());
        } else {
            this.add.setEnabled(bl && this.isEnabled());
        }
        if (this.minItems > 0) {
            this.delete.setEnabled(bl2 && this.beans.size() > this.minItems && this.isEnabled());
        } else if (this.beans.isEmpty()) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(bl2 && this.isEnabled());
        }
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
        this.createColumns();
        if (!this.beans.isEmpty()) {
            this.selectedIndex = 0;
            this.setSelectedBean((BeanWrapper)this.beans.get(0), true);
        } else if (this.listeners != null) {
            BeanSelectionEvent beanSelectionEvent = new BeanSelectionEvent(this, -1, null);
            for (BeanSelectionListener beanSelectionListener : this.listeners) {
                beanSelectionListener.selectionChanged(beanSelectionEvent);
            }
        }
        if (!this.regionViewer.getControl().isDisposed()) {
            this.regionViewer.refresh();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    private void createColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.regionViewer, (int)2);
        while (this.regionViewer.getTable().getColumns().length > 0) {
            this.regionViewer.getTable().getColumns()[0].dispose();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.beans.size());
        int n = 0;
        while (n < this.beans.size()) {
            final BeanWrapper beanWrapper = (BeanWrapper)this.beans.get(n);
            final TableViewerColumn tableViewerColumn = new TableViewerColumn(this.regionViewer, 0, n);
            tableViewerColumn.getColumn().setText(" ");
            tableViewerColumn.setLabelProvider((CellLabelProvider)new BeanColumnProvider(beanWrapper));
            tableViewerColumn.getColumn().pack();
            int n2 = 150;
            try {
                n2 = ((Number)BeansFactory.getBeanValue((Object)beanWrapper.getBean(), (String)this.getSizeField())).intValue();
            }
            catch (Exception exception) {
                logger.error("Cannot get size field " + this.getSizeField(), (Throwable)exception);
                n2 = 150;
            }
            tableViewerColumn.getColumn().setWidth(n2);
            arrayList.add(String.valueOf(n));
            tableViewerColumn.getColumn().addControlListener(new ControlListener(){

                public void controlResized(ControlEvent controlEvent) {
                    try {
                        BeansFactory.setBeanValue((Object)beanWrapper.getBean(), (String)HorizontalListEditor.this.getSizeField(), (Object)tableViewerColumn.getColumn().getWidth());
                        if (HorizontalListEditor.this.selectedIndex == HorizontalListEditor.this.beans.indexOf(beanWrapper)) {
                            BeanUI.beanToUI(beanWrapper.getBean(), HorizontalListEditor.this.editorUI);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Cannot set size field " + HorizontalListEditor.this.getSizeField(), (Throwable)exception);
                    }
                }

                public void controlMoved(ControlEvent controlEvent) {
                }
            });
            ++n;
        }
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.regionViewer, 0, this.beans.size());
        tableViewerColumn.getColumn().setText(" ");
        tableViewerColumn.getColumn().setWidth(10);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new BeanColumnProvider());
        arrayList.add("Spacer");
        this.regionViewer.setColumnProperties(arrayList.toArray(new String[arrayList.size()]));
        this.regionViewer.setInput(new Object());
    }

    public String getSizeField() {
        return this.sizeField;
    }

    public void setSizeField(String string) {
        this.sizeField = string;
    }

    public class BeanColumnProvider
    extends ColumnLabelProvider {
        private final BeanWrapper wrapper;
        private final Color blue = SWTResourceManager.getColor(10);
        private final Color white = SWTResourceManager.getColor(1);

        public BeanColumnProvider(BeanWrapper beanWrapper) {
            this.wrapper = beanWrapper;
        }

        public BeanColumnProvider() {
            this(null);
        }

        public String getText(Object object) {
            if (this.wrapper == null) {
                return "";
            }
            return this.wrapper.getName();
        }

        public Color getBackground(Object object) {
            if (this.wrapper == null) {
                return null;
            }
            if (HorizontalListEditor.this.beans.indexOf(this.wrapper) == HorizontalListEditor.this.selectedIndex) {
                return this.blue;
            }
            return null;
        }

        public Color getForeground(Object object) {
            if (this.wrapper == null) {
                return null;
            }
            if (HorizontalListEditor.this.beans.indexOf(this.wrapper) == HorizontalListEditor.this.selectedIndex) {
                return this.white;
            }
            return null;
        }
    }
}

