/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.SWTResourceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;

public final class GridListEditor
extends ListEditor {
    protected TableViewer gridTable;
    protected int selectedIndex;
    protected final int columns;
    protected final int rows;
    private Listener tableListener;
    private Map<Integer, Integer> gridMap;
    protected ColumnLabelProvider columnLabelProviderDelegate;
    private Collection<TableViewerColumn> tableColumns;
    private GRID_ORDER gridOrder;
    private int gridHeight;
    private int gridWidth;

    public GridListEditor(Composite composite, int n) {
        this(composite, n, 5, 5);
        this.setGridHeight(126);
        this.setGridWidth(130);
    }

    public GridListEditor(Composite composite, int n, int n2) {
        this(composite, n, GridListEditor.getSide(n2, n2), GridListEditor.getSide(n2, 1));
    }

    private static int getSide(int n, int n2) {
        if (n > 3) {
            return (int)Math.pow(n, 0.5);
        }
        return n2;
    }

    public GridListEditor(Composite composite, int n, int n2, int n3) {
        super(composite, n, GridListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.columns = n2;
        this.rows = n3;
        this.setLayout((Layout)new GridLayout(1, false));
        if (n3 * n2 > 1) {
            this.gridTable = new TableViewer((Composite)this, 67602);
            this.gridTable.getTable().setLinesVisible(true);
            this.createContentProvider();
            this.createLabelProvider();
            this.createEditor();
            this.tableListener = new Listener(){

                public void handleEvent(Event event) {
                    GridListEditor.this.gridTable.setSelection(null);
                }
            };
            this.gridTable.getTable().addListener(13, this.tableListener);
            this.gridTable.getControl().setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.setGridHeight(100);
            this.gridTable.setInput(new Object());
        } else {
            this.selectedIndex = 0;
        }
        this.editorUI = null;
    }

    @Override
    public StructuredViewer getViewer() {
        return this.gridTable;
    }

    @Override
    public void dispose() {
        if (this.gridTable != null && this.gridTable.getTable() != null && !this.gridTable.getTable().isDisposed()) {
            this.gridTable.getTable().removeListener(13, this.tableListener);
        }
        super.dispose();
    }

    @Override
    protected BeanWrapper getSelectedBeanWrapper() {
        return (BeanWrapper)this.beans.get(this.selectedIndex);
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected void setSelectedBean(BeanWrapper beanWrapper, boolean bl) {
        super.setSelectedBean(beanWrapper, bl);
        this.selectedIndex = this.beans.indexOf(beanWrapper);
        if (this.gridTable != null) {
            this.gridTable.refresh();
        }
    }

    @Override
    public void setValue(Object object) {
        List list = (List)object;
        this.clear();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            BeanWrapper beanWrapper = new BeanWrapper(e);
            beanWrapper.setName(String.valueOf(n));
            this.beans.add(beanWrapper);
            ++n;
        }
        if (!this.beans.isEmpty()) {
            this.selectedIndex = 0;
            this.setSelectedBean((BeanWrapper)this.beans.get(0), false);
        }
        if (this.gridTable != null) {
            this.gridTable.refresh();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    private void createEditor() {
        if (this.gridTable == null) {
            return;
        }
        String[] stringArray = new String[this.columns];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(n);
            ++n;
        }
        this.gridTable.setColumnProperties(stringArray);
        this.gridTable.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                if (!GridListEditor.this.isOn()) {
                    return false;
                }
                Integer n = (Integer)object;
                int n2 = Integer.parseInt(string);
                GridListEditor.this.selectedIndex = GridListEditor.this.getElementIndex(n, n2);
                BeanWrapper beanWrapper = (BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.selectedIndex);
                GridListEditor.this.setSelectedBean(beanWrapper, false);
                GridListEditor.this.gridTable.refresh();
                if (GridListEditor.this.listeners != null) {
                    BeanSelectionEvent beanSelectionEvent = new BeanSelectionEvent(this, GridListEditor.this.selectedIndex, beanWrapper.getBean());
                    for (BeanSelectionListener beanSelectionListener : GridListEditor.this.listeners) {
                        beanSelectionListener.selectionChanged(beanSelectionEvent);
                    }
                }
                return false;
            }

            public Object getValue(Object object, String string) {
                return null;
            }

            public void modify(Object object, String string, Object object2) {
            }
        });
    }

    private void createContentProvider() {
        if (this.gridTable == null) {
            return;
        }
        final Integer[] integerArray = new Integer[this.rows];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = n;
            ++n;
        }
        this.gridTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return integerArray;
            }
        });
    }

    public void setAdditionalLabelProvider(ColumnLabelProvider columnLabelProvider) {
        this.columnLabelProviderDelegate = columnLabelProvider;
    }

    public void setColumnWidth(int n) {
        if (this.gridTable == null) {
            return;
        }
        for (TableViewerColumn tableViewerColumn : this.tableColumns) {
            tableViewerColumn.getColumn().setWidth(n);
        }
    }

    private void createLabelProvider() {
        if (this.gridTable == null) {
            return;
        }
        this.tableColumns = new HashSet<TableViewerColumn>(7);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.gridTable, (int)2);
        int n = Math.round((float)this.gridWidth / (float)this.columns);
        if (n < 1) {
            n = 25;
        }
        int n2 = 0;
        while (n2 < this.columns) {
            final int n3 = n2++;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.gridTable, 0);
            tableViewerColumn.getColumn().setWidth(n);
            this.tableColumns.add(tableViewerColumn);
            tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                private final Color blue = SWTResourceManager.getColor(10);
                private final Color white = SWTResourceManager.getColor(1);

                public String getText(Object object) {
                    int n;
                    String string;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (string = GridListEditor.this.columnLabelProviderDelegate.getText(((BeanWrapper)GridListEditor.this.beans.get(n = GridListEditor.this.getElementIndex(object, n3))).getBean())) != null) {
                        return string;
                    }
                    if (!(object instanceof Integer)) {
                        return null;
                    }
                    n = GridListEditor.this.getElementIndex(object, n3);
                    if (GridListEditor.this.gridOrder != GRID_ORDER.CUSTOM_MAP) {
                        ++n;
                    }
                    return String.valueOf(n);
                }

                public Color getBackground(Object object) {
                    Color color;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (color = GridListEditor.this.columnLabelProviderDelegate.getBackground(((BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.getElementIndex(object, n3))).getBean())) != null) {
                        return color;
                    }
                    if (GridListEditor.this.getElementIndex(object, n3) == GridListEditor.this.selectedIndex) {
                        return this.blue;
                    }
                    return null;
                }

                public Color getForeground(Object object) {
                    Color color;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (color = GridListEditor.this.columnLabelProviderDelegate.getForeground(((BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.getElementIndex(object, n3))).getBean())) != null) {
                        return color;
                    }
                    if (GridListEditor.this.getElementIndex(object, n3) == GridListEditor.this.selectedIndex) {
                        return this.white;
                    }
                    return null;
                }

                public String getToolTipText(Object object) {
                    return "Click to select element.";
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 50;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 10000;
                }
            });
        }
    }

    public void setGridOrder(GRID_ORDER gRID_ORDER) {
        this.gridOrder = gRID_ORDER;
    }

    private int getElementIndex(Object object, int n) {
        int n2 = (Integer)object;
        if (this.gridOrder == GRID_ORDER.CUSTOM_MAP) {
            int n3 = n + n2 * this.columns;
            return this.gridMap.get(n3);
        }
        if (this.columns == this.rows) {
            if (this.gridOrder == null || this.gridOrder == GRID_ORDER.LEFT_TO_RIGHT_TOP_TO_BOTTOM) {
                return n + n2 * this.columns;
            }
            int n4 = this.rows * this.columns - this.columns;
            return n4 + n2 - n * this.columns;
        }
        return n2 * this.columns + n;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int n) {
        if (this.gridTable == null) {
            return;
        }
        this.gridHeight = n;
        GridData gridData = (GridData)this.gridTable.getControl().getLayoutData();
        gridData.heightHint = n;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int n) {
        if (this.gridTable == null) {
            return;
        }
        this.gridWidth = n;
        GridData gridData = (GridData)this.gridTable.getControl().getLayoutData();
        gridData.widthHint = n;
        int n2 = Math.round((float)this.gridWidth / (float)this.columns);
        if (n2 < 1) {
            n2 = 25;
        }
        this.setColumnWidth(n2);
        this.gridHeight = this.rows * 25;
        gridData = (GridData)this.gridTable.getControl().getLayoutData();
        gridData.heightHint = this.gridHeight;
    }

    @Override
    protected void updateButtons() {
    }

    public Map<Integer, Integer> getGridMap() {
        return this.gridMap;
    }

    public void setGridMap(Map<Integer, Integer> map) {
        this.gridMap = map;
    }

    public static enum GRID_ORDER {
        LEFT_TO_RIGHT_TOP_TO_BOTTOM,
        TOP_TO_BOTTOM_RIGHT_TO_LEFT,
        CUSTOM_MAP;

    }
}

