/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.DialogUtils;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.doe.DOEFieldType;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.components.scalebox.internal.DoubleValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.IntegerValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.ListValueComposite;
import uk.ac.gda.richbeans.components.scalebox.internal.NumberValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.RangeComposite;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;

public final class RangeDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(RangeDialog.class);
    protected RangeComposite rangeComposite;
    protected VerticalListEditor listEditor;
    protected DOEFieldType currentRange;
    protected String currentValue;
    protected Combo rangeChoice;
    protected LabelWrapper singleValueLabel;
    protected boolean isInteger;

    public RangeDialog(Shell shell, boolean bl) {
        super(shell);
        this.setShellStyle(48);
        this.setBlockOnOpen(true);
        this.isInteger = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.pack();
        shell.setText("Range");
        shell.setSize(500, 380);
        DialogUtils.centerDialog(this.getParentShell(), shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Link link = new Link(composite2, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 60;
        link.setLayoutData((Object)gridData);
        link.setText("<a>Range</a>");
        link.setToolTipText("Click link to open the 'Design of Experiments' view to show all experiments currently defined. I.e. an expansion of all ranges in the same order that they will be run");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EclipseUtils.getActivePage() != null) {
                    try {
                        EclipseUtils.getActivePage().showView("uk.ac.gda.ui.doe.DOEView");
                    }
                    catch (PartInitException partInitException) {
                        logger.error("Cannot find view 'DOEView'");
                    }
                }
            }
        });
        this.rangeChoice = new Combo(composite2, 8);
        this.rangeChoice.setItems(new String[]{"Single Value", "List", "Range"});
        this.rangeChoice.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rangeChoice.select(0);
        new Label(composite2, 0);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite3.setLayout((Layout)new GridLayout(1, false));
        this.singleValueLabel = new LabelWrapper(composite3, 0);
        this.singleValueLabel.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.singleValueLabel.setTextType(LabelWrapper.TEXT_TYPE.NUMBER_WITH_UNIT);
        this.singleValueLabel.setValue(0.0);
        GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
        this.rangeComposite = new RangeComposite(composite3, 0);
        this.rangeComposite.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
        this.listEditor = new VerticalListEditor(composite3, 0);
        this.listEditor.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.listEditor.setMinItems(1);
        this.listEditor.setMaxItems(25);
        this.listEditor.setDefaultName("0.0");
        if (this.isInteger) {
            this.listEditor.setEditorClass(IntegerValueBean.class);
        } else {
            this.listEditor.setEditorClass(DoubleValueBean.class);
        }
        ListValueComposite listValueComposite = new ListValueComposite(this.listEditor, 0);
        this.listEditor.setEditorUI((Object)listValueComposite);
        this.listEditor.setNameField("value");
        GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
        this.rangeChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RangeDialog.this.updateRangeType(RangeDialog.this.getRangeType(RangeDialog.this.rangeChoice.getSelectionIndex()), false);
            }
        });
        this.updateRangeType(this.currentRange, true);
        return composite2;
    }

    private DOEFieldType getRangeType(int n) {
        if (n == 0) {
            return DOEFieldType.SINGLE_VALUE;
        }
        if (n == 1) {
            return DOEFieldType.LIST;
        }
        if (n == 2) {
            return DOEFieldType.RANGE;
        }
        return DOEFieldType.SINGLE_VALUE;
    }

    protected void updateRangeType(DOEFieldType dOEFieldType, boolean bl) {
        List list = null;
        if (this.currentRange != null) {
            list = DOEUtils.expand((String)this.getValueInternal());
        }
        this.currentRange = dOEFieldType;
        if (dOEFieldType == DOEFieldType.SINGLE_VALUE) {
            if (list != null) {
                this.singleValueLabel.setValue(list.get(0));
            }
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, true);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
            if (bl) {
                this.rangeChoice.select(0);
            }
        } else if (dOEFieldType == DOEFieldType.LIST) {
            if (list != null) {
                List<NumberValueBean> list2 = this.isInteger ? IntegerValueBean.getBeanList(list) : DoubleValueBean.getBeanList(list);
                this.listEditor.setValue(list2);
            }
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, true);
            if (bl) {
                this.rangeChoice.select(1);
            }
        } else if (dOEFieldType == DOEFieldType.RANGE) {
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, true);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
            if (bl) {
                this.rangeChoice.select(2);
            }
            if (list != null) {
                Collections.sort(list, new Comparator<Number>(){

                    @Override
                    public int compare(Number number, Number number2) {
                        return new Double(number.doubleValue()).compareTo(new Double(number2.doubleValue()));
                    }
                });
                if (list.size() > 1) {
                    if (this.rangeComposite.isForwards()) {
                        this.rangeComposite.setValue((Number)list.get(0), (Number)list.get(list.size() - 1), 1.0);
                    } else {
                        this.rangeComposite.setValue((Number)list.get(list.size() - 1), (Number)list.get(0), 1.0);
                    }
                }
            }
        }
        this.listEditor.getParent().layout();
    }

    public DOEFieldType getRangeType() {
        return DOEFieldType.SINGLE_VALUE;
    }

    public void setValue(String string) {
        DOEFieldType dOEFieldType = DOEFieldType.getRangeType((String)string);
        if (dOEFieldType == DOEFieldType.SINGLE_VALUE) {
            Double d = Double.parseDouble(string);
            this.singleValueLabel.setValue(d);
        } else if (dOEFieldType == DOEFieldType.LIST) {
            List<NumberValueBean> list = this.isInteger ? IntegerValueBean.getBeanList(string) : DoubleValueBean.getBeanList(string);
            this.listEditor.setValue(list);
        } else if (dOEFieldType == DOEFieldType.RANGE) {
            this.rangeComposite.setValue(string);
        }
        this.updateRangeType(dOEFieldType, true);
    }

    public void setUnit(String string) {
        ((ListValueComposite)((Object)this.listEditor.getEditorUI())).getValue().setUnit(string);
        this.rangeComposite.setUnit(string);
        this.singleValueLabel.setUnit(string);
    }

    public String getValue() {
        return this.currentValue;
    }

    protected void cancelPressed() {
        this.currentRange = null;
        this.currentValue = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.currentValue = this.getValueInternal();
        super.okPressed();
    }

    private String getValueInternal() {
        if (this.currentRange == null) {
            return null;
        }
        if (this.currentRange == DOEFieldType.SINGLE_VALUE) {
            if (this.singleValueLabel == null) {
                return null;
            }
            return this.singleValueLabel.getValue().toString();
        }
        if (this.currentRange == DOEFieldType.LIST) {
            if (this.listEditor == null) {
                return null;
            }
            List list = (List)this.listEditor.getValue();
            return NumberValueBean.getString(list);
        }
        if (this.currentRange == DOEFieldType.RANGE) {
            if (this.rangeComposite == null) {
                return null;
            }
            return this.rangeComposite.getValue();
        }
        return null;
    }

    public void setBounds(NumberBox numberBox) {
        ScaleBox scaleBox = ((ListValueComposite)((Object)this.listEditor.getEditorUI())).getValue();
        scaleBox.copySettings(numberBox);
        this.rangeComposite.setBounds(numberBox);
    }
}

