/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.SWTUtils;

public class DemandBox
extends NumberBox {
    public DemandBox(Composite composite, int n) {
        this(composite, n, -1);
    }

    public DemandBox(Composite composite, int n, int n2) {
        super(composite, n);
        this.createExpressionLabel(n2);
    }

    public void demandComplete(Object object) {
        this.setEnabled(true);
        this.setValue(object);
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    public void demandComplete() {
        this.setEnabled(true);
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    public void demandBegin(double d) {
        this.setEnabled(false);
        this.setExpressionValue(d);
    }

    public void demandStep(double d) {
        this.setEnabled(false);
        this.setExpressionValue(d);
    }

    @Override
    public boolean isExpressionAllowed() {
        return true;
    }

    @Override
    public void setExpressionManager(IExpressionManager iExpressionManager) {
        this.expressionManager = null;
    }

    @Override
    protected void createTextListeners(StyledText styledText) {
        this.createFocusListener(styledText);
        this.createModifyListener(styledText);
        this.createVerifyKeyListener(styledText);
    }

    @Override
    protected void createVerifyKeyListener(StyledText styledText) {
        this.verifyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                if (verifyEvent.character == '\r') {
                    DemandBox.this.textUpdateAndFireListeners();
                }
            }
        };
        styledText.addVerifyKeyListener(this.verifyListener);
    }

    @Override
    protected void createModifyListener(StyledText styledText) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DemandBox.this.textUpdate();
            }
        };
        styledText.addModifyListener(this.modifyListener);
    }

    @Override
    protected void createFocusListener(StyledText styledText) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DemandBox.this.textUpdateAndFireListeners();
            }
        };
        styledText.addFocusListener((FocusListener)this.focusListener);
    }

    public static void main(String ... stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)"North");
        composite.setLayout((Layout)new GridLayout(1, false));
        final DemandBox demandBox = new DemandBox(composite, 0);
        demandBox.setUnit("micron");
        demandBox.setLabel("x");
        demandBox.setLabelWidth(20);
        demandBox.setLayoutData(new GridData(4, 0x1000000, true, false));
        final DemandBox demandBox2 = new DemandBox(composite, 0, 30);
        demandBox2.setUnit("micron");
        demandBox2.setLabel("y");
        demandBox2.setLabelWidth(20);
        demandBox2.setLayoutData(new GridData(4, 0x1000000, true, false));
        final DemandBox demandBox3 = new DemandBox(composite, 0);
        demandBox3.setUnit("micron");
        demandBox3.setLabel("z");
        demandBox3.setLabelWidth(20);
        demandBox3.setLayoutData(new GridData(4, 0x1000000, true, false));
        final Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Label label2 = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label2.setText("");
        final TestMover testMover = new TestMover(1.0);
        final TestMover testMover2 = new TestMover(1.0);
        testMover.setInitialPosition(5.0);
        testMover2.setInitialPosition(5.0);
        demandBox.setValue(testMover.getPosition());
        demandBox2.setValue(testMover.getPosition());
        demandBox3.setValue(testMover2.getPosition());
        testMover.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (testMover.isBusy()) {
                            demandBox.demandStep(testMover.getPosition());
                            demandBox2.demandStep(testMover.getPosition());
                        } else {
                            demandBox.demandComplete(testMover.getPosition());
                            demandBox2.demandComplete(testMover.getPosition());
                        }
                    }
                });
            }
        });
        testMover2.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (testMover2.isBusy()) {
                            demandBox3.demandStep(testMover2.getPosition());
                        } else {
                            demandBox3.demandComplete();
                        }
                    }
                });
            }
        });
        demandBox.addValueListener(new ValueAdapter("x value listener"){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                double d = valueEvent.getDoubleValue();
                demandBox.demandBegin(testMover.getPosition());
                testMover.moveTo(d);
                label2.setText("");
                shell.layout();
            }
        });
        demandBox2.addValueListener(new ValueAdapter("y value listener"){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                double d = valueEvent.getDoubleValue();
                demandBox2.demandBegin(testMover.getPosition());
                testMover.moveTo(d);
                label2.setText("");
                shell.layout();
            }
        });
        demandBox3.addValueListener(new ValueAdapter("z value listener"){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                double d = valueEvent.getDoubleValue();
                demandBox3.demandBegin(testMover2.getPosition());
                testMover2.moveTo(d);
                label2.setText("");
                shell.layout();
            }
        });
        ValueAdapter valueAdapter = new ValueAdapter("test"){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                this.addValue("x", demandBox, stringBuilder);
                this.addValue("y", demandBox2, stringBuilder);
                this.addValue("z", demandBox3, stringBuilder);
                label.setText(stringBuilder.toString());
                shell.layout();
            }

            private void addValue(String string, DemandBox demandBox4, StringBuilder stringBuilder) {
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(demandBox4.getValue());
                stringBuilder.append(" ");
                stringBuilder.append(demandBox4.getUnit());
                stringBuilder.append("    ");
            }
        };
        demandBox.addValueListener(valueAdapter);
        demandBox2.addValueListener(valueAdapter);
        demandBox3.addValueListener(valueAdapter);
        shell.pack();
        shell.setSize(400, 400);
        demandBox.on();
        demandBox2.on();
        demandBox3.on();
        SWTUtils.showCenteredShell(shell);
    }

    private static class TestMover
    extends Observable {
        private boolean busy = false;
        private double value = 0.0;
        private double stepSize = 1.0;

        TestMover(double d) {
            this.stepSize = d;
        }

        public void setInitialPosition(double d) {
            this.value = d;
        }

        public void moveTo(final double d) {
            if (this.busy) {
                return;
            }
            this.busy = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    double d2 = TestMover.this.value > d ? -TestMover.this.stepSize : TestMover.this.stepSize;
                    while (true) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (d2 < 0.0 && TestMover.this.value <= d || d2 > 0.0 && TestMover.this.value >= d) break;
                        TestMover testMover = TestMover.this;
                        testMover.value = testMover.value + d2;
                        TestMover.this.setChanged();
                        TestMover.this.notifyObservers(TestMover.this.value);
                    }
                    TestMover.this.setChanged();
                    TestMover.this.notifyObservers();
                    TestMover.this.busy = false;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }

        public double getPosition() {
            return this.value;
        }

        public boolean isBusy() {
            return this.busy;
        }
    }
}

