/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;

class DecimalScale {
    private Scale scale;
    private double offset = 0.0;
    private double scaleset = 1.0;
    private double minimum = 0.0;
    private double maximum = 100.0;

    public DecimalScale(Composite composite, int n) {
        this.scale = new Scale(composite, n);
    }

    private final int toScale(double d) {
        d += this.offset;
        return (int)(d *= this.scaleset);
    }

    private final double toWorld(double d) {
        d /= this.scaleset;
        return d -= this.offset;
    }

    public double getSelection() {
        return this.toWorld(this.scale.getSelection());
    }

    public void setSelection(double d) {
        this.scale.setSelection(this.toScale(d));
    }

    private void calculateOffset() {
        this.offset = this.minimum >= 0.0 && this.maximum > 0.0 ? 0.0 : -1.0 * this.minimum;
        this.scale.setMinimum(this.toScale(this.minimum));
        this.scale.setMaximum(this.toScale(this.maximum));
    }

    public double getMinimum() {
        return this.toWorld(this.scale.getMinimum());
    }

    public void setMinimum(double d) {
        this.minimum = d;
        if (d >= this.maximum) {
            this.maximum = d + 1.0;
        }
        this.calculateOffset();
    }

    public double getMaximum() {
        return this.toWorld(this.scale.getMaximum());
    }

    public void setMaximum(double d) {
        this.maximum = d;
        if (d <= this.minimum) {
            this.minimum = d - 1.0;
        }
        this.calculateOffset();
    }

    public void setLayoutData(Object object) {
        this.scale.setLayoutData(object);
    }

    public void addListener(int n, Listener listener) {
        this.scale.addListener(n, listener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.scale.addFocusListener(focusListener);
    }

    public void setDecimalPlaces(int n) {
        this.scaleset = Math.pow(10.0, n);
    }

    public void setIncrement(double d) {
        this.scale.setIncrement((int)(d * this.scaleset));
    }

    public void setPageIncrement(double d) {
        this.scale.setPageIncrement((int)(d * this.scaleset));
    }
}

