/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.file;

import java.io.File;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.ui.content.FileContentProposalProvider;
import uk.ac.gda.ui.content.IFilterExtensionProvider;
import uk.ac.gda.ui.utils.SWTUtils;

public class FileBox
extends FieldComposite
implements IFieldWidget,
IFilterExtensionProvider {
    private ChoiceType choiceType = ChoiceType.FULL_PATH;
    private final EventManagerDelegate eventDelegate;
    private final Text text;
    private String[] filterExtensions;
    private String fileTitle;
    private File selectedFolder;
    private ModifyListener modifyListener;
    private SelectionAdapter selectionListener;
    private Button button;
    private boolean active = true;

    public FileBox(Composite composite, int n) {
        super(composite, n);
        this.setLayout(new BorderLayout());
        this.eventDelegate = new EventManagerDelegate(this);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)"Center");
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ValueEvent valueEvent = new ValueEvent(FileBox.this, FileBox.this.getFieldName());
                valueEvent.setValue(FileBox.this.getValue());
                FileBox.this.eventDelegate.notifyValueListeners(valueEvent);
            }
        };
        this.text.addModifyListener(this.modifyListener);
        FileContentProposalProvider fileContentProposalProvider = new FileContentProposalProvider();
        fileContentProposalProvider.setFilterExtensionProv(this);
        new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)fileContentProposalProvider, null, null);
        this.button = new Button((Composite)this, 8);
        this.button.setText("..");
        this.button.setLayoutData((Object)"East");
        this.selectionListener = new SelectionAdapter(){
            private FileDialog dialog;

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                if (this.dialog == null) {
                    this.dialog = new FileDialog(FileBox.this.getShell(), 4096);
                    string = FileBox.this.getFileTitle();
                    if (string != null) {
                        this.dialog.setText(string);
                    }
                }
                this.dialog.setFilterExtensions(FileBox.this.getFilterExtensions());
                if (FileBox.this.text.getText() != null) {
                    try {
                        if (FileBox.this.selectedFolder != null) {
                            this.dialog.setFilterPath(FileBox.this.selectedFolder.getAbsolutePath());
                        }
                        this.dialog.setFileName(FileBox.this.text.getText());
                    }
                    catch (Exception exception) {}
                }
                if ((string = this.dialog.open()) == null) {
                    return;
                }
                FileBox.this.setValue(string);
            }
        };
        this.button.addSelectionListener((SelectionListener)this.selectionListener);
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
            this.text.dispose();
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeSelectionListener((SelectionListener)this.selectionListener);
            this.button.dispose();
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        if (this.getChoiceType() == ChoiceType.FULL_PATH) {
            return new File(this.selectedFolder, this.text.getText()).getAbsolutePath();
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.text.setText("");
            return;
        }
        if (this.getChoiceType() == ChoiceType.FULL_PATH || object.toString().contains(System.getProperty("file.separator"))) {
            File file = new File(object.toString());
            this.selectedFolder = file.getParentFile();
            this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
            this.text.setText(file.getName());
            this.text.setSelection(file.getName().length());
        } else {
            if (this.selectedFolder != null) {
                this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
            }
            this.text.setText((String)object);
            this.text.setSelection(((String)object).length());
        }
    }

    public void setError(boolean bl, String string) {
        if (bl) {
            Color color = this.getDisplay().getSystemColor(3);
            if (!color.isDisposed()) {
                this.text.setForeground(color);
            }
            this.text.setToolTipText(string);
        } else {
            Color color = this.getDisplay().getSystemColor(2);
            if (!color.isDisposed()) {
                this.text.setForeground(color);
            }
            this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
        this.setVisible(bl);
    }

    @Override
    public void addValueListener(ValueListener valueListener) {
        this.eventDelegate.addValueListener(valueListener);
    }

    @Override
    public void removeValueListener(ValueListener valueListener) {
        this.eventDelegate.removeValueListener(valueListener);
    }

    @Override
    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public static void main(String ... stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)"North");
        composite.setLayout((Layout)new ColumnLayout());
        FileBox fileBox = new FileBox(composite, 0);
        fileBox.setLayoutData(new ColumnLayoutData(200));
        fileBox.setFilterExtensions(new String[]{"*.xml", "*.txt"});
        fileBox.setFileTitle("XML or Text file chooser");
        FileBox fileBox2 = new FileBox(composite, 0);
        fileBox2.setLayoutData(new ColumnLayoutData(200));
        fileBox2.setFilterExtensions(new String[]{"*.jpg", "*.png"});
        FileBox fileBox3 = new FileBox(composite, 0);
        fileBox3.setLayoutData(new ColumnLayoutData(200));
        shell.pack();
        shell.setSize(400, 400);
        SWTUtils.showCenteredShell(shell);
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public void setFileTitle(String string) {
        this.fileTitle = string;
    }

    public void setFolder(File file) {
        this.selectedFolder = file;
        this.text.setToolTipText(file.getAbsolutePath());
    }

    public void setText(String string) {
        if (string == null) {
            this.text.setText("");
            return;
        }
        this.text.setText(string);
    }

    public String getText() {
        return this.text.getText();
    }

    public ChoiceType getChoiceType() {
        return this.choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public File getFolder() {
        return this.selectedFolder;
    }

    public static enum ChoiceType {
        FULL_PATH,
        NAME_ONLY;

    }
}

