/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.components.cell.IXMLFileListProvider;

public class XMLChooserEditor
extends CellEditor {
    private IFolder containingFolder;
    private IXMLFileListProvider fileListProvider;
    private CCombo comboBox;
    private List<String> names;
    private KeyAdapter keyListener;
    private SelectionAdapter selectionListener;
    private TraverseListener traverseListener;
    private FocusAdapter focusListener;
    private IResourceChangeListener resourceChangeListener;

    public XMLChooserEditor(Composite composite, IFolder iFolder, IXMLFileListProvider iXMLFileListProvider) {
        super(composite);
        this.containingFolder = iFolder;
        this.fileListProvider = iXMLFileListProvider;
    }

    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.comboBox = new CCombo(composite2, 8);
        this.comboBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboBox.setFont(composite.getFont());
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                XMLChooserEditor.this.keyReleaseOccured(keyEvent);
            }
        };
        this.comboBox.addKeyListener((KeyListener)this.keyListener);
        this.selectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                XMLChooserEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        };
        this.comboBox.addSelectionListener((SelectionListener)this.selectionListener);
        this.traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2 || traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                }
            }
        };
        this.comboBox.addTraverseListener(this.traverseListener);
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                XMLChooserEditor.this.focusLost();
            }
        };
        this.comboBox.addFocusListener((FocusListener)this.focusListener);
        return composite2;
    }

    public void dispose() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener((KeyListener)this.keyListener);
        }
        if (this.selectionListener != null) {
            this.comboBox.removeSelectionListener((SelectionListener)this.selectionListener);
        }
        if (this.traverseListener != null) {
            this.comboBox.removeTraverseListener(this.traverseListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener((FocusListener)this.focusListener);
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        super.dispose();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gC = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gC.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gC.dispose();
        }
        return layoutData;
    }

    protected Object doGetValue() {
        int n;
        if (this.comboBox != null && (n = this.comboBox.getSelectionIndex()) >= 0 && n < this.getNames().size()) {
            return this.getNames().get(n);
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.comboBox != null) {
            this.comboBox.setFocus();
        }
    }

    protected void doSetValue(Object object) {
        if (this.comboBox != null) {
            this.comboBox.setItems(this.getNames().toArray(new String[this.getNames().size()]));
            this.comboBox.select(this.getNames().indexOf(object));
        }
    }

    private List<String> getNames() {
        if (this.names == null) {
            this.names = new ArrayList<String>();
            try {
                if (this.containingFolder != null) {
                    List<IFile> list = this.fileListProvider.getSortedFileList(this.containingFolder);
                    for (IFile iFile : list) {
                        this.names.add(iFile.getName());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.resourceChangeListener == null) {
                this.resourceChangeListener = new IResourceChangeListener(){

                    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                        XMLChooserEditor.this.names = null;
                    }
                };
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
            }
        }
        return this.names;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        int n = this.comboBox.getSelectionIndex();
        Object object = this.doGetValue();
        this.markDirty();
        boolean bl = this.isCorrect(object);
        this.setValueValid(bl);
        if (!bl) {
            if (this.getNames().size() > 0 && n >= 0 && n < this.getNames().size()) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.getNames().get(n)));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }
}

