/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.BoundsUpdater;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class EventManagerDelegate {
    private IFieldWidget parent;
    protected Collection<ValueListener> valueListeners;
    protected Map<String, ValueListener> valueListenersMap;
    protected Collection<BoundsListener> boundsListeners;

    public EventManagerDelegate(IFieldWidget iFieldWidget) {
        this.parent = iFieldWidget;
    }

    public void addValueListener(ValueListener valueListener) {
        if (valueListener.getValueListenerName() != null) {
            if (this.valueListenersMap == null) {
                this.valueListenersMap = new HashMap<String, ValueListener>(3);
            }
            this.valueListenersMap.put(valueListener.getValueListenerName(), valueListener);
            return;
        }
        if (this.valueListeners == null) {
            this.valueListeners = new HashSet<ValueListener>(3);
        }
        this.valueListeners.add(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        if (valueListener.getValueListenerName() != null) {
            if (this.valueListenersMap == null) {
                return;
            }
            this.valueListenersMap.remove(valueListener.getValueListenerName());
            return;
        }
        if (this.valueListeners == null) {
            return;
        }
        this.valueListeners.remove(valueListener);
    }

    public void notifyValueListeners(ValueEvent valueEvent) {
        if (!this.checkCanNofity()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (this.valueListenersMap != null) {
                    for (ValueListener valueListener : this.valueListenersMap.values()) {
                        valueListener.valueChangePerformed(valueEvent);
                    }
                }
                if (this.valueListeners != null) {
                    for (ValueListener valueListener : this.valueListeners) {
                        valueListener.valueChangePerformed(valueEvent);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.parent.on();
        }
    }

    public void notifyBoundsProviderListeners(ValueEvent valueEvent) {
        if (!this.checkCanNofity()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (this.valueListenersMap != null) {
                    for (ValueListener valueListener : this.valueListenersMap.values()) {
                        if (!(valueListener instanceof BoundsUpdater)) continue;
                        valueListener.valueChangePerformed(valueEvent);
                    }
                }
                if (this.valueListeners != null) {
                    for (ValueListener valueListener : this.valueListeners) {
                        if (!(valueListener instanceof BoundsUpdater)) continue;
                        valueListener.valueChangePerformed(valueEvent);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.parent.on();
        }
    }

    private boolean checkCanNofity() {
        FieldComposite fieldComposite;
        if (this.parent == null) {
            return false;
        }
        if (this.valueListeners == null && this.valueListenersMap == null) {
            return false;
        }
        if (this.valueListeners != null && this.valueListenersMap != null && this.valueListeners.isEmpty() && this.valueListenersMap.isEmpty()) {
            return false;
        }
        if (this.valueListeners == null && this.valueListenersMap != null && this.valueListenersMap.isEmpty()) {
            return false;
        }
        if (this.valueListenersMap == null && this.valueListeners != null && this.valueListeners.isEmpty()) {
            return false;
        }
        FieldComposite fieldComposite2 = fieldComposite = this.parent instanceof FieldComposite ? (FieldComposite)this.parent : null;
        return fieldComposite != null && fieldComposite.getNotifyType() != null && fieldComposite.getNotifyType() == FieldComposite.NOTIFY_TYPE.ALWAYS || this.parent.isOn();
    }

    public void addBoundsListener(BoundsListener boundsListener) {
        if (this.boundsListeners == null) {
            this.boundsListeners = new HashSet<BoundsListener>(3);
        }
        this.boundsListeners.add(boundsListener);
    }

    public void removeBoundsListener(BoundsListener boundsListener) {
        if (this.boundsListeners == null) {
            return;
        }
        this.boundsListeners.remove(boundsListener);
    }

    public void notifyBoundsListeners(BoundsEvent boundsEvent) {
        if (this.boundsListeners == null) {
            return;
        }
        if (!this.parent.isOn()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (boundsEvent.getMode() == BoundsEvent.Mode.GREATER) {
                    for (BoundsListener boundsListener : this.boundsListeners) {
                        boundsListener.valueGreater(boundsEvent);
                    }
                } else if (boundsEvent.getMode() == BoundsEvent.Mode.LESS) {
                    for (BoundsListener boundsListener : this.boundsListeners) {
                        boundsListener.valueLess(boundsEvent);
                    }
                } else if (boundsEvent.getMode() == BoundsEvent.Mode.LEGAL) {
                    for (BoundsListener boundsListener : this.boundsListeners) {
                        boundsListener.valueLegal(boundsEvent);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.parent.on();
        }
    }

    public void dispose() {
        if (this.valueListeners != null) {
            this.valueListeners.clear();
        }
        if (this.valueListenersMap != null) {
            this.valueListenersMap.clear();
        }
        if (this.boundsListeners != null) {
            this.boundsListeners.clear();
        }
        this.parent = null;
    }
}

