/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import uk.ac.gda.util.list.SortNatural;

public class ISortingUtils {
    public static final Comparator<IResource> DEFAULT_COMPARATOR = new Comparator<IResource>(){

        @Override
        public int compare(IResource iResource, IResource iResource2) {
            return iResource.getLocation().toString().compareTo(iResource2.getLocation().toString());
        }
    };
    public static final Comparator<IResource> NATURAL_COMPARATOR = new SortNatural(true);

    public static List<IResource> getSortedFileList(IContainer iContainer, Comparator<IResource> comparator) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        if (iResourceArray == null || iResourceArray.length < 1) {
            return null;
        }
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceArray.length);
        arrayList.addAll(Arrays.asList(iResourceArray));
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static Collection<IResource> getSortedFileListIgnoreHidden(IContainer iContainer, Comparator<IResource> comparator) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        if (iResourceArray == null || iResourceArray.length < 1) {
            return null;
        }
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.exists() && !iResource.isHidden() && !iResource.isPhantom() && !iResource.getLocation().toFile().isHidden() && iResource.isAccessible()) {
                arrayList.add(iResource);
            }
            ++n;
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static List<IFolder> getSortedFolderList(IContainer iContainer) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        if (iResourceArray == null || iResourceArray.length < 1) {
            return null;
        }
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>(7);
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFolder) {
                arrayList.add((IFolder)iResourceArray[n]);
            }
            ++n;
        }
        Collections.sort(arrayList, DEFAULT_COMPARATOR);
        return arrayList;
    }

    public static List<IFile> getSortedFileList(IFolder iFolder, String string) throws CoreException {
        IResource[] iResourceArray = iFolder.members();
        if (iResourceArray == null || iResourceArray.length < 1) {
            return null;
        }
        ArrayList<IFile> arrayList = new ArrayList<IFile>(7);
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFile && (string == null || iResourceArray[n].getName().endsWith(string))) {
                arrayList.add((IFile)iResourceArray[n]);
            }
            ++n;
        }
        Collections.sort(arrayList, DEFAULT_COMPARATOR);
        return arrayList;
    }
}

