/*
 * Decompiled with CFR 0.152.
 */
package swing2swt.layout;

import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.AWTLayout;

public class FlowLayout
extends AWTLayout {
    public static final int CENTER = 1;
    public static final int LEADING = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int TRAILING = 5;
    private int hgap;
    private int vgap;
    private int align;
    private Vector<Control> currentLine = new Vector();

    public FlowLayout() {
        this(1);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.setAlignment(n);
        this.hgap = n2;
        this.vgap = n3;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = new Point(0, 0);
        Control[] controlArray = composite.getChildren();
        int n3 = 0;
        int n4 = 0;
        while (n4 < controlArray.length) {
            Point point2 = this.getPreferredSize(controlArray[n4], n, n2, bl);
            point.x += point2.x;
            point.y = Math.max(point2.y, point.y);
            ++n3;
            ++n4;
        }
        if (n3 > 0) {
            point.x += (n3 + 1) * this.hgap;
            point.y += this.vgap;
        }
        return point;
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        int n = rectangle.x + this.hgap;
        int n2 = rectangle.y + this.vgap;
        int n3 = this.hgap;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            Control control = controlArray[n5];
            if (controlArray[n5].isVisible()) {
                Point point = this.getPreferredSize(control, -1, -1, bl);
                if (n3 + point.x > rectangle.width && this.currentLine.size() > 0) {
                    this.alignCurrentLine(rectangle, n3, n4);
                    this.currentLine.clear();
                    n = rectangle.x + this.hgap;
                    n2 += n4 + this.vgap;
                    n4 = this.hgap;
                    n3 = 0;
                }
                control.setBounds(n, n2, point.x, point.y);
                this.currentLine.add(control);
                n3 += point.x + this.hgap;
                n4 = Math.max(n4, point.y);
                n += point.x + this.hgap;
            }
            ++n5;
        }
        this.alignCurrentLine(rectangle, n3, n4);
        this.currentLine.clear();
    }

    private void alignCurrentLine(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        while (n3 < this.currentLine.size()) {
            Control control = this.currentLine.get(n3);
            Rectangle rectangle2 = control.getBounds();
            int n4 = rectangle2.x;
            if (this.align == 1) {
                n4 += (rectangle.width - n) / 2;
            } else if (this.align == 4) {
                n4 += rectangle.width - n;
            }
            int n5 = rectangle2.y + (n2 - rectangle2.height) / 2;
            control.setLocation(n4, n5);
            ++n3;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int n) {
        if (n == 2 || n == 5) {
            ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            n = n == 2 ? (componentOrientation.isLeftToRight() ? 3 : 4) : (componentOrientation.isLeftToRight() ? 4 : 3);
        }
        this.align = n;
    }
}

